/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal.listeners;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Named;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.annotations.lifecycle.BeginTask;
import org.eclipse.tea.core.annotations.lifecycle.BeginTaskChain;
import org.eclipse.tea.core.annotations.lifecycle.DisposeContext;
import org.eclipse.tea.core.annotations.lifecycle.FinishTask;
import org.eclipse.tea.core.annotations.lifecycle.FinishTaskChain;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.services.TaskingLifeCycleListener;
import org.osgi.service.component.annotations.Component;

@TaskingLifeCycleListener.TaskingLifeCyclePriority(value=100)
@Component
public class TaskingStatusTracker
implements TaskingLifeCycleListener {
    private final Map<Key, IStatus> statusMap = new HashMap<Key, IStatus>();
    private final Map<Key, Long> durationMap = new HashMap<Key, Long>();
    private final Map<TaskExecutionContext, Long> ctxDurationMap = new HashMap<TaskExecutionContext, Long>();
    private final Map<TaskExecutionContext, IStatus> ctxStatusMap = new HashMap<TaskExecutionContext, IStatus>();

    @BeginTaskChain
    public void init(TaskExecutionContext context, MultiStatus overallStatus) {
        this.ctxDurationMap.put(context, System.currentTimeMillis());
        this.ctxStatusMap.put(context, (IStatus)overallStatus);
    }

    @BeginTask
    public void start(TaskExecutionContext context, @Named(value="org.eclipse.tea.core.task") @Named(value="org.eclipse.tea.core.task") Object task) {
        this.durationMap.put(new Key(task, context), System.currentTimeMillis());
    }

    @FinishTask
    public void stop(TaskExecutionContext context, @Named(value="org.eclipse.tea.core.task") @Named(value="org.eclipse.tea.core.task") Object task, IStatus taskStatus) {
        Key key = new Key(task, context);
        Long start = this.durationMap.get(key);
        if (start == null) {
            throw new IllegalStateException("no start time set for task: " + TaskingModel.getTaskName(task));
        }
        this.durationMap.put(key, System.currentTimeMillis() - start);
        this.statusMap.put(key, taskStatus);
    }

    @FinishTaskChain
    public void done(TaskExecutionContext context, MultiStatus overallStatus) {
        Long start = this.ctxDurationMap.get(context);
        if (start == null) {
            throw new IllegalStateException("no start time set for context: " + context);
        }
        this.ctxDurationMap.put(context, System.currentTimeMillis() - start);
    }

    @DisposeContext
    public void removeContext(TaskExecutionContext context) {
        this.ctxDurationMap.remove(context);
        this.ctxStatusMap.remove(context);
        HashSet toRemove = new HashSet();
        Stream.concat(this.durationMap.keySet().stream(), this.statusMap.keySet().stream()).filter(k -> ((Key)k).context.equals(context)).forEach(toRemove::add);
        toRemove.forEach(this.durationMap::remove);
        toRemove.forEach(this.statusMap::remove);
    }

    public long getDuration(TaskExecutionContext context) {
        return this.ctxDurationMap.getOrDefault(context, 0L);
    }

    public IStatus getStatus(TaskExecutionContext context) {
        return this.ctxStatusMap.getOrDefault(context, null);
    }

    public long getDuration(TaskExecutionContext context, Object task) {
        return this.durationMap.getOrDefault(new Key(task, context), 0L);
    }

    public IStatus getStatus(TaskExecutionContext context, Object task) {
        return this.statusMap.getOrDefault(new Key(task, context), null);
    }

    private static class Key {
        private final TaskExecutionContext context;
        private final Object task;

        public Key(Object task, TaskExecutionContext context) {
            this.task = task;
            this.context = context;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
            result = 31 * result + (this.task == null ? 0 : this.task.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
                return false;
            }
            return !(this.task == null ? other.task != null : !this.task.equals(other.task));
        }
    }
}

