/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.model;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.tea.library.build.jar.JarManager;
import org.eclipse.tea.library.build.jar.ZipExec;
import org.eclipse.tea.library.build.jar.ZipExecFactory;
import org.eclipse.tea.library.build.jar.ZipExecPart;
import org.eclipse.tea.library.build.model.BundleBuild;
import org.eclipse.tea.library.build.model.MavenExternalJarBuild;
import org.eclipse.tea.library.build.model.ParameterValue;
import org.eclipse.tea.library.build.model.PluginData;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.util.FileUtils;

public class PluginBuild
extends BundleBuild<PluginData>
implements Comparable<PluginBuild> {
    protected Set<PluginBuild> sourceDependencies;
    protected Set<MavenExternalJarBuild> mavenDependencies;
    protected Set<String> workspaceDependencies;
    protected final Set<PluginBuild> fragments = new TreeSet<PluginBuild>();
    public static final Pattern MAVEN_COORDINATE_PATTERN = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");

    public PluginBuild(PluginData data) {
        super(data);
    }

    public final String getPluginName() {
        return ((PluginData)this.data).getBundleName();
    }

    public final File getPluginDirectory() {
        return ((PluginData)this.data).bundleDir;
    }

    public final Collection<PluginBuild> getSourceDependencies() {
        return this.sourceDependencies;
    }

    public final Collection<MavenExternalJarBuild> getMavenExternalJarDependencies() {
        return this.mavenDependencies;
    }

    public final Collection<String> getWorkspaceDependencies() {
        return this.workspaceDependencies;
    }

    public final Collection<PluginBuild> getFragments() {
        return this.fragments;
    }

    @Override
    public int compareTo(PluginBuild o) {
        return this.getPluginName().compareTo(o.getPluginName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PluginBuild)) {
            return false;
        }
        PluginBuild other = (PluginBuild)obj;
        return this.getPluginName().equals(other.getPluginName());
    }

    public int hashCode() {
        return this.getPluginName().hashCode();
    }

    public String toString() {
        return this.getPluginName();
    }

    protected void updateDependencies(WorkspaceBuild ws) {
        ParameterValue pv;
        this.sourceDependencies = new TreeSet<PluginBuild>();
        this.workspaceDependencies = new TreeSet<String>();
        this.mavenDependencies = new TreeSet<MavenExternalJarBuild>();
        ParameterValue[] parameterValueArray = ((PluginData)this.data).getDependencies();
        int n = parameterValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            pv = parameterValueArray[n2];
            this.addSourceDependency(ws, pv.getValue());
            ++n2;
        }
        parameterValueArray = ((PluginData)this.data).getMavenDependencies();
        n = parameterValueArray.length;
        n2 = 0;
        while (n2 < n) {
            pv = parameterValueArray[n2];
            this.addMavenDependency(ws, pv.getValue());
            ++n2;
        }
        ParameterValue fragmentHost = ((PluginData)this.data).getFragmentHost();
        if (fragmentHost != null) {
            PluginBuild host = this.addSourceDependency(ws, fragmentHost.getValue());
            if (host != null) {
                host.fragments.add(this);
            } else {
                ws.addHostLessFragment(this);
            }
        }
    }

    private void addMavenDependency(WorkspaceBuild ws, String value) {
        Matcher matcher = MAVEN_COORDINATE_PATTERN.matcher(value);
        if (matcher.matches()) {
            this.mavenDependencies.add(new MavenExternalJarBuild(matcher.group(0)));
        }
    }

    private PluginBuild addSourceDependency(WorkspaceBuild ws, String name) {
        PluginBuild pb = ws.sourcePlugins.get(name);
        if (pb != null) {
            this.sourceDependencies.add(pb);
            this.workspaceDependencies.add(name);
        } else if (ws.isClosedOrIncomplete(name)) {
            this.workspaceDependencies.add(name);
        }
        return pb;
    }

    @Override
    public String getJarFileName(String buildVersion) {
        return String.valueOf(this.getPluginName()) + '_' + buildVersion + ".jar";
    }

    public File getBinaryJarFile() throws Exception {
        if (!((PluginData)this.data).isBinary()) {
            throw new IllegalStateException(this + " is not binary!");
        }
        IResource[] iResourceArray = ((PluginData)this.data).getProject().members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            String name = r.getName();
            if (name.startsWith(((PluginData)this.data).getBundleName()) && name.endsWith(".jar")) {
                return r.getLocation().toFile();
            }
            ++n2;
        }
        throw new IllegalStateException(this + " has no binary file even though it is binary?!");
    }

    @Override
    public File execJarCommands(ZipExecFactory zip, File distDirectory, String buildVersion, JarManager jarManager) throws Exception {
        return this.execJarCommands(zip, distDirectory, buildVersion, true);
    }

    public File execJarCommands(ZipExecFactory zip, File distDirectory, String buildVersion, boolean withBinInc) throws Exception {
        String oldBundleVersion = ((PluginData)this.data).getBundleVersion();
        File manifest = ((PluginData)this.data).getManifestFile();
        if (oldBundleVersion == null || manifest == null) {
            return this.doExecJarCommands(zip, distDirectory, buildVersion, withBinInc);
        }
        File rootDir = manifest.getParentFile().getParentFile();
        File backup = new File(rootDir, "__manifest__.bak");
        FileUtils.copyFile(manifest, backup);
        long timeStamp = manifest.lastModified();
        String[] classPath = ((PluginData)this.data).getClassPath();
        try {
            ((PluginData)this.data).setBundleVersion(buildVersion);
            String[] enhancedCP = new String[classPath.length + (classPath.length == 0 ? 2 : 1)];
            enhancedCP[0] = "external:$com.wamas.fastpatch.root$/" + ((PluginData)this.data).getBundleName();
            if (classPath.length == 0) {
                enhancedCP[1] = ".";
            }
            System.arraycopy(classPath, 0, enhancedCP, 1, classPath.length);
            ((PluginData)this.data).setClassPath(enhancedCP);
            ((PluginData)this.data).writeManifest();
            if (!manifest.setLastModified(timeStamp)) {
                zip.log.debug("cannot set last modified time: " + manifest);
            }
            File file = this.doExecJarCommands(zip, distDirectory, buildVersion, withBinInc);
            return file;
        }
        finally {
            FileUtils.copyFile(backup, manifest);
            FileUtils.delete(backup);
            ((PluginData)this.data).setBundleVersion(oldBundleVersion);
            ((PluginData)this.data).setClassPath(classPath);
            ((PluginData)this.data).refreshProject();
        }
    }

    public boolean isPreserveBinaryStructure() {
        return Boolean.parseBoolean(((PluginData)this.data).getSimpleManifestValue("Preserve-Binary-Structure"));
    }

    private File doExecJarCommands(ZipExecFactory zip, File distDirectory, String buildVersion, boolean withBinInc) throws Exception {
        String[] binInc;
        File jarFile = new File(distDirectory, this.getJarFileName(buildVersion));
        FileUtils.delete(jarFile);
        ((PluginData)this.data).updateManifestForBinaryDeployment();
        ZipExec exec = zip.createZipExec();
        exec.setZipFile(jarFile);
        exec.setJarMode(true);
        Map<String, List<String>> binaryFolders = ((PluginData)this.data).getBinaryFolders();
        String[] stringArray = binInc = ((PluginData)this.data).getBinaryIncludes();
        int n = binInc.length;
        int n2 = 0;
        while (n2 < n) {
            String inc = stringArray[n2];
            List<String> paths = binaryFolders.get(inc);
            if (paths != null && !paths.isEmpty()) {
                for (String path : paths) {
                    File binDir = new File(((PluginData)this.data).getBundleDir(), path);
                    if (!binDir.isDirectory() || binDir.list().length <= 0) continue;
                    ZipExecPart part = new ZipExecPart();
                    if (this.isPreserveBinaryStructure()) {
                        part.sourceDirectory = ((PluginData)this.data).getBundleDir();
                        part.relativePaths.add(path);
                    } else {
                        part.sourceDirectory = binDir;
                        part.relativePaths.add(".");
                    }
                    part.excludeGit = true;
                    exec.addPart(part);
                }
            }
            ++n2;
        }
        if (withBinInc) {
            ZipExecPart incPart = new ZipExecPart();
            String[] stringArray2 = binInc;
            int n3 = binInc.length;
            n = 0;
            while (n < n3) {
                String bin = stringArray2[n];
                if (!binaryFolders.containsKey(bin)) {
                    incPart.relativePaths.add(bin);
                }
                ++n;
            }
            if (!incPart.relativePaths.isEmpty()) {
                incPart.sourceDirectory = ((PluginData)this.data).getBundleDir();
                incPart.excludeGit = true;
                exec.addPart(incPart);
            }
        }
        try {
            exec.createZip();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to zip plug-in '" + ((PluginData)this.data).getBundleName() + "'", ex);
        }
        return jarFile;
    }

    public boolean needUnpack() {
        if (((PluginData)this.data).manifest.getNeedUnpack()) {
            return true;
        }
        String[] classPath = ((PluginData)this.data).getClassPath();
        if (classPath == null) {
            return false;
        }
        String[] stringArray = classPath;
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!element.equals(".")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void buildSelfContainedZip(ZipExecFactory zipFactory, String buildVersion, File output) throws Exception {
        File outputDirectory = output.getParentFile();
        File temp = new File(outputDirectory, "zip_" + String.valueOf(System.currentTimeMillis()));
        File libs = new File(temp, this.getPluginName());
        FileUtils.mkdirs(libs);
        try {
            this.copyLibsForSelfContainment(zipFactory, libs, buildVersion);
            FileUtils.delete(output);
            ZipExec exec = zipFactory.createZipExec();
            exec.setZipFile(output);
            ZipExecPart part = new ZipExecPart();
            part.sourceDirectory = temp;
            part.relativePaths.add(libs.getName());
            exec.addPart(part);
            exec.createZip();
        }
        finally {
            FileUtils.deleteDirectory(temp);
        }
    }

    private void copyLibsForSelfContainment(ZipExecFactory zipFactory, File destDir, String buildVersion) throws Exception {
        if (((PluginData)this.data).isBinary()) {
            this.disruptBinaryJar(zipFactory, destDir);
        } else {
            this.execJarCommands(zipFactory, destDir, buildVersion, false);
        }
        File pd = this.getPluginDirectory();
        if (pd != null && pd.exists() && pd.isDirectory()) {
            String[] stringArray = ((PluginData)this.getData()).getBinaryIncludes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                File binFile;
                String inc = stringArray[n2];
                if (!".".equals(inc) && (binFile = new File(pd, inc)).exists() && binFile.isFile() && binFile.getName().toLowerCase().endsWith(".jar")) {
                    FileUtils.copyFileToDirectory(binFile, destDir);
                }
                ++n2;
            }
        }
        for (PluginBuild dep : this.getSourceDependencies()) {
            dep.copyLibsForSelfContainment(zipFactory, destDir, buildVersion);
        }
    }

    private void disruptBinaryJar(ZipExecFactory zipFactory, File destDir) throws Exception {
        File binFile = this.getBinaryJarFile();
        File tmp = new File(destDir, String.valueOf(binFile.getName()) + "_" + System.currentTimeMillis());
        tmp.mkdirs();
        ZipExec exec = zipFactory.createZipExec();
        exec.unzip(binFile, tmp);
        File meta = new File(tmp, "META-INF");
        if (meta.exists() && meta.isDirectory()) {
            FileUtils.deleteDirectory(meta);
        }
        this.moveJarsRecursive(tmp, destDir);
        File target = new File(destDir, String.valueOf(this.getPluginName()) + "_stripped.jar");
        FileUtils.delete(target);
        exec.setZipFile(target);
        exec.setJarMode(true);
        ZipExecPart part = new ZipExecPart();
        part.sourceDirectory = tmp;
        part.relativePaths.add(".");
        part.excludeGit = true;
        exec.addPart(part);
        exec.createZip();
        FileUtils.deleteDirectory(tmp);
    }

    private void moveJarsRecursive(File tmp, File destDir) throws IOException {
        File[] files = tmp.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().endsWith(".jar")) {
                FileUtils.moveFile(f, new File(destDir, f.getName()));
            }
            if (f.isDirectory()) {
                this.moveJarsRecursive(f, destDir);
            }
            ++n2;
        }
    }
}

