/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.statet.ecommons.debug.core.eval.IEvaluationListener;
import org.eclipse.statet.internal.r.debug.core.Messages;
import org.eclipse.statet.internal.r.debug.core.RDebugCorePlugin;
import org.eclipse.statet.internal.r.debug.core.eval.ExpressionManager;
import org.eclipse.statet.internal.r.debug.core.model.RDebugElement;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTargetImpl;
import org.eclipse.statet.internal.r.debug.core.model.REnvValue;
import org.eclipse.statet.internal.r.debug.core.model.RStackFrameImpl;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.statet.r.console.core.util.LoadReferenceRunnable;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.tool.TmpUtils;
import org.eclipse.statet.r.debug.core.RStackFrame;
import org.eclipse.statet.r.debug.core.RThread;
import org.eclipse.statet.r.debug.core.breakpoints.RBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.RBreakpointStatus;
import org.eclipse.statet.r.nico.AbstractRDbgController;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.data.impl.RLanguageImpl;
import org.eclipse.statet.rj.data.impl.RReferenceImpl;
import org.eclipse.statet.rj.server.dbg.DbgRequest;
import org.eclipse.statet.rj.server.dbg.Frame;
import org.eclipse.statet.rj.server.dbg.FrameRef;
import org.eclipse.statet.rj.services.BasicFQRObjectRef;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.ts.core.RToolService;

@NonNullByDefault
public class RMainThread
extends RDebugElement
implements RThread,
ToolController.IToolStatusListener {
    private static final byte SUSPENDED = 1;
    private static final byte RUN_EVALUATING_SYSTEM = 2;
    private static final byte RUN_EVALUATING_USER = 3;
    private static final byte RUN_STEPPING = 4;
    private static final byte RUN_OTHER = 5;
    private static final byte TERMINATED = 6;
    private static final @NonNull RStackFrameImpl[] NO_FRAMES = new RStackFrameImpl[0];
    private static final @NonNull RBreakpoint[] NO_BREAKPOINTS = new RBreakpoint[0];
    private final AbstractRDbgController controller;
    private final String name;
    private final Object stateLock = new Object();
    private volatile byte state;
    private final Object suspendLock = new Object();
    private int stamp;
    private @Nullable List<RStackFrameImpl> framesStack;
    private @NonNull RStackFrameImpl[] frames;
    private boolean stampChanged;
    private Map<Long, @Nullable EnvItem> envItems;
    private @Nullable Map<Long, @Nullable EnvItem> envPrevItems;
    private @Nullable RReference rGlobelEnvRef;
    private @Nullable RReference rjTmpEnvRef;
    private final ExpressionManager expressionManager;

    private static final byte getRunState(int detail) {
        switch (detail) {
            case 1: 
            case 2: 
            case 4: {
                return 4;
            }
            case 64: {
                return 3;
            }
            case 128: {
                return 2;
            }
        }
        return 5;
    }

    public RMainThread(RDebugTargetImpl target, AbstractRDbgController controller, String name) {
        super(target);
        this.controller = controller;
        this.name = name;
        this.expressionManager = new ExpressionManager(this);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        Object object = this.suspendLock;
        synchronized (object) {
            this.frames = NO_FRAMES;
            this.envItems = Collections.EMPTY_MAP;
        }
        this.controller.addSuspendUpdateRunnable(new SystemRunnable(){

            public String getTypeId() {
                return "r/dbg/thread";
            }

            public String getLabel() {
                return "Main Thread";
            }

            public boolean canRunIn(Tool tool) {
                return tool == RMainThread.this.controller.getTool();
            }

            public boolean changed(int event, Tool process) {
                return true;
            }

            public void run(ToolService service, ProgressMonitor m) throws StatusException {
                RMainThread.this.checkInit(m);
                RMainThread.this.aboutToSuspend(RMainThread.this.controller.getSuspendEnterDetail(), RMainThread.this.controller.getSuspendEnterData(), m);
            }
        });
        this.controller.addToolStatusListener((ToolController.IToolStatusListener)this);
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerStatusChanged(ToolStatus oldStatus, ToolStatus newStatus, List<DebugEvent> eventCollection) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 6) {
                return;
            }
            int detail = 0;
            switch (newStatus) {
                case STARTED_SUSPENDED: {
                    if (this.stampChanged) {
                        detail = this.controller.getSuspendEnterDetail();
                        if (detail == 0 && this.state == 4) {
                            detail = 8;
                        }
                        this.expressionManager.updateExpressions(eventCollection);
                    } else {
                        detail = 128;
                    }
                    this.state = 1;
                    eventCollection.add(new DebugEvent((Object)this, 2, detail));
                    if (!this.stampChanged) break;
                    eventCollection.add(new DebugEvent((Object)this, 16, 512));
                    break;
                }
                case TERMINATED: {
                    this.expressionManager.cleanExpressions(eventCollection);
                    break;
                }
                case STARTED_PAUSED: {
                    if (this.controller.isSuspended()) break;
                }
                case STARTED_IDLING: {
                    if (this.state == 5) break;
                    detail = this.controller.getSuspendExitDetail() & 0x20;
                    this.state = (byte)5;
                    eventCollection.add(new DebugEvent((Object)this, 1, detail));
                    this.expressionManager.clearCache(0, null);
                    break;
                }
                default: {
                    detail = this.controller.getSuspendExitDetail();
                    byte newState = RMainThread.getRunState(detail);
                    if (newState <= this.state && (newState != this.state || newState != 4)) break;
                    this.state = newState;
                    eventCollection.add(new DebugEvent((Object)this, 1, detail));
                    this.expressionManager.clearCache(0, null);
                }
            }
        }
    }

    protected void checkInit(ProgressMonitor m) {
        try {
            if (this.rjTmpEnvRef == null) {
                RObject rObject = this.controller.evalData("rj::.rj.tmp", null, 0, 0, m);
                this.rjTmpEnvRef = RDataUtils.checkRReference((RObject)rObject, (byte)8);
                rObject = this.controller.evalData(".GlobalEnv", null, 0, 0, m);
                this.rGlobelEnvRef = RDataUtils.checkRReference((RObject)rObject, (byte)8);
            }
        }
        catch (StatusException | UnexpectedRDataException e) {
            RDebugCorePlugin.logError("An error occurred when initializing debug target.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void aboutToSuspend(int suspendDetail, Object suspendData, ProgressMonitor m) throws StatusException {
        block37: {
            stamp = this.controller.getChangeStamp();
            newFramesStack = null;
            newFrames = RMainThread.NO_FRAMES;
            newEnvItems = new HashMap<Long, EnvItem>();
            var10_8 = this.suspendLock;
            synchronized (var10_8) {
                prevStamp = this.stamp;
                prevFramesStack = this.framesStack;
            }
            try {
                rStack = this.controller.getCallStack(m);
                if (rStack == null || (l = rStack.getFrames().size()) <= 0) break block37;
                special = DebugPlugin.isUseStepFilters();
                eStack = new ArrayList<RStackFrameImpl>(l);
                startIdx = 0;
                i = 0;
                while (i < l) {
                    dbgFrame = (Frame)rStack.getFrames().get(i);
                    handle = dbgFrame.getHandle();
                    if (i == 0) {
                        call = "[Console]";
                        if (handle == 0L) {
                            handle = this.rGlobelEnvRef.getHandle();
                        }
                    } else if (dbgFrame.getCall() != null) {
                        call = dbgFrame.getCall();
                        if (special && i + 2 < l) {
                            flag = dbgFrame.getFlags() & 255;
                            switch (flag) {
                                case 16: {
                                    call = "[Sourcing Script]";
                                    break;
                                }
                                case 32: {
                                    call = "[Running Command]";
                                    break;
                                }
                                default: {
                                    flag = 0;
                                }
                            }
                            if (flag != 0) {
                                while (i + 1 < l) {
                                    nextFrame = (Frame)rStack.getFrames().get(i + 1);
                                    if ((nextFrame.getFlags() & 255) != ++flag) break;
                                    dbgFrame = nextFrame;
                                    ++i;
                                }
                                if ((flag & 240) == 32 && eStack.size() == 1) {
                                    startIdx = 1;
                                }
                            }
                        }
                    } else {
                        call = "[Unkown]";
                    }
                    if ((fileName = dbgFrame.getFileName()) != null) {
                        idx = fileName.lastIndexOf(47);
                        idx2 = fileName.lastIndexOf(92);
                        if (idx2 > idx) {
                            idx = idx2;
                        }
                        if (idx >= 0) {
                            fileName = fileName.substring(idx + 1, fileName.length());
                        }
                    }
                    breakpoint = dbgFrame.isTopFrame() != false && suspendData instanceof RBreakpointStatus != false ? (RBreakpointStatus)suspendData : null;
                    envItem = new EnvItem(handle);
                    newEnvItems.put(envItem.handle, envItem);
                    if (prevFramesStack == null) ** GOTO lbl74
                    if (eStack.size() < prevFramesStack.size() && ((prevItem = this.getEnvItem(handle, (prevFrame = prevFramesStack.get(eStack.size())).getHandle())) == null || prevItem.handle.longValue() == prevFrame.getHandle().longValue()) && prevFrame.update(stamp, dbgFrame, handle, call, fileName, breakpoint)) {
                        if (prevItem != null) {
                            envItem.prevHandle = prevItem.handle;
                        }
                        eStack.add(prevFrame);
                    } else {
                        if (stamp == prevStamp) {
                            RDebugCorePlugin.logWarning("Frame stack changed, but controller.changeStamp is unchanged.", null);
                        }
                        prevFramesStack = null;
lbl74:
                        // 2 sources

                        newFrame = new RStackFrameImpl((RDebugTargetImpl)this.getDebugTarget(), this, stamp, dbgFrame, handle, call, fileName, breakpoint);
                        eStack.add(newFrame);
                    }
                    ++i;
                }
                newFramesStack = eStack;
                newFrames = new RStackFrameImpl[eStack.size() - startIdx];
                endIdx = eStack.size() - 1;
                i = 0;
                while (i < newFrames.length) {
                    newFrames[i] = (RStackFrameImpl)eStack.get(endIdx - i);
                    ++i;
                }
            }
            catch (Throwable var24_28) {
                var25_29 = this.suspendLock;
                synchronized (var25_29) {
                    this.stamp = stamp;
                    this.framesStack = newFramesStack;
                    this.frames = newFrames;
                    this.envPrevItems = this.envItems;
                    this.envItems = newEnvItems;
                    this.stampChanged = stamp != prevStamp;
                }
                if (this.frames.length > 0) {
                    this.frames[0].loadContext(this.controller, m);
                }
                if (this.stampChanged) {
                    this.expressionManager.clearCache(stamp, m);
                }
                throw var24_28;
            }
        }
        var25_30 = this.suspendLock;
        synchronized (var25_30) {
            this.stamp = stamp;
            this.framesStack = newFramesStack;
            this.frames = newFrames;
            this.envPrevItems = this.envItems;
            this.envItems = newEnvItems;
            this.stampChanged = stamp != prevStamp;
        }
        if (this.frames.length > 0) {
            this.frames[0].loadContext(this.controller, m);
        }
        if (this.stampChanged) {
            this.expressionManager.clearCache(stamp, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable EnvItem getEnvItem(Long first, Long second) {
        Object object = this.suspendLock;
        synchronized (object) {
            EnvItem envItem = this.envItems.get(first);
            if (envItem == null && second != first) {
                envItem = this.envItems.get(second);
            }
            return envItem;
        }
    }

    public final RProcess getTool() {
        return this.controller.getTool();
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public int getPriority() throws DebugException {
        throw this.newNotSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentStamp() {
        Object object = this.suspendLock;
        synchronized (object) {
            return this.stamp;
        }
    }

    public boolean isTerminated() {
        return this.state == 6;
    }

    public boolean canTerminate() {
        return false;
    }

    public void terminate() throws DebugException {
        throw this.newNotSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTerminated() {
        Object object = this.stateLock;
        synchronized (object) {
            this.state = (byte)6;
        }
        object = this.suspendLock;
        synchronized (object) {
            this.frames = new RStackFrameImpl[0];
        }
    }

    protected void exec(DbgRequest request) throws DebugException {
        try {
            this.controller.exec(request);
        }
        catch (StatusException e) {
            throw new DebugException((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.debug.core", 5012, "An error occurred when executing debug request in the R engine.", (Throwable)e));
        }
    }

    public boolean isSuspended() {
        byte state = this.state;
        return state >= 1 && state <= 3;
    }

    public boolean canSuspend() {
        byte state = this.state;
        return state >= 4 && state <= 5;
    }

    public boolean canResume() {
        byte state = this.state;
        return state >= 1 && state <= 3;
    }

    public void suspend() throws DebugException {
        if (this.canSuspend()) {
            this.controller.debugSuspend();
        }
    }

    public void resume() throws DebugException {
        if (this.canResume()) {
            this.exec((DbgRequest)new DbgRequest.Resume());
        }
    }

    public boolean isStepping() {
        return this.state == 4;
    }

    public boolean canStepInto() {
        RStackFrame topFrame = this.getTopStackFrame();
        return topFrame != null && topFrame.canStepInto();
    }

    public boolean canStepOver() {
        RStackFrame topFrame = this.getTopStackFrame();
        return topFrame != null && topFrame.canStepOver();
    }

    public boolean canStepReturn() {
        RStackFrame topFrame = this.getTopStackFrame();
        return topFrame != null && topFrame.canStepReturn();
    }

    public void stepInto() throws DebugException {
        if (this.canStepInto()) {
            this.exec((DbgRequest)new DbgRequest.StepInto());
        }
    }

    public void stepOver() throws DebugException {
        if (this.canStepOver()) {
            this.exec((DbgRequest)new DbgRequest.StepOver());
        }
    }

    public void stepReturn() throws DebugException {
        if (this.canStepReturn()) {
            this.stepToFrame(null, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepToFrame(@Nullable RStackFrameImpl refFrame, int relIdx) throws DebugException {
        ImList frames;
        Object object = this.suspendLock;
        synchronized (object) {
            frames = ImCollections.newList((Object[])this.frames);
        }
        if (frames.isEmpty()) {
            return;
        }
        int refIdx = refFrame != null ? frames.indexOf((Object)refFrame) : 0;
        int targetIdx = refIdx + relIdx;
        if (refIdx < 0 || targetIdx < 0 || targetIdx >= frames.size()) {
            return;
        }
        if (refIdx == 0 && relIdx == 0) {
            if (this.canStepOver()) {
                this.exec((DbgRequest)new DbgRequest.StepOver());
            }
            return;
        }
        if (this.canStepReturn()) {
            this.exec((DbgRequest)new DbgRequest.StepReturn((FrameRef)new FrameRef.ByPosition(((RStackFrameImpl)frames.get(targetIdx)).getPosition())));
        }
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull RStackFrame[] getStackFrames() {
        if (!this.isSuspended()) {
            return NO_FRAMES;
        }
        Object object = this.suspendLock;
        synchronized (object) {
            return this.frames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkStackFrame(RStackFrame frame) {
        Object object = this.suspendLock;
        synchronized (object) {
            int i = 0;
            while (i < this.frames.length) {
                if (this.frames[i] == frame) {
                    return this.stamp;
                }
                ++i;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable RStackFrame getTopStackFrame() {
        if (!this.isSuspended()) {
            return null;
        }
        Object object = this.suspendLock;
        synchronized (object) {
            return this.frames.length > 0 ? this.frames[0] : null;
        }
    }

    public @Nullable FQRObjectRef createElementRef(@Nullable CombinedRElement element, int stamp, ProgressMonitor m) {
        if (stamp != this.getCurrentStamp()) {
            return null;
        }
        try {
            ArrayList<RElementName> segments = new ArrayList<RElementName>();
            while (element != null) {
                if (element.getRObjectType() == 8) {
                    RReference envRef = this.verifyEnv((RProcessREnvironment)element, m);
                    Collections.reverse(segments);
                    RElementName name = RElementName.create(segments);
                    return new BasicFQRObjectRef((Object)this.controller.getTool(), (RObject)envRef, (RObject)this.createRefName(name));
                }
                RElementName elementName = element.getElementName();
                if (elementName.getNextSegment() != null) {
                    if (!TmpUtils.isTmp((RElementName)elementName)) break;
                    segments.add(elementName.getNextSegment());
                    Collections.reverse(segments);
                    RElementName name = RElementName.create(segments);
                    return new BasicFQRObjectRef((Object)this.controller.getTool(), (RObject)this.rjTmpEnvRef, (RObject)this.createRefName(name));
                }
                segments.add(elementName);
                element = element.getModelParent();
            }
            throw new IllegalStateException("Unable to create name.");
        }
        catch (Exception e) {
            RDebugCorePlugin.logError("An error occurred when creating R element name to load data.", e);
            return null;
        }
    }

    private RReference verifyEnv(RProcessREnvironment env, ProgressMonitor m) {
        RWorkspace workspace = this.controller.getWorkspaceData();
        if (workspace.isUptodate((CombinedRElement)env)) {
            return new RReferenceImpl(env.getHandle(), 8, "environment");
        }
        throw new IllegalStateException("Unable to create name.");
    }

    private RLanguage createRefName(RElementName name) {
        return new RLanguageImpl(name.getNextSegment() == null ? (byte)1 : 3, name.getDisplayName(2), null);
    }

    private EnvItem getEnvItem(Long handle) {
        EnvItem item = this.envItems.get(handle);
        if (item == null) {
            item = new EnvItem(handle);
            this.envItems.put(handle, item);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CombinedRElement resolveReference(CombinedRElement element, int stamp) {
        EnvItem envItem;
        RReference reference = (RReference)element;
        Object object = this.suspendLock;
        synchronized (object) {
            if (stamp != this.stamp) {
                return element;
            }
            envItem = this.getEnvItem(reference.getHandle());
        }
        object = envItem;
        synchronized (object) {
            if (envItem.element != null) {
                return envItem.element;
            }
            RWorkspace workspace = ((RDebugTargetImpl)this.getDebugTarget()).getProcess().getWorkspaceData();
            if (workspace != null) {
                CombinedRElement resolved = workspace.resolve(reference, 0);
                if (resolved instanceof RProcessREnvironment && ((RProcessREnvironment)resolved).getStamp() == stamp) {
                    envItem.element = (RProcessREnvironment)resolved;
                    return envItem.element;
                }
                if (resolved != null) {
                    return resolved;
                }
                resolved = this.loadReference(reference, stamp);
                if (resolved instanceof RProcessREnvironment) {
                    envItem.element = (RProcessREnvironment)resolved;
                    return envItem.element;
                }
            }
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CombinedRElement resolveReference(CombinedRElement element, int stamp, ProgressMonitor m) throws StatusException {
        EnvItem envItem;
        RReference reference = (RReference)element;
        Object object = this.suspendLock;
        synchronized (object) {
            if (stamp != this.stamp) {
                return element;
            }
            envItem = this.getEnvItem(reference.getHandle());
        }
        object = envItem;
        synchronized (object) {
            CombinedRElement resolved;
            if (envItem.element != null) {
                return envItem.element;
            }
            RWorkspace workspace = ((RDebugTargetImpl)this.getDebugTarget()).getProcess().getWorkspaceData();
            if (workspace != null && (resolved = workspace.resolve((RReference)element, 2, 0, m)) instanceof RProcessREnvironment) {
                envItem.element = (RProcessREnvironment)resolved;
                return envItem.element;
            }
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable REnvValue getEnvValue(RProcessREnvironment element, int stamp) {
        Map<Long, EnvItem> prevItems;
        EnvItem envItem;
        Object object = this.suspendLock;
        synchronized (object) {
            block7: {
                if (stamp == this.stamp) break block7;
                return null;
            }
            envItem = this.getEnvItem(element.getHandle());
            prevItems = this.envPrevItems;
        }
        object = envItem;
        synchronized (object) {
            return this.doGetEnvValue(element, stamp, envItem, prevItems);
        }
    }

    private REnvValue doGetEnvValue(RProcessREnvironment element, int stamp, EnvItem envItem, Map<Long, @Nullable EnvItem> prevItems) {
        EnvItem prevItem;
        if (envItem.value != null) {
            return envItem.value;
        }
        REnvValue previousValue = null;
        if (prevItems != null && (prevItem = prevItems.get(envItem.prevHandle)) != null) {
            previousValue = prevItem.value;
        }
        envItem.value = new REnvValue(element, this, stamp, previousValue);
        return envItem.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends RObject> @Nullable V loadData(AccessDataRunnable<V> runnable) {
        if (runnable.getRequiredStamp() != this.getCurrentStamp()) {
            return null;
        }
        RProcess tool = this.controller.getTool();
        AccessDataRunnable<V> accessDataRunnable = runnable;
        synchronized (accessDataRunnable) {
            if (tool.getQueue().addHot(runnable).getSeverity() == 0) {
                try {
                    runnable.wait();
                    return runnable.data;
                }
                catch (InterruptedException e) {
                    runnable.cancel = true;
                    ((RDebugTargetImpl)this.getDebugTarget()).getProcess().getQueue().removeHot(runnable);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable CombinedRElement loadReference(RReference reference, int stamp) {
        LoadReferenceRunnable runnable;
        RProcess tool = this.controller.getTool();
        LoadReferenceRunnable loadReferenceRunnable = runnable = new LoadReferenceRunnable(reference, tool, stamp, Messages.DebugContext_label);
        synchronized (loadReferenceRunnable) {
            if (tool.getQueue().addHot((ToolRunnable)runnable).getSeverity() == 0) {
                try {
                    runnable.wait();
                    return runnable.getResolvedElement();
                }
                catch (InterruptedException e) {
                    runnable.cancel();
                    ((RDebugTargetImpl)this.getDebugTarget()).getProcess().getQueue().removeHot((ToolRunnable)runnable);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull IBreakpoint[] getBreakpoints() {
        IBreakpoint[] iBreakpointArray;
        IBreakpoint breakpoint;
        Object object = this.suspendLock;
        synchronized (object) {
            breakpoint = this.frames.length > 0 ? this.frames[0].getAdapter(IBreakpoint.class) : null;
        }
        if (breakpoint != null) {
            IBreakpoint[] iBreakpointArray2 = new IBreakpoint[1];
            iBreakpointArray = iBreakpointArray2;
            iBreakpointArray2[0] = breakpoint;
        } else {
            iBreakpointArray = NO_BREAKPOINTS;
        }
        return iBreakpointArray;
    }

    @Override
    public void evaluate(String expressionText, RStackFrame stackFrame, boolean forceReevaluate, IEvaluationListener listener) {
        this.expressionManager.evaluate(expressionText, stackFrame, forceReevaluate, listener);
    }

    @Override
    public <T> @Nullable T getAdapter(Class<T> type) {
        if (type == RThread.class) {
            return (T)this;
        }
        if (type == RStackFrame.class) {
            return (T)this.getTopStackFrame();
        }
        return super.getAdapter(type);
    }

    abstract class AccessDataRunnable<V extends RObject>
    implements SystemRunnable {
        private boolean cancel;
        private V data;

        public String getTypeId() {
            return "r/dbg/stackframe/loadData";
        }

        public String getLabel() {
            return Messages.DebugContext_UpdateVariables_task;
        }

        public boolean canRunIn(Tool tool) {
            return tool == RMainThread.this.getTool();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean changed(int event, Tool tool) {
            switch (event) {
                case 288: {
                    return this.cancel;
                }
                case 289: {
                    return false;
                }
                case 290: 
                case 336: 
                case 340: 
                case 344: {
                    AccessDataRunnable accessDataRunnable = this;
                    synchronized (accessDataRunnable) {
                        this.notifyAll();
                        break;
                    }
                }
            }
            return true;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            AbstractRDbgController controller = (AbstractRDbgController)service;
            if (!controller.isSuspended() || this.getRequiredStamp() != controller.getChangeStamp()) {
                return;
            }
            try {
                this.data = this.doRun((RToolService)controller, m);
            }
            catch (UnexpectedRDataException e) {
                throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.debug.core", "Unexpected state", (Throwable)e));
            }
        }

        protected final RMainThread getThread() {
            return RMainThread.this;
        }

        protected abstract int getRequiredStamp();

        protected abstract V doRun(RToolService var1, ProgressMonitor var2) throws StatusException, UnexpectedRDataException;
    }

    private static class EnvItem {
        final Long handle;
        @Nullable Long prevHandle;
        @Nullable RProcessREnvironment element;
        @Nullable REnvValue value;

        public EnvItem(Long handle) {
            this.handle = handle;
            this.prevHandle = handle;
        }
    }
}

