/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ui.templates.EnhTemplateStore;
import org.eclipse.text.templates.TemplatePersistenceData;

@NonNullByDefault
public abstract class InsertEditorTemplateParameterValues
implements IParameterValues {
    protected abstract EnhTemplateStore getTemplateStore();

    public Map<String, String> getParameterValues() {
        EnhTemplateStore templateStore = this.getTemplateStore();
        ContextTypeRegistry contextTypeRegistry = templateStore.getContextTypeRegistry();
        ImList<EnhTemplateStore.EnhTemplatePersistenceData> datas = templateStore.getTemplateDatas(false);
        HashMap<String, String> parameters = new HashMap<String, String>(datas.size());
        ArrayList<String> labels = new ArrayList<String>(datas.size());
        StringBuilder sb = new StringBuilder();
        for (TemplatePersistenceData data : datas) {
            String label;
            TemplateContextType contextType;
            Template template = data.getTemplate();
            if (template == null || (contextType = contextTypeRegistry.getContextType(template.getContextTypeId())) == null) continue;
            sb.setLength(0);
            sb.append(contextType.getName());
            sb.append("\u2002>\u2002");
            sb.append(template.getName());
            if (!template.getDescription().isEmpty()) {
                sb.append("\u2002\u2013\u2002");
                sb.append(template.getDescription());
            }
            if (labels.contains(label = sb.toString())) continue;
            labels.add(label);
            String id = data.getId();
            if (id == null) continue;
            parameters.put(label, id);
        }
        return parameters;
    }
}

