/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui.assist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.events.VerifyEvent;

@NonNullByDefault
public class LinkedModeAutodeleteLevel
implements LinkedModeUI.IExitPolicy {
    private final IDocument document;
    private final LinkedPosition position;
    private final int deleteLength;

    public LinkedModeAutodeleteLevel(IDocument document, LinkedPosition position, int deleteLength) {
        this.document = document;
        this.position = position;
        this.deleteLength = deleteLength;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
        try {
            if (offset == this.position.getOffset() && length == 0) {
                switch (event.character) {
                    case '\b': {
                        this.document.replace(offset - this.deleteLength, this.deleteLength, "");
                        return new LinkedModeUI.ExitFlags(0, false);
                    }
                }
            }
            return new LinkedModeUI.ExitFlags(0, true);
        }
        catch (BadLocationException e) {
            return new LinkedModeUI.ExitFlags(0, true);
        }
    }
}

