/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.List;
import java.util.Objects;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.ImageAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.ImageByRefAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.LabelInfo;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ToStringHelper;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineParser;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineWithNestedContents;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class Image
extends InlineWithNestedContents {
    private final String src;
    private final @Nullable LabelInfo labelReference;
    private final @Nullable String title;

    public Image(Line line, int offset, int length, String src, @Nullable String title, List<Inline> contents) {
        super(line, offset, length, -1, contents);
        this.src = (String)ObjectUtils.nonNullAssert((Object)src);
        this.labelReference = null;
        this.title = title;
    }

    public Image(Line line, int offset, int length, LabelInfo labelReference, List<Inline> contents) {
        super(line, offset, length, -1, contents);
        this.src = "ref:" + labelReference.getLabel();
        this.labelReference = labelReference;
        this.title = null;
    }

    public String getHref() {
        return this.src;
    }

    @Override
    public void emit(ProcessingContext context, CommonmarkLocator locator, DocumentBuilder builder) {
        ImageByRefAttributes attributes = this.labelReference != null ? new ImageByRefAttributes(this.labelReference) : new ImageAttributes();
        attributes.setTitle(this.title);
        ImList<Inline> contents = this.getContents();
        if (!contents.isEmpty()) {
            attributes.setAlt(InlineParser.toStringContent(context, contents));
        }
        builder.image((Attributes)attributes, this.src);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getStartOffset(), this.getLength(), this.getContents(), this.src, this.title);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (super.equals(obj)) {
            Image other = (Image)obj;
            return this.src.equals(other.src) && Objects.equals(this.labelReference, other.labelReference) && Objects.equals(this.title, other.title);
        }
        return false;
    }

    @Override
    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(Image.class, this.getClass());
        sb.addProp("startOffset", this.getStartOffset());
        sb.addProp("length", this.getLength());
        sb.addProp("src", ToStringHelper.toStringValue(this.src));
        sb.addProp("title", this.title);
        sb.addProp("contents", this.getContents());
        return sb.build();
    }
}

