/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.Expression;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;

@NonNullByDefault
public abstract class Sign
extends RAstNode {
    final Expression rightExpr = new Expression();

    Sign() {
    }

    @Override
    public abstract RTerminal getOperator(int var1);

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 1;
    }

    @Override
    public final RAstNode getChild(int index) {
        if (index == 0) {
            return this.rightExpr.node;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (this.rightExpr.node == child) {
            return 0;
        }
        return -1;
    }

    public final RAstNode getRightChild() {
        return this.rightExpr.node;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        this.rightExpr.node.acceptInR(visitor);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.rightExpr.node);
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        if (this.rightExpr.node == child) {
            return this.rightExpr;
        }
        return null;
    }

    @Override
    final @Nullable Expression getLeftExpr() {
        return null;
    }

    @Override
    final Expression getRightExpr() {
        return this.rightExpr;
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        if (this.rightExpr == expr) {
            return 4195091;
        }
        throw new IllegalArgumentException();
    }

    final void updateOffsets() {
        this.doSetEndOffset(this.rightExpr.node.getEndOffset());
    }

    @Override
    public boolean equalsValue(RAstNode element) {
        if (this.getNodeType() == element.getNodeType() && this.getOperator(0) == element.getOperator(0)) {
            Sign other = (Sign)element;
            return this.rightExpr.node.equalsValue(other.rightExpr.node);
        }
        return false;
    }

    static final class MinusSign
    extends Sign {
        MinusSign() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.SIGN;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.MINUS;
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return NodeType.SIGN == element.getNodeType();
        }
    }

    static final class Not
    extends Sign {
        Not() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.NOT;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.NOT;
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return NodeType.NOT == element.getNodeType();
        }
    }

    static final class PlusSign
    extends Sign {
        PlusSign() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.SIGN;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.PLUS;
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return NodeType.SIGN == element.getNodeType();
        }
    }
}

