/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.impl.TaskTagReporter;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.SourceComponent;

@NonNullByDefault
public class RTaskTagReporter
extends TaskTagReporter {
    public void run(RSourceUnit sourceUnit, RAstNode node, SourceContent sourceContent, IssueRequestor requestor) {
        if (node instanceof SourceComponent) {
            this.setup(sourceContent, requestor);
            ImList comments = (ImList)ObjectUtils.nonNullAssert(((SourceComponent)node).getComments());
            for (RAstNode comment : comments) {
                if (comment.getNodeType() == NodeType.DOCU_AGGREGATION) {
                    int childCount = comment.getChildCount();
                    int childIndex = 0;
                    while (childIndex < childCount) {
                        RAstNode commentLine = comment.getChild(childIndex);
                        this.checkForTasks(commentLine.getStartOffset() + 2, commentLine.getEndOffset());
                        ++childIndex;
                    }
                    continue;
                }
                this.checkForTasks(comment.getStartOffset() + 1, comment.getEndOffset());
            }
        }
    }
}

