/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.net.Port;

@NonNullByDefault
public class CommonsNet {
    public static final String LOCALHOST_NAME = "localhost";
    public static final String LOOPBACK_IPV4 = "127.0.0.1";
    public static final String LOOPBACK_IPV6 = "0:0:0:0:0:0:0:1";
    public static final String LOOPBACK_IPV6_SHORT = "::1";
    public static final String LOOPBACK_STRING;
    public static final String LOCAL_LOOPBACK_STRING;
    private static final InetAddress LOCAL_LOOPBACK_INET_ADDRESS;
    public static final String ANYADDRESS_IPV4 = "0.0.0.0";
    public static final String ANYADDRESS_IPV6 = "0:0:0:0:0:0:0:0";
    public static final String ANYADDRESS_IPV6_SHORT = "::";
    public static final String ANYADDRESS_STRING;
    public static final String LOCAL_ANYADDRESS_STRING;
    public static final String HTTP_SCHEME = "http";
    public static final int HTTP_DEFAULT_PORT_NUM = 80;
    public static final Port HTTP_DEFAULT_PORT;
    public static final String SSH_SCHEME = "ssh";
    public static final String SFTP_SCHEME = "sftp";
    public static final int SSH_DEFAULT_PORT_NUM = 22;
    public static final Port SSH_DEFAULT_PORT;

    static {
        HTTP_DEFAULT_PORT = new Port(80);
        SSH_DEFAULT_PORT = new Port(22);
        LOOPBACK_STRING = LOOPBACK_IPV4;
        LOCAL_LOOPBACK_INET_ADDRESS = InetAddress.getLoopbackAddress();
        LOCAL_LOOPBACK_STRING = LOCAL_LOOPBACK_INET_ADDRESS.getHostAddress();
        LOCAL_ANYADDRESS_STRING = ANYADDRESS_STRING = ANYADDRESS_IPV4;
    }

    public static InetAddress getLocalLoopbackInetAddress() {
        return LOCAL_LOOPBACK_INET_ADDRESS;
    }

    public static boolean isCommonLoopback(String host) {
        return host.equals(LOCAL_LOOPBACK_STRING) || host.equals(LOOPBACK_IPV4) || host.equals(LOOPBACK_IPV6) || host.equals("[0:0:0:0:0:0:0:1]") || host.equals(LOOPBACK_IPV6_SHORT) || host.equals("[::1]") || host.equals(LOCALHOST_NAME);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLocalLocalhost(String host) {
        if (CommonsNet.isCommonLoopback(host)) return true;
        if (host.equals(LOCAL_LOOPBACK_INET_ADDRESS.getHostName())) {
            return true;
        }
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            if (CommonsNet.isCommonLoopback(localhost.getHostName())) return false;
            InetAddress[] inetAddressArray = InetAddress.getAllByName(localhost.getHostName());
            int n = inetAddressArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                InetAddress inetAddress = inetAddressArray[n2];
                if (host.equals(inetAddress.getHostName())) return true;
                if (host.equals(inetAddress.getHostAddress())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isIpV4Address(String host) {
        int offset = 0;
        int l = host.length();
        int nGroups = 0;
        while (nGroups < 4) {
            int nDigits = 0;
            block5: while (offset < l) {
                switch (host.charAt(offset)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        ++nDigits;
                        ++offset;
                        break;
                    }
                    case '.': {
                        if (nGroups < 3) break block5;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (CommonsNet.isDecByte(host, offset - nDigits, nDigits)) {
                ++nGroups;
                ++offset;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean isIpV6Address(String host) {
        block6: {
            try {
                if (host.isEmpty()) break block6;
                switch (host.charAt(0)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case ':': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case '[': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        if (host.indexOf(58) >= 0) {
                            InetAddress.getByName(host);
                            return true;
                        }
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isIpAddress(String host) {
        return CommonsNet.isIpV4Address(host) || CommonsNet.isIpV6Address(host);
    }

    private static boolean isDecByte(String s, int offset, int n) {
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return s.charAt(offset) != '0';
            }
            case 3: {
                switch (s.charAt(offset)) {
                    case '0': {
                        return false;
                    }
                    case '1': {
                        return true;
                    }
                    case '2': {
                        switch (s.charAt(offset + 1)) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': {
                                return true;
                            }
                            case '5': {
                                switch (s.charAt(offset + 2)) {
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': {
                                        return true;
                                    }
                                }
                                return false;
                            }
                        }
                        return false;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private CommonsNet() {
    }
}

