/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.sourceediting;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.statet.docmlet.tex.core.TexCodeStyleSettings;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.docmlet.tex.core.ast.LtxParser;
import org.eclipse.statet.docmlet.tex.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.parser.LtxLexer;
import org.eclipse.statet.docmlet.tex.core.parser.NowebLtxLexer;
import org.eclipse.statet.docmlet.tex.core.refactoring.LtxSourceIndenter;
import org.eclipse.statet.docmlet.tex.core.source.doc.LtxPartitionNodeType;
import org.eclipse.statet.docmlet.tex.core.source.doc.TexDocumentConstants;
import org.eclipse.statet.docmlet.tex.core.source.util.LtxHeuristicTokenScanner;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.TexEditingSettings;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartition;
import org.eclipse.statet.ecommons.text.ui.assist.LinkedModeBracketLevel;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.internal.docmlet.tex.ui.editors.HardLineWrap;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.TexBracketLevel;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.string.CharPair;
import org.eclipse.statet.jcommons.string.Chars;
import org.eclipse.statet.jcommons.text.core.CharPairSet;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.ltk.text.core.HeuristicTokenScanner;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractAutoEditStrategy;
import org.eclipse.statet.ltk.ui.sourceediting.SmartInsertSettings;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.TextEdit;

public class LtxAutoEditStrategy
extends AbstractAutoEditStrategy {
    private static final StringParserInput DEFAULT_PARSER_INPUT = new StringParserInput();
    private final TexCoreAccess texCoreAccess;
    private final Settings settings;
    private LtxHeuristicTokenScanner scanner;
    private TexCodeStyleSettings texCodeStyle;
    private LtxSourceIndenter indenter;
    private final HardLineWrap hardLineWrap;

    public LtxAutoEditStrategy(TexCoreAccess coreAccess, SourceEditor editor) {
        super(editor);
        assert (coreAccess != null);
        this.texCoreAccess = coreAccess;
        this.settings = new Settings(coreAccess);
        this.hardLineWrap = new HardLineWrap();
    }

    public Settings getSettings() {
        return this.settings;
    }

    protected IIndentSettings getCodeStyleSettings() {
        return this.texCodeStyle;
    }

    protected final TreePartition initCustomization(int offset, int ch) throws BadLocationException, BadPartitioningException {
        if (this.scanner == null) {
            this.scanner = this.createScanner();
        }
        this.texCodeStyle = this.texCoreAccess.getTexCodeStyle();
        return super.initCustomization(offset, ch);
    }

    protected LtxHeuristicTokenScanner createScanner() {
        return LtxHeuristicTokenScanner.create((DocContentSections)this.getDocumentContentInfo());
    }

    /*
     * Unable to fully structure code
     */
    protected TextRegion computeValidRange(int offset, TreePartition partition, int ch) {
        block1: {
            node = partition.getTreeNode();
            if (!(node.getType() instanceof LtxPartitionNodeType)) break block1;
            if (this.getDocumentContentInfo().getPrimaryType() != "org.eclipse.statet.Ltx") ** GOTO lbl6
            return super.computeValidRange(offset, partition, ch);
lbl-1000:
            // 1 sources

            {
                node = parent;
lbl6:
                // 2 sources

                ** while ((parent = node.getParent()) != null && parent.getType() instanceof LtxPartitionNodeType)
            }
lbl7:
            // 1 sources

            return node;
        }
        return null;
    }

    protected HeuristicTokenScanner getScanner() {
        return this.scanner;
    }

    protected final void quitCustomization() {
        super.quitCustomization();
        this.texCodeStyle = null;
    }

    private final boolean isClosedBracket(int backwardOffset, int forwardOffset, String currentPartition, CharPair searchType) throws BadLocationException {
        CharPairSet brackets = LtxHeuristicTokenScanner.LTX_BRACKETS;
        int searchPairIndex = brackets.getPairIndex(searchType);
        int[] balance = new int[brackets.getPairCount()];
        int n = searchPairIndex;
        balance[n] = balance[n] + 1;
        this.scanner.configure((IDocument)this.getDocument(), currentPartition);
        balance = this.scanner.computePairBalance(backwardOffset, forwardOffset, this.getValidRange(), brackets, balance, searchPairIndex);
        return balance[searchPairIndex] <= 0;
    }

    private boolean isValueChar(int offset) throws BadLocationException {
        int ch = this.getChar(offset);
        return ch != -1 && Character.isLetterOrDigit(ch);
    }

    protected char isCustomizeKey(KeyEvent event) {
        switch (event.character) {
            case '$': 
            case '(': 
            case '[': 
            case '{': {
                return event.character;
            }
            case '\t': {
                if (event.stateMask != 0) break;
                return '\t';
            }
            case '\n': 
            case '\r': {
                if (this.getEditor3() == null) break;
                return '\n';
            }
        }
        return '\u0000';
    }

    protected void doCustomizeKeyCommand(char ch, DocumentCommand command, TreePartition partition) throws Exception {
        String contentType = partition.getType();
        int cEnd = command.offset + command.length;
        int linkedModeType = -1;
        int linkedModeOffset = -1;
        switch (ch) {
            case '\t': {
                if (TexDocumentConstants.LTX_ANY_CONTENT_CONSTRAINT.matches(contentType) && this.isRegularTabCommand(command)) {
                    command.text = "\t";
                    this.smartInsertOnTab(command, contentType != "Ltx.Verbatim");
                    break;
                }
                return;
            }
            case '{': {
                if (TexDocumentConstants.LTX_DEFAULT_OR_MATH_CONTENT_CONSTRAINT.matches(contentType) && !LtxHeuristicTokenScanner.isEscaped((IDocument)this.getDocument(), (int)command.offset)) {
                    command.text = "{";
                    if (!this.settings.closeBrackets || this.isValueChar(cEnd)) break;
                    if (!this.isClosedBracket(command.offset, cEnd, contentType, Chars.CURLY_BRACKETS)) {
                        command.text = "{}";
                        linkedModeType = 0x1000002;
                        break;
                    }
                    if (this.getChar(cEnd) != 125) break;
                    linkedModeType = 2;
                    break;
                }
                return;
            }
            case '[': {
                if (TexDocumentConstants.LTX_DEFAULT_OR_MATH_CONTENT_CONSTRAINT.matches(contentType) && !LtxHeuristicTokenScanner.isEscaped((IDocument)this.getDocument(), (int)command.offset)) {
                    command.text = "[";
                    if (!this.settings.closeBrackets || this.isValueChar(cEnd)) break;
                    if (!this.isClosedBracket(command.offset, cEnd, contentType, Chars.SQUARE_BRACKETS)) {
                        command.text = "[]";
                        linkedModeType = 0x1000002;
                        break;
                    }
                    if (this.getChar(cEnd) != 93) break;
                    linkedModeType = 2;
                    break;
                }
                return;
            }
            case '(': {
                if (TexDocumentConstants.LTX_DEFAULT_OR_MATH_CONTENT_CONSTRAINT.matches(contentType) && !LtxHeuristicTokenScanner.isEscaped((IDocument)this.getDocument(), (int)command.offset)) {
                    command.text = "(";
                    if (!this.settings.closeParenthesis || this.isValueChar(cEnd)) break;
                    if (!this.isClosedBracket(command.offset, cEnd, contentType, Chars.ROUND_BRACKETS)) {
                        command.text = "()";
                        linkedModeType = 0x1000002;
                        break;
                    }
                    if (this.getChar(cEnd) != 41) break;
                    linkedModeType = 2;
                    break;
                }
                return;
            }
            case '$': {
                if (contentType == "Ltx.Math" && !LtxHeuristicTokenScanner.isEscaped((IDocument)this.getDocument(), (int)command.offset)) {
                    command.text = "$";
                    if (this.settings.closeMathDollar && partition.getOffset() == command.offset - 1 && this.getChar(command.offset - 1) == 36 && TextUtil.countForward((IDocument)this.getDocument(), (int)cEnd, (char)'$') == 1) {
                        command.text = "$$";
                        linkedModeType = 0x1000003;
                        break;
                    }
                }
                if (TexDocumentConstants.LTX_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && !LtxHeuristicTokenScanner.isEscaped((IDocument)this.getDocument(), (int)command.offset)) {
                    command.text = "$";
                    if (!this.settings.closeMathDollar || this.isValueChar(cEnd)) break;
                    command.text = "$$";
                    linkedModeType = 0x1000002;
                    break;
                }
                return;
            }
            case '\n': {
                if (TexDocumentConstants.LTX_DEFAULT_OR_MATH_CONTENT_CONSTRAINT.matches(contentType) || contentType == "Ltx.Comment") {
                    command.text = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument());
                    this.smartIndentOnNewLine(command);
                    break;
                }
                return;
            }
            default: {
                assert (false);
                return;
            }
        }
        if (command.doit && command.text.length() > 0 && this.getEditor().isEditable(true)) {
            this.getViewer().getTextWidget().setRedraw(false);
            try {
                this.applyCommand(command);
                this.updateSelection(command);
                if (linkedModeType >= 0) {
                    if (linkedModeOffset < 0) {
                        linkedModeOffset = command.offset;
                    }
                    this.createLinkedMode(linkedModeOffset, ch, linkedModeType).enter();
                }
            }
            finally {
                this.getViewer().getTextWidget().setRedraw(true);
            }
        }
    }

    protected void doCustomizeOtherCommand(DocumentCommand command, TreePartition partition) throws Exception {
        String contentType = partition.getType();
        if (TexDocumentConstants.LTX_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
            if (command.length == 0 && TextUtilities.equals((String[])this.getDocument().getLegalLineDelimiters(), (String)command.text) != -1) {
                this.smartIndentOnNewLine(command);
            } else if (this.settings.hardWrapText && command.length == 0) {
                this.smartLineWrap(command);
            }
        }
    }

    private void smartIndentOnNewLine(DocumentCommand command) throws Exception {
        int forward;
        AbstractDocument doc = this.getDocument();
        IRegion line = doc.getLineInformationOfOffset(command.offset);
        int backward = command.offset;
        ITypedRegion partition = doc.getPartition(this.getDocumentContentInfo().getPartitioning(), backward, true);
        if (partition.getType() == "Ltx.Comment" || partition.getType() == "Ltx.MathComment") {
            backward = partition.getOffset();
        }
        this.scanner.configure((IDocument)doc);
        if (backward >= line.getOffset() && (forward = this.scanner.findAnyNonBlankForward(command.offset + command.length, -2, false)) != -1 && forward + 6 < doc.getLength() && doc.get(forward, 4).equals("\\end") && (backward = this.scanner.findAnyNonBlankBackward(backward, line.getOffset(), false)) != -1 && doc.getChar(backward) == '}' && (backward = this.scanner.scanBackward(backward, line.getOffset(), '\\')) != -1 && (backward == 0 || doc.getChar(backward - 1) != '\\') && doc.get(backward + 1, 5).equals("begin")) {
            command.text = String.valueOf(command.text) + command.text;
        }
        this.smartIndentLine2(command, false, 1, null);
    }

    private int searchParseStart(int offset) throws BadLocationException, BadPartitioningException {
        AbstractDocument doc = this.getDocument();
        ITypedRegion partition = doc.getPartition(this.getDocumentContentInfo().getPartitioning(), offset, false);
        if (partition.getType() == "Ltx.Default") {
            return offset;
        }
        if (partition.getType() == "Ltx.Math" || partition.getType() == "Ltx.MathComment") {
            return LtxHeuristicTokenScanner.getSafeMathPartitionOffset((IDocumentPartitioner)doc.getDocumentPartitioner(this.getDocumentContentInfo().getPartitioning()), (int)offset);
        }
        if (partition.getType() == "Ltx.Comment" || partition.getType() == "Ltx.Verbatim") {
            return partition.getOffset() + partition.getLength();
        }
        return -1;
    }

    private Position[] smartIndentLine2(DocumentCommand command, boolean indentCurrentLine, int setCaret, Position[] tracePos) throws BadLocationException, BadPartitioningException, CoreException {
        int dummyDocEnd;
        int line;
        String smartAppend;
        int smartEnd;
        if (this.getEditor3() == null) {
            return tracePos;
        }
        AbstractDocument doc = this.getDocument();
        int cEnd = command.offset + command.length;
        TextRegion validRegion = this.getValidRange();
        if (cEnd > validRegion.getEndOffset()) {
            return tracePos;
        }
        this.scanner.configure((IDocument)doc);
        if (this.endsWithNewLine(command.text)) {
            IRegion cEndLine = doc.getLineInformationOfOffset(cEnd);
            int validEnd = cEndLine.getOffset() + cEndLine.getLength() <= validRegion.getEndOffset() ? cEndLine.getOffset() + cEndLine.getLength() : validRegion.getEndOffset();
            int next = this.scanner.findAnyNonBlankForward(cEnd, validEnd, false);
            smartEnd = next >= 0 ? next : validEnd;
            smartAppend = "";
        } else {
            smartEnd = cEnd;
            smartAppend = "";
        }
        int shift = 0;
        if (command.offset < validRegion.getStartOffset() || command.offset > validRegion.getEndOffset()) {
            return tracePos;
        }
        if (command.offset > 2500 && (line = doc.getLineOfOffset(command.offset) - 40) >= 10) {
            int lineOffset = doc.getLineOffset(line);
            shift = this.searchParseStart(lineOffset);
        }
        if (shift < validRegion.getStartOffset()) {
            shift = validRegion.getStartOffset();
        }
        if ((dummyDocEnd = cEnd + 1500) > validRegion.getEndOffset()) {
            dummyDocEnd = validRegion.getEndOffset();
        }
        StringBuilder s = new StringBuilder(command.offset - shift + command.text.length() + (smartEnd - cEnd) + smartAppend.length() + (dummyDocEnd - smartEnd));
        s.append(doc.get(shift, command.offset - shift));
        s.append(command.text);
        if (smartEnd - cEnd > 0) {
            s.append(doc.get(cEnd, smartEnd - cEnd));
        }
        s.append(smartAppend);
        s.append(doc.get(smartEnd, dummyDocEnd - smartEnd));
        String text = s.toString();
        int dummyCoffset = command.offset - shift;
        int dummyCend = dummyCoffset + command.text.length();
        Document dummyDoc = new Document(text);
        StringParserInput parserInput = Display.getCurrent() == Display.getDefault() ? DEFAULT_PARSER_INPUT.reset(text) : new StringParserInput(text);
        int dummyFirstLine = dummyDoc.getLineOfOffset(dummyCoffset);
        int dummyLastLine = dummyDoc.getLineOfOffset(dummyCend);
        if (!indentCurrentLine) {
            ++dummyFirstLine;
        }
        if (dummyFirstLine > dummyLastLine) {
            return tracePos;
        }
        LtxParser scanner = new LtxParser((LtxLexer)new NowebLtxLexer(), null);
        SourceComponent rootNode = scanner.parseSourceUnit(parserInput.init(), this.texCoreAccess.getTexCommandSet());
        if (this.indenter == null) {
            this.indenter = new LtxSourceIndenter();
        }
        this.indenter.setup(this.texCoreAccess);
        TextEdit edit = this.indenter.getIndentEdits((AbstractDocument)dummyDoc, (TexAstNode)rootNode, 0, dummyFirstLine, dummyLastLine);
        Position cPos = new Position(dummyCoffset, command.text.length());
        dummyDoc.addPosition(cPos);
        if (tracePos != null) {
            int i = 0;
            while (i < tracePos.length) {
                tracePos[i].offset -= shift;
                dummyDoc.addPosition(tracePos[i]);
                ++i;
            }
        }
        command.length = command.length + edit.getLength() - TextUtil.overlaps((int)edit.getOffset(), (int)edit.getExclusiveEnd(), (int)dummyCoffset, (int)dummyCend);
        if (edit.getOffset() < dummyCoffset) {
            dummyCoffset = edit.getOffset();
            command.offset = shift + dummyCoffset;
        }
        edit.apply((IDocument)dummyDoc, 0);
        int dummyChangeEnd = edit.getExclusiveEnd();
        dummyCend = cPos.getOffset() + cPos.getLength();
        if (!cPos.isDeleted && dummyCend > dummyChangeEnd) {
            dummyChangeEnd = dummyCend;
        }
        command.text = dummyDoc.get(dummyCoffset, dummyChangeEnd - dummyCoffset);
        if (setCaret != 0) {
            command.caretOffset = shift + this.indenter.getNewIndentOffset(dummyFirstLine + setCaret - 1);
            command.shiftsCaret = false;
        }
        this.indenter.clear();
        if (tracePos != null) {
            int i = 0;
            while (i < tracePos.length) {
                tracePos[i].offset += shift;
                ++i;
            }
        }
        return tracePos;
    }

    protected void smartLineWrap(DocumentCommand command) throws BadLocationException, BadPartitioningException, CoreException {
        if (command.length != 0) {
            return;
        }
        this.hardLineWrap.doWrapB((IDocument)this.getDocument(), command, this.texCodeStyle.getLineWidth());
    }

    private LinkedModeUI createLinkedMode(int offset, char type, int mode) throws BadLocationException {
        LinkedModeModel model = new LinkedModeModel();
        int pos = 0;
        LinkedPositionGroup group = new LinkedPositionGroup();
        LinkedModeBracketLevel.InBracketPosition position = TexBracketLevel.createPosition(type, (IDocument)this.getDocument(), offset + 1, 0, pos++);
        group.addPosition((LinkedPosition)position);
        model.addGroup(group);
        model.forceInstall();
        TexBracketLevel level = new TexBracketLevel(model, (IDocument)this.getDocument(), this.getDocumentContentInfo(), (List<? extends LinkedPosition>)ImCollections.newList((Object)position), mode & 0xFFFF0000);
        LinkedModeUI ui = new LinkedModeUI(model, (ITextViewer)this.getViewer());
        ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
        ui.setExitPosition((ITextViewer)this.getViewer(), offset + (mode & 0xFF), 0, pos);
        ui.setSimpleMode(true);
        ui.setExitPolicy((LinkedModeUI.IExitPolicy)level);
        return ui;
    }

    public static class Settings
    implements SmartInsertSettings,
    ISettingsChangedHandler {
        private final TexCoreAccess coreAccess;
        private boolean enabledByDefault;
        private SmartInsertSettings.TabAction tabAction;
        private boolean closeBrackets;
        private boolean closeParenthesis;
        private boolean closeMathDollar;
        private boolean hardWrapText;

        public Settings(TexCoreAccess coreAccess) {
            this.coreAccess = coreAccess;
            this.updateSettings();
        }

        public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
            if (groupIds == null || groupIds.contains("tex/tex.editor/smartinsert")) {
                this.updateSettings();
            }
        }

        private void updateSettings() {
            PreferenceAccess prefs = this.coreAccess.getPrefs();
            this.enabledByDefault = (Boolean)prefs.getPreferenceValue(TexEditingSettings.SMARTINSERT_BYDEFAULT_ENABLED_PREF);
            this.tabAction = (SmartInsertSettings.TabAction)prefs.getPreferenceValue(TexEditingSettings.SMARTINSERT_TAB_ACTION_PREF);
            this.closeBrackets = (Boolean)prefs.getPreferenceValue(TexEditingSettings.SMARTINSERT_CLOSEBRACKETS_ENABLED_PREF);
            this.closeParenthesis = (Boolean)prefs.getPreferenceValue(TexEditingSettings.SMARTINSERT_CLOSEPARENTHESIS_ENABLED_PREF);
            this.closeMathDollar = (Boolean)prefs.getPreferenceValue(TexEditingSettings.SMARTINSERT_CLOSEMATHDOLLAR_ENABLED_PREF);
            this.hardWrapText = (Boolean)prefs.getPreferenceValue(TexEditingSettings.SMARTINSERT_HARDWRAP_TEXT_ENABLED_PREF);
        }

        public boolean isSmartInsertEnabledByDefault() {
            return this.enabledByDefault;
        }

        public SmartInsertSettings.TabAction getSmartInsertTabAction() {
            return this.tabAction;
        }
    }
}

