/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.refactoring.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ltk.refactoring.core.Messages;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringDescriptor;
import org.eclipse.statet.ltk.refactoring.core.DynamicValidationRefactoringChange;
import org.eclipse.statet.ltk.refactoring.core.RefactoringAdapter;
import org.eclipse.statet.ltk.refactoring.core.RefactoringDestination;
import org.eclipse.statet.ltk.refactoring.core.RefactoringMessages;
import org.eclipse.statet.ltk.refactoring.core.TextChangeManager;

public abstract class CommonMoveProcessor
extends MoveProcessor {
    private final RefactoringAdapter adapter;
    private final ElementSet elementsToMove;
    private final RefactoringDestination destination;
    private Change moveChange;
    private ReorgExecutionLog executionLog;

    public CommonMoveProcessor(ElementSet elements, RefactoringDestination destination, RefactoringAdapter adapter) {
        assert (elements != null);
        assert (adapter != null);
        this.elementsToMove = elements;
        this.destination = destination;
        if (destination.getInitialObjects().size() != 1 || !(destination.getInitialObjects().get(0) instanceof LtkModelElement)) {
            throw new IllegalArgumentException();
        }
        this.adapter = adapter;
    }

    public abstract String getIdentifier();

    protected abstract String getRefactoringIdentifier();

    public Object[] getElements() {
        Object[] elements = this.elementsToMove.getInitialObjects().toArray(new Object[this.elementsToMove.getInitialObjects().size() + 1]);
        elements[elements.length - 1] = this.destination.getInitialObjects().get(0);
        return elements;
    }

    public String getProcessorName() {
        return Messages.MoveRefactoring_label;
    }

    public boolean isApplicable() throws CoreException {
        return this.adapter.canInsert(this.elementsToMove, this.destination) && this.adapter.canDelete(this.elementsToMove);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.adapter.checkInitialToModify(result, this.destination);
        this.adapter.checkInitialToModify(result, this.elementsToMove);
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_FinalCheck_label, (int)13);
        try {
            RefactoringStatus result = new RefactoringStatus();
            this.elementsToMove.removeElementsWithAncestorsOnList();
            this.elementsToMove.postProcess();
            this.adapter.checkFinalToDelete(result, this.elementsToMove);
            this.adapter.checkFinalToModify(result, this.destination, (IProgressMonitor)m.newChild(1));
            m.worked(1);
            TextChangeManager textManager = new TextChangeManager();
            this.moveChange = this.adapter.createChangeToMove(this.getProcessorName(), this.elementsToMove, this.destination, textManager, (IProgressMonitor)m.newChild(10));
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            this.adapter.buildDeltaToModify(this.elementsToMove, deltaFactory);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        finally {
            m.done();
        }
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        ArrayList<RefactoringParticipant> result = new ArrayList<RefactoringParticipant>();
        this.executionLog = new ReorgExecutionLog();
        this.adapter.addParticipantsToMove(this.elementsToMove, this.destination, result, status, (RefactoringProcessor)this, shared, this.executionLog);
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask(RefactoringMessages.Common_CreateChanges_label, 1);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String description = this.elementsToMove.getElementCount() == 1 ? Messages.MoveRefactoring_description_singular : Messages.MoveRefactoring_description_plural;
            IProject resource = this.elementsToMove.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? NLS.bind((String)RefactoringMessages.Common_Source_Project_label, (Object)project) : RefactoringMessages.Common_Source_Workspace_label;
            boolean flags = false;
            String comment = "";
            CommonRefactoringDescriptor descriptor = new CommonRefactoringDescriptor(this.getIdentifier(), project, description, "", arguments, 0);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, Messages.MoveRefactoring_label, new Change[]{this.moveChange}, this.executionLog);
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }
}

