/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.yaml.core.source.ast.NodeType;
import org.eclipse.statet.yaml.core.source.ast.Scalar;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.source.ast.YamlAstVisitor;
import org.eclipse.statet.yaml.core.source.ast.YamlAsts;

@NonNullByDefault
public class SeqEntry
extends YamlAstNode {
    int valueIndicatorOffset = Integer.MIN_VALUE;
    YamlAstNode valueChild;

    SeqEntry(YamlAstNode parent, int startOffset, int endOffset) {
        super(parent, startOffset, endOffset);
        this.valueIndicatorOffset = startOffset;
    }

    @Override
    void finish(int endOffset) {
        if (this.valueChild == null) {
            this.valueChild = new Scalar.Plain(this, this.valueIndicatorOffset != Integer.MIN_VALUE ? this.valueIndicatorOffset : this.valueChild.endOffset);
        }
        super.finish(endOffset);
        int min = this.valueChild.endOffset;
        if (this.endOffset < min) {
            this.endOffset = min;
        }
    }

    @Override
    protected boolean hasErrorInChild() {
        return YamlAsts.hasErrors((AstNode)this.valueChild);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SEQ_ENTRY;
    }

    public int getValueIndicatorOffset() {
        return this.valueIndicatorOffset;
    }

    public boolean hasChildren() {
        return true;
    }

    public int getChildCount() {
        return 1;
    }

    public YamlAstNode getValue() {
        return this.valueChild;
    }

    @Override
    public YamlAstNode getChild(int index) {
        switch (index) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
        }
        return this.valueChild;
    }

    public int getChildIndex(AstNode child) {
        if (child == this.valueChild) {
            return 0;
        }
        return -1;
    }

    public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.valueChild);
    }

    @Override
    public void acceptInYaml(YamlAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public void acceptInYamlChildren(YamlAstVisitor visitor) throws InvocationTargetException {
        this.valueChild.acceptInYaml(visitor);
    }
}

