/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIntList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.CallArg;
import org.eclipse.statet.r.core.source.ast.CallArgs;
import org.eclipse.statet.r.core.source.ast.Expression;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;
import org.eclipse.statet.r.core.source.ast.RParser;

@NonNullByDefault
public abstract class SubIndexed
extends RAstNode {
    final Expression expr = new Expression();
    final Args sublist = new Args(this);
    int openOffset = Integer.MIN_VALUE;
    int closeOffset = Integer.MIN_VALUE;
    int close2Offset = Integer.MIN_VALUE;

    SubIndexed() {
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 2;
    }

    @Override
    public final RAstNode getChild(int index) {
        return switch (index) {
            case 0 -> this.expr.node;
            case 1 -> this.sublist;
            default -> throw new IndexOutOfBoundsException();
        };
    }

    public final RAstNode getRefChild() {
        return this.expr.node;
    }

    public final Args getArgsChild() {
        return this.sublist;
    }

    public final int getSublistOpenOffset() {
        return this.openOffset;
    }

    public final int getSublistCloseOffset() {
        return this.closeOffset;
    }

    public final int getSublistClose2Offset() {
        return this.closeOffset;
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (this.expr.node == child) {
            return 0;
        }
        if (this.sublist == child) {
            return 1;
        }
        return -1;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        this.expr.node.acceptInR(visitor);
        this.sublist.acceptInR(visitor);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.expr.node);
        visitor.visit((AstNode)this.sublist);
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        if (this.expr.node == child) {
            return this.expr;
        }
        return null;
    }

    @Override
    final Expression getLeftExpr() {
        return this.expr;
    }

    @Override
    final @Nullable Expression getRightExpr() {
        return null;
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        if (this.getNodeType() == element.getNodeType()) {
            SubIndexed other = (SubIndexed)element;
            return this.expr.node == other.expr.node || this.expr.node != null && this.expr.node.equalsSingle(other.expr.node);
        }
        return false;
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        if (this.expr == expr) {
            return 4195089;
        }
        throw new IllegalArgumentException();
    }

    final void updateOffsets() {
        this.startOffset = this.expr.node.startOffset;
        this.endOffset = this.close2Offset != Integer.MIN_VALUE ? this.close2Offset + 1 : (this.closeOffset != Integer.MIN_VALUE ? this.closeOffset + 1 : this.sublist.endOffset);
    }

    public static final class Arg
    extends CallArg {
        Arg(Args parent) {
            this.rParent = parent;
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.SUB_INDEXED_ARG;
        }

        @Override
        public @Nullable Args getRParent() {
            return (Args)this.rParent;
        }

        @Override
        public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
            visitor.visit(this);
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return NodeType.SUB_INDEXED_ARG == element.getNodeType();
        }
    }

    public static final class Args
    extends CallArgs {
        private ImList<Arg> args;
        private ImIntList sepOffsets;

        Args(SubIndexed parent) {
            this.rParent = parent;
        }

        void finish(RParser.ArgsBuilder<Arg> argsBuilder) {
            this.args = ImCollections.toList(argsBuilder.args);
            this.sepOffsets = ImCollections.toIntList((IntList)argsBuilder.sepOffsets);
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.SUB_INDEXED_ARGS;
        }

        @Override
        public ImIntList getSeparatorOffsets() {
            return this.sepOffsets;
        }

        @Override
        public final boolean hasChildren() {
            return !this.args.isEmpty();
        }

        @Override
        public final int getChildCount() {
            return this.args.size();
        }

        @Override
        public final Arg getChild(int index) {
            return (Arg)((Object)this.args.get(index));
        }

        @Override
        public final int getChildIndex(AstNode child) {
            int i = this.args.size() - 1;
            while (i >= 0) {
                if (this.args.get(i) == child) {
                    return i;
                }
                --i;
            }
            return -1;
        }

        public ImList<Arg> getArgChildren() {
            return this.args;
        }

        @Override
        public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
            visitor.visit(this);
        }

        @Override
        public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
            for (RAstNode arg : this.args) {
                arg.acceptInR(visitor);
            }
        }

        public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
            for (RAstNode child : this.args) {
                visitor.visit((AstNode)child);
            }
        }

        @Override
        final boolean equalsSingle(RAstNode element) {
            return NodeType.SUB_INDEXED_ARGS == element.getNodeType();
        }
    }

    static final class D
    extends SubIndexed {
        D() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.SUB_INDEXED_D;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.SUB_INDEXED_D_OPEN;
        }
    }

    static final class S
    extends SubIndexed {
        S() {
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.SUB_INDEXED_S;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.SUB_INDEXED_S_OPEN;
        }
    }
}

