/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkg;

public class VersionListRPkg
implements RPkg {
    private final String name;
    private RNumVersion version;

    public VersionListRPkg(String name, RNumVersion version) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.version = version != null ? version : RNumVersion.NONE;
    }

    public String getName() {
        return this.name;
    }

    public RNumVersion getVersion() {
        return this.version;
    }

    public void addVersion(RNumVersion version) {
        if (this.version.equals((Object)version) || version == RNumVersion.NONE) {
            return;
        }
        if (this.version == RNumVersion.NONE) {
            this.version = version;
            return;
        }
        String listString = this.version.toString();
        String addString = version.toString();
        int i = 0;
        while (i < listString.length()) {
            int idx = listString.indexOf(addString, i);
            if (idx < 0) break;
            if ((idx == 0 || listString.regionMatches(idx - 2, ", ", 0, 2)) && (idx + addString.length() == listString.length() || listString.regionMatches(idx + addString.length(), ", ", 0, 2))) {
                return;
            }
            ++i;
        }
        this.version = RNumVersion.create((String)(String.valueOf(listString) + ", " + addString));
    }

    public int hashCode() {
        return this.name.hashCode() + this.version.hashCode() * 7;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                void other;
                if (this == obj) break block2;
                Object object = obj;
                if (!(object instanceof RPkg)) break block3;
                RPkg rPkg = (RPkg)object;
                RPkg cfr_ignored_0 = (RPkg)object;
                if (this.name.equals(other.getName()) && this.version.equals((Object)other.getVersion())) break block2;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return this.name;
    }
}

