/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import java.util.Arrays;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.ecommons.debug.core.model.IndexedValue;
import org.eclipse.statet.ecommons.debug.core.model.VariableDim;
import org.eclipse.statet.ecommons.debug.core.model.VariablePartitionFactory;
import org.eclipse.statet.internal.r.debug.core.model.BasicRVariable;
import org.eclipse.statet.internal.r.debug.core.model.RArrayIndexVariable;
import org.eclipse.statet.internal.r.debug.core.model.RArrayValue;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTargetImpl;
import org.eclipse.statet.internal.r.debug.core.model.RElementValue;
import org.eclipse.statet.internal.r.debug.core.model.RIndexElementValue;
import org.eclipse.statet.internal.r.debug.core.model.RIndexValueInternal;
import org.eclipse.statet.internal.r.debug.core.model.RVariableProxy;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.debug.core.RValue;
import org.eclipse.statet.r.debug.core.RVariable;

@NonNullByDefault
public class RArrayDimVariable
extends BasicRVariable
implements RVariable,
VariableDim,
RIndexValueInternal {
    private final RArrayValue mainValue;
    private final int[] dimIndex;

    public RArrayDimVariable(RArrayValue value, int[] selected, RVariable parent) {
        super((RDebugTargetImpl)value.getDebugTarget(), parent);
        this.mainValue = value;
        this.dimIndex = selected;
    }

    @Override
    public CombinedRElement getElement() {
        return this.mainValue.element;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        int m = this.mainValue.dimCount - this.dimIndex.length;
        sb.append("[ ");
        int i = 0;
        while (i < m) {
            sb.append(", ");
            ++i;
        }
        i = m;
        while (i < this.mainValue.dimCount - 1) {
            sb.append(this.dimIndex[i - m] + 1);
            sb.append(", ");
            ++i;
        }
        sb.append(this.dimIndex[this.dimIndex.length - 1] + 1);
        sb.append(']');
        String name = this.mainValue.getDimItemName(m, this.dimIndex[0]);
        if (name != null) {
            sb.append(' ');
            sb.append(name);
        }
        return sb.toString();
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    @Override
    public RValue getValue() throws DebugException {
        return this;
    }

    @Override
    public RVariable getAssignedVariable() {
        return this;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    @Override
    public String getReferenceTypeName() throws DebugException {
        return "";
    }

    @Override
    public String getValueString() {
        StringBuilder sb = new StringBuilder();
        int m = this.mainValue.dimCount - this.dimIndex.length;
        sb.append('[');
        sb.append(this.mainValue.dim.getInt(0));
        int i = 1;
        while (i < m) {
            sb.append('\u00d7');
            sb.append(this.mainValue.dim.getInt(i));
            ++i;
        }
        sb.append(']');
        String dimName = this.mainValue.getDimName(m - 1);
        if (dimName != null) {
            sb.append(" / ");
            sb.append(dimName);
        }
        return sb.toString();
    }

    @Override
    public boolean supportsValueModification() {
        return false;
    }

    @Override
    public boolean verifyValue(String expression) throws DebugException {
        throw this.newNotSupported();
    }

    @Override
    public String getDetailString() {
        return "";
    }

    public boolean hasVariables() throws DebugException {
        return this.mainValue.dim.getInt(this.mainValue.dimCount - this.dimIndex.length) > 0;
    }

    public @NonNull IVariable[] getVariables() throws DebugException {
        return this.getPartitionFactory().getVariables((IndexedValue)this);
    }

    @Override
    public final VariablePartitionFactory<RIndexElementValue> getPartitionFactory() {
        return RElementValue.PARTITION_FACTORY;
    }

    public long getSize() throws DebugException {
        return this.mainValue.dim.getInt(this.mainValue.dimCount - this.dimIndex.length - 1);
    }

    public @NonNull RVariable[] getVariables(long offset, int length) {
        return this.getVariables(offset, length, this);
    }

    @Override
    public @NonNull RVariable[] getVariables(long offset, int length, RVariable parent) {
        int n = this.mainValue.dim.getInt(this.mainValue.dimCount - this.dimIndex.length - 1);
        if (n <= 0) {
            throw new UnsupportedOperationException();
        }
        if (offset < 0L || length < 0 || offset > (long)(n - length)) {
            throw new IllegalArgumentException();
        }
        int o = (int)offset;
        RVariable[] variables = new RVariable[length];
        if (this.dimIndex.length == this.mainValue.dimCount - 1) {
            int i = 0;
            while (i < length) {
                int[] d = new int[this.dimIndex.length + 1];
                System.arraycopy(this.dimIndex, 0, d, 1, this.dimIndex.length);
                d[0] = o + i;
                variables[i] = new RArrayIndexVariable(this.mainValue, d, parent);
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                int[] d = new int[this.dimIndex.length + 1];
                System.arraycopy(this.dimIndex, 0, d, 1, this.dimIndex.length);
                d[0] = o + i;
                variables[i] = new RArrayDimVariable(this.mainValue, d, parent);
                ++i;
            }
        }
        return variables;
    }

    public int hashCode() {
        return this.mainValue.hashCode() + Arrays.hashCode(this.dimIndex);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                void other;
                if (this == obj || this == (obj = RVariableProxy.unproxy(obj))) break block2;
                Object object = obj;
                if (!(object instanceof RArrayDimVariable)) break block3;
                RArrayDimVariable rArrayDimVariable = (RArrayDimVariable)object;
                RArrayDimVariable cfr_ignored_0 = (RArrayDimVariable)object;
                if (this.mainValue.equals(other.mainValue) && Arrays.equals(this.dimIndex, other.dimIndex)) break block2;
            }
            return false;
        }
        return true;
    }
}

