/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class RHelpWebapp {
    public static final String CONTEXT_PATH = "/rhelp";
    public static final String IMAGES = "images";
    public static final String CAT_LIBRARY = "library";
    public static final String CAT_DOC = "doc";
    public static final String LIBRARY_HTML = "html";
    public static final String LIBRARY_HELP = "help";
    public static final String LIBRARY_DOC = "doc";
    public static final String LIBRARY_DESCRIPTION = "description";
    public static final byte PKGCMD_IDX = 1;
    public static final byte PKGCMD_HTML_PAGE = 2;
    public static final byte PKGCMD_HTML_RESOURCE = 3;
    public static final byte PKGCMD_TOPIC = 4;
    public static final byte PKGCMD_DOC_IDX = 5;
    public static final byte PKGCMD_DOC_RES = 6;
    public static final byte PKGCMD_DESCRIPTION_RES = 7;
    public static final String HTML_EXAMPLES_HEADER_ADD = "<!-- EXAMPLES-ADD -->";
    public static final String HTML_EXAMPLES_BEGIN = "<!-- BEGIN-EXAMPLES -->";
    public static final String HTML_EXAMPLES_END = "<!-- END-EXAMPLES -->";
    public static final String PAR_QUERY_STRING = "qs";
    public static final String PAR_ACTION = "action";
    public static final String ACTION_OPEN = "open";
    public static final String ACTION_RUN_EXAMPLES = "runExamples";

    /*
     * Enabled aggressive block sorting
     */
    public static @Nullable RequestInfo extractRequestInfo(@Nullable String path) {
        if (path == null) return null;
        int beginIdx = 1;
        int endIdx = path.indexOf(47, beginIdx);
        if (endIdx <= beginIdx) return null;
        String envId = path.substring(beginIdx, endIdx);
        beginIdx = endIdx + 1;
        if ((endIdx = path.indexOf(47, beginIdx)) == -1) return new RequestInfo(envId);
        switch (path.substring(beginIdx, endIdx)) {
            case "doc": {
                beginIdx = endIdx + 1;
                String detail = path.substring(beginIdx).replace('\\', '/');
                if (!detail.startsWith("/")) return new RequestInfo(envId, "doc", detail);
                detail = detail.substring(1);
                return new RequestInfo(envId, "doc", detail);
            }
            case "library": {
                beginIdx = endIdx + 1;
                endIdx = path.indexOf(47, beginIdx);
                if (endIdx <= beginIdx) return new RequestInfo(envId);
                String pkgName = path.substring(beginIdx, endIdx);
                beginIdx = endIdx + 1;
                if ((endIdx = path.indexOf(47, beginIdx)) == -1) {
                    RequestInfo requestInfo;
                    switch (path.substring(beginIdx)) {
                        case "description": {
                            requestInfo = new RequestInfo(envId, CAT_LIBRARY, 7, pkgName, null);
                            return requestInfo;
                        }
                    }
                    requestInfo = new RequestInfo(envId, CAT_LIBRARY, 1, pkgName, null);
                    return requestInfo;
                }
                if (endIdx <= beginIdx) return new RequestInfo(envId);
                String detail = path.substring(endIdx + 1);
                switch (path.substring(beginIdx, endIdx)) {
                    case "html": {
                        if (detail.indexOf(47, 0) != -1) return new RequestInfo(envId, CAT_LIBRARY, 3, pkgName, detail);
                        if (!detail.endsWith(".html")) return new RequestInfo(envId, CAT_LIBRARY, 2, pkgName, detail);
                        detail = detail.substring(0, detail.length() - 5);
                        return new RequestInfo(envId, CAT_LIBRARY, 2, pkgName, detail);
                    }
                    case "help": {
                        if (!detail.endsWith(".html")) return new RequestInfo(envId, CAT_LIBRARY, 4, pkgName, detail);
                        detail = detail.substring(0, detail.length() - 5);
                        return new RequestInfo(envId, CAT_LIBRARY, 4, pkgName, detail);
                    }
                    case "doc": {
                        if (detail.isEmpty()) return new RequestInfo(envId, CAT_LIBRARY, 5, pkgName, null);
                        if (!detail.equals("index.html")) return new RequestInfo(envId, CAT_LIBRARY, 6, pkgName, detail);
                        return new RequestInfo(envId, CAT_LIBRARY, 5, pkgName, null);
                    }
                }
                return new RequestInfo(envId);
            }
        }
        return new RequestInfo(envId);
    }

    @NonNullByDefault(value={})
    public static class RequestInfo {
        public final String rEnvId;
        public final @Nullable String cat;
        public final byte cmd;
        public final String pkgName;
        public final String detail;

        public RequestInfo(String rEnvId, String cat, String detail) {
            this.rEnvId = rEnvId;
            this.cat = cat;
            this.cmd = 0;
            this.pkgName = null;
            this.detail = detail;
        }

        public RequestInfo(String rEnvId, String cat, byte command, String pkgName, String detail) {
            this.rEnvId = rEnvId;
            this.cat = cat;
            this.cmd = command;
            this.pkgName = pkgName;
            this.detail = detail;
        }

        public RequestInfo(String rEnvId) {
            this.rEnvId = rEnvId;
            this.cat = null;
            this.cmd = 0;
            this.pkgName = null;
            this.detail = null;
        }
    }
}

