/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.impl.AbstractNumericStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;
import org.eclipse.statet.rj.data.impl.RDataResizeExtension;

@NonNullByDefault
public class RNumericB32Store
extends AbstractNumericStore
implements RDataResizeExtension<Double>,
ExternalizableRStore,
Externalizable {
    private int length;
    protected double[] realValues;

    public RNumericB32Store() {
        this.length = 0;
        this.realValues = EMPTY_DOUBLE_ARRAY;
    }

    public RNumericB32Store(int length) {
        this.length = length;
        this.realValues = new double[length];
    }

    public RNumericB32Store(double[] values) {
        this.length = values.length;
        this.realValues = values;
    }

    public RNumericB32Store(double[] values, int @Nullable [] naIdxs) {
        this.length = values.length;
        this.realValues = values;
        if (naIdxs != null) {
            int i = 0;
            while (i < naIdxs.length) {
                this.realValues[naIdxs[i]] = NA_numeric_DOUBLE;
                ++i;
            }
        }
    }

    public RNumericB32Store(double[] values, boolean @Nullable [] isNAs) {
        this.length = values.length;
        this.realValues = values;
        if (isNAs != null) {
            if (isNAs.length != this.length) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < isNAs.length) {
                if (isNAs[i]) {
                    this.realValues[i] = NA_numeric_DOUBLE;
                }
                ++i;
            }
        }
    }

    public RNumericB32Store(RJIO io, int length) throws IOException {
        this.length = length;
        this.realValues = io.readDoubleData(new double[length], length);
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        io.writeDoubleData(this.realValues, this.length);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.length = in.readInt();
        this.realValues = new double[this.length];
        int i = 0;
        while (i < this.length) {
            this.realValues[i] = Double.longBitsToDouble(in.readLong());
            ++i;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.length);
        int i = 0;
        while (i < this.length) {
            out.writeLong(Double.doubleToRawLongBits(this.realValues[i]));
            ++i;
        }
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    protected final int length() {
        return this.length;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        double v = this.realValues[idx];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) == 1954;
    }

    @Override
    public boolean isNA(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        double v = this.realValues[(int)idx];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) == 1954;
    }

    @Override
    public void setNA(int idx) {
        this.realValues[idx] = NA_numeric_DOUBLE;
    }

    @Override
    public void setNA(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.realValues[(int)idx] = NA_numeric_DOUBLE;
    }

    @Override
    public boolean isNaN(int idx) {
        double v = this.realValues[idx];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) != 1954;
    }

    @Override
    public boolean isNaN(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        double v = this.realValues[(int)idx];
        return Double.isNaN(v) && (int)Double.doubleToRawLongBits(v) != 1954;
    }

    @Override
    public boolean isMissing(int idx) {
        return Double.isNaN(this.realValues[idx]);
    }

    @Override
    public boolean isMissing(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return Double.isNaN(this.realValues[(int)idx]);
    }

    @Override
    public double getNum(int idx) {
        return this.realValues[idx];
    }

    @Override
    public double getNum(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.realValues[(int)idx];
    }

    @Override
    public void setNum(int idx, double value) {
        this.realValues[idx] = Double.isNaN(value) ? Double.NaN : value;
    }

    @Override
    public void setNum(long idx, double value) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.realValues[(int)idx] = Double.isNaN(value) ? Double.NaN : value;
    }

    private void prepareInsert(int[] idxs) {
        this.realValues = RNumericB32Store.prepareInsert(this.realValues, this.length, idxs);
        this.length += idxs.length;
    }

    public void insertNum(int idx, double value) {
        this.prepareInsert(new int[]{idx});
        this.realValues[idx] = Double.isNaN(value) ? Double.NaN : value;
    }

    @Override
    public void insertNA(int idx) {
        this.prepareInsert(new int[]{idx});
        this.realValues[idx] = NA_numeric_DOUBLE;
    }

    @Override
    public void insertNA(int[] idxs) {
        if (idxs.length == 0) {
            return;
        }
        this.prepareInsert(idxs);
        int idx = 0;
        while (idx < idxs.length) {
            this.realValues[idx] = NA_numeric_DOUBLE;
            ++idx;
        }
    }

    @Override
    public void remove(int idx) {
        this.realValues = RNumericB32Store.remove(this.realValues, this.length, new int[]{idx});
        --this.length;
    }

    @Override
    public void remove(int[] idxs) {
        this.realValues = RNumericB32Store.remove(this.realValues, this.length, idxs);
        this.length -= idxs.length;
    }

    @Override
    public Double get(int idx) {
        if (idx < 0 || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        double v = this.realValues[idx];
        return !Double.isNaN(v) || (int)Double.doubleToRawLongBits(v) != 1954 ? Double.valueOf(v) : null;
    }

    @Override
    public Double get(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        double v = this.realValues[(int)idx];
        return !Double.isNaN(v) || (int)Double.doubleToRawLongBits(v) != 1954 ? Double.valueOf(v) : null;
    }

    @Override
    public @Nullable Double[] toArray() {
        Double[] array = new Double[this.length];
        double[] reals = this.realValues;
        int i = 0;
        while (i < array.length) {
            double v = reals[i];
            if (!Double.isNaN(v) || (int)Double.doubleToRawLongBits(v) != 1954) {
                array[i] = v;
            }
            ++i;
        }
        return array;
    }
}

