/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.editors;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractMarkOccurrencesProvider;
import org.eclipse.statet.r.core.rmodel.RElementAccess;
import org.eclipse.statet.r.core.rmodel.RModelUtils;
import org.eclipse.statet.r.core.rmodel.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.source.ast.DocuComment;
import org.eclipse.statet.r.core.source.ast.DocuTag;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.SourceComponent;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public class RMarkOccurrencesLocator {
    public void run(AbstractMarkOccurrencesProvider.RunData run, SourceUnitModelInfo info, AstSelection astSelection, @Nullable ITextSelection orgSelection) throws BadLocationException, BadPartitioningException, UnsupportedOperationException {
        RAstNode node = (RAstNode)astSelection.getCovering();
        if (this.checkForAccess(run, node)) {
            return;
        }
        if (orgSelection != null && info instanceof RSourceUnitModelInfo) {
            int start = orgSelection.getOffset();
            int stop = start + orgSelection.getLength();
            if (info.getAst().getRoot() instanceof SourceComponent) {
                ImList comments = ((SourceComponent)info.getAst().getRoot()).getComments();
                block0: for (RAstNode comment : comments) {
                    if (comment.getEndOffset() < start) continue;
                    if (comment.getStartOffset() > stop) break;
                    if (comment.getNodeType() != NodeType.DOCU_AGGREGATION) continue;
                    DocuComment docuComment = (DocuComment)comment;
                    List tags = docuComment.getTags();
                    for (DocuTag tag : tags) {
                        if (tag.getEndOffset() < start) continue;
                        if (tag.getStartOffset() > stop) continue block0;
                        AstSelection selection = AstSelection.search((AstNode)tag, (int)start, (int)stop, (int)3);
                        node = (RAstNode)selection.getCovering();
                        if (!this.checkForAccess(run, node)) continue;
                        return;
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkForAccess(AbstractMarkOccurrencesProvider.RunData run, @Nullable RAstNode node) throws BadLocationException {
        if (node == null || node.getNodeType() != NodeType.SYMBOL && node.getNodeType() != NodeType.STRING_CONST) {
            return false;
        }
        do {
            ImList attachments = node.getAttachments();
            for (Object attachment : attachments) {
                void access;
                Object e = attachment;
                if (!(e instanceof RElementAccess)) continue;
                RElementAccess cfr_ignored_0 = (RElementAccess)e;
                RElementAccess cfr_ignored_1 = (RElementAccess)e;
                Map<Annotation, Position> annotations = this.checkDefault(run, (RElementAccess)access);
                if (annotations == null) continue;
                run.set(annotations);
                return true;
            }
        } while ((node = node.getRParent()) != null);
        return false;
    }

    private @Nullable Map<Annotation, Position> checkDefault(AbstractMarkOccurrencesProvider.RunData run, @Nullable RElementAccess access) throws BadLocationException {
        while (access != null) {
            RAstNode nameNode = access.getNameNode();
            if (nameNode == null) {
                return null;
            }
            if (run.accept(new Point(nameNode.getStartOffset(), nameNode.getEndOffset()))) {
                ImList allAccess = access.getAllInUnit(false);
                LinkedHashMap<Annotation, Position> annotations = new LinkedHashMap<Annotation, Position>(allAccess.size());
                for (RElementAccess access0 : allAccess) {
                    TextRegion region = RModelUtils.getNameSourceRegion((RElementAccess)access0);
                    String message = run.doc.get(access0.getNode().getStartOffset(), access0.getNode().getLength());
                    annotations.put(new Annotation(access0.isWriteAccess() ? "org.eclipse.statet.ecommons.text.editorAnnotations.WriteOccurrences" : "org.eclipse.statet.ecommons.text.editorAnnotations.CommonOccurrences", false, message), new Position(region.getStartOffset(), region.getLength()));
                }
                return annotations;
            }
            access = access.getNextSegment();
        }
        return null;
    }
}

