/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.statet.ecommons.ui.actions.AbstractScopeHandler;
import org.eclipse.statet.ecommons.ui.actions.WorkbenchScopingHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.actions.AbstractToolScopeHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.IPageSite;

@NonNullByDefault
public class CancelRunnableHandler
extends AbstractToolScopeHandler<ToolProcess> {
    public static final String MENU_ID = "org.eclipse.statet.nico.menus.Cancel";
    public static final String PAR_OPTIONS = "options";
    private final int options = this.getOptions();

    public CancelRunnableHandler(IWorkbenchWindow scope, String commandId) {
        super(scope, commandId);
    }

    public CancelRunnableHandler(IPageSite scope, ToolProvider toolProvider, String commandId) {
        super(scope, toolProvider, commandId);
    }

    private int getOptions() {
        String commandId;
        return switch (commandId = (String)ObjectUtils.nonNullAssert((Object)this.getCommandId())) {
            case "org.eclipse.statet.nico.commands.CancelCurrent" -> 0;
            case "org.eclipse.statet.nico.commands.CancelCurrentAndPause" -> 16;
            case "org.eclipse.statet.nico.commands.CancelAll" -> 1;
            default -> throw new IllegalArgumentException("commandId= " + commandId);
        };
    }

    @Override
    protected @Nullable Object execute(ExecutionEvent event, ToolProcess tool, IEvaluationContext evalContext) throws ExecutionException {
        ToolController controller;
        String optionsParameter = event.getParameter(PAR_OPTIONS);
        int options = this.options;
        if (optionsParameter != null) {
            try {
                options = Integer.decode(optionsParameter);
            }
            catch (NumberFormatException e) {
                throw new ExecutionException(String.format("Invalid parameter '%1$s'.", PAR_OPTIONS), (Throwable)e);
            }
        }
        ToolController toolController = controller = tool != null ? tool.getController() : null;
        if (controller == null) {
            return null;
        }
        if (!controller.cancelTask(options)) {
            Display.getCurrent().beep();
        }
        return null;
    }

    public static class WorkbenchHandler
    extends WorkbenchScopingHandler
    implements IExecutableExtension {
        protected AbstractScopeHandler createScopeHandler(Object scope) {
            String commandId = (String)ObjectUtils.nonNullAssert((Object)this.getCommandId());
            return new CancelRunnableHandler((IWorkbenchWindow)scope, commandId);
        }
    }
}

