/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.Externalizable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.rmi.Remote;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.server.AutoIdMap;
import org.eclipse.statet.rj.server.RjsComConfig;
import org.eclipse.statet.rj.server.RjsComObject;
import org.eclipse.statet.rj.server.RjsStatus;

public class BinExchange
implements RjsComObject,
Externalizable {
    private static final int C2S = 65536;
    private static final int S2C = 131072;
    private static final int OM_2 = 983040;
    private static final int OC_2 = -983041;
    private static final int UPLOAD = 0x100000;
    private static final int DOWNLOAD = 0x200000;
    private static final int OM_TYPE = 0xF00000;
    private static final int OM_CUSTOM = 65535;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final AutoIdMap<OutputStream> gCOutList = new AutoIdMap();
    @NonNullByDefault
    static RjsComConfig.PathResolver gSPathResolver = new RjsComConfig.PathResolver(){

        @Override
        public Path resolve(Remote client, String pathString) throws RjException {
            Path path = Path.of(pathString, new String[0]);
            if (!path.isAbsolute()) {
                throw new RjException("Relative path not supported.");
            }
            return path;
        }
    };
    private int options;
    private Remote ref;
    private String remoteFilePath;
    private RjsStatus status;
    private long inputLength;
    private InputStream inputStream;
    private int outputId;
    private byte[] bytes;

    public BinExchange(InputStream in, long length, String path, Remote ref, int options) {
        if (path == null || in == null || ref == null) {
            throw new NullPointerException();
        }
        if (path.length() <= 0) {
            throw new IllegalArgumentException("Invalid path: empty.");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Invalid length: negative.");
        }
        this.options = 0x110000 | 0xFFFF & options;
        this.ref = ref;
        this.remoteFilePath = path;
        this.inputLength = length;
        this.inputStream = in;
        this.outputId = 0;
    }

    public BinExchange(OutputStream out, String path, Remote ref, int options) {
        if (path == null || out == null || ref == null) {
            throw new NullPointerException();
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Illegal path argument.");
        }
        this.options = 0x210000 | 0xFFFF & options;
        this.ref = ref;
        this.inputLength = -1L;
        this.inputStream = null;
        this.outputId = gCOutList.put(out);
        this.remoteFilePath = path;
    }

    public BinExchange(String path, Remote ref, int options) {
        if (path == null || ref == null) {
            throw new NullPointerException();
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Illegal path argument.");
        }
        this.options = 0x210000 | 0xFFFF & options;
        this.ref = ref;
        this.inputLength = -1L;
        this.inputStream = null;
        this.outputId = 0;
        this.remoteFilePath = path;
    }

    public BinExchange() {
    }

    @Override
    public int getComType() {
        return 4;
    }

    public boolean isOK() {
        return this.status == null || this.status.getSeverity() == 0;
    }

    public RjsStatus getStatus() {
        return this.status;
    }

    public String getFilePath() {
        return this.remoteFilePath;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void clear() {
        gCOutList.remove(this.outputId);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        readOptions = in.readInt();
        this.remoteFilePath = in.readUTF();
        switch (readOptions & 0xFF0000) {
            case 0x110000: {
                this.ref = (Remote)in.readObject();
                length = this.inputLength = in.readLong();
                try {
                    file = BinExchange.gSPathResolver != null ? BinExchange.gSPathResolver.resolve(this.ref, this.remoteFilePath) : Path.of(this.remoteFilePath, new String[0]);
                    var6_9 = null;
                    var7_15 = null;
                    try {
                        out = Files.newOutputStream(file, new OpenOption[]{StandardOpenOption.CREATE_NEW});
                        try {
                            buffer = new byte[8192];
                            while (length > 0L) {
                                n = in.read(buffer, 0, (int)Math.min(8192L, length));
                                if (n == -1) {
                                    throw new IOException("Unexcepted end of stream.");
                                }
                                out.write(buffer, 0, n);
                                length -= (long)n;
                            }
                            this.status = RjsStatus.OK_STATUS;
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                        }
                    }
                    catch (Throwable var7_16) {
                        if (var6_9 == null) {
                            var6_9 = var7_16;
                        } else if (var6_9 != var7_16) {
                            var6_9.addSuppressed(var7_16);
                        }
                        throw var6_9;
                    }
                }
                catch (InvalidPathException | RjException e) {
                    this.status = new RjsStatus(4, 0, e.getMessage());
                    throw new IOException("Failed to resolve file path.");
                }
                catch (IOException e) {
                    this.status = new RjsStatus(4, 0, e.getMessage());
                    throw new IOException("Failed to write stream to file.");
                }
                this.options = readOptions & -983041 | 131072;
                return;
            }
            case 0x210000: {
                this.ref = (Remote)in.readObject();
                this.outputId = in.readInt();
                this.options = readOptions & -983041 | 131072;
                return;
            }
            case 0x120000: {
                this.status = new RjsStatus(in);
                this.options = readOptions & -983041;
                return;
            }
            case 0x220000: {
                this.outputId = in.readInt();
                this.status = new RjsStatus(in);
                if (this.status.getSeverity() != 0) ** GOTO lbl96
                length = this.inputLength = in.readLong();
                writing = false;
                try {
                    if (this.outputId > 0) {
                        out = BinExchange.gCOutList.get(this.outputId);
                        buffer = new byte[8192];
                        while (length > 0L) {
                            n = in.read(buffer, 0, (int)Math.min(8192L, length));
                            if (n == -1) {
                                throw new IOException("Unexcepted end of stream.");
                            }
                            length -= (long)n;
                            writing = true;
                            out.write(buffer, 0, n);
                            writing = false;
                        }
                    } else {
                        if (length > 0x7FFFFFFFL) {
                            throw new UnsupportedOperationException();
                        }
                        this.bytes = new byte[(int)length];
                        while (length > 0L) {
                            n = in.read(this.bytes, (int)(this.inputLength - length), (int)length);
                            if (n == -1) {
                                throw new IOException("Unexcepted end of stream.");
                            }
                            length -= (long)n;
                        }
                    }
                    ** GOTO lbl96
                }
                catch (IOException e) {
                    if (!writing) ** GOTO lbl95
                    this.status = new RjsStatus(4, 0, "Writing download to stream failed: " + e.getMessage());
                    try {
                        while (length > 0L) {
                            n = in.skip(length);
                            if (n == -1L) {
                                throw new IOException("Unexcepted end of stream.");
                            }
                            length -= n;
                        }
                        return;
                    }
                    catch (IOException e2) {
                        e = e2;
                    }
                }
lbl95:
                // 2 sources

                throw e;
lbl96:
                // 3 sources

                this.options = readOptions & -983041;
                return;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.options);
        out.writeUTF(this.remoteFilePath);
        switch (this.options & 0xFF0000) {
            case 0x110000: {
                out.writeObject(this.ref);
                out.writeLong(this.inputLength);
                if (this.inputStream != null) {
                    byte[] buffer = new byte[8192];
                    long length = this.inputLength;
                    while (length > 0L) {
                        int n = this.inputStream.read(buffer, 0, (int)Math.min(8192L, length));
                        if (n == -1) {
                            throw new IOException("Unexcepted end of stream.");
                        }
                        out.write(buffer, 0, n);
                        length -= (long)n;
                    }
                } else if (this.bytes != null) {
                    out.writeLong(this.inputLength);
                    out.write(this.bytes, 0, (int)this.inputLength);
                } else {
                    throw new IOException("Missing file content.");
                }
                return;
            }
            case 0x210000: {
                out.writeObject(this.ref);
                out.writeInt(this.outputId);
                return;
            }
            case 0x120000: {
                this.status.writeExternal(out);
                return;
            }
            case 0x220000: {
                out.writeInt(this.outputId);
                InputStream input = null;
                try {
                    try {
                        Path file = gSPathResolver != null ? gSPathResolver.resolve(this.ref, this.remoteFilePath) : Path.of(this.remoteFilePath, new String[0]);
                        try {
                            input = Files.newInputStream(file, new OpenOption[0]);
                            input.available();
                        }
                        catch (IOException e) {
                            if (!Files.exists(file, new LinkOption[0]) || e instanceof FileNotFoundException) {
                                new RjsStatus(4, 0, "Failed to find file '" + this.remoteFilePath + "'.").writeExternal(out);
                            }
                            new RjsStatus(4, 0, "Failed to open file '" + this.remoteFilePath + "'.").writeExternal(out);
                        }
                        if (input != null) {
                            RjsStatus.OK_STATUS.writeExternal(out);
                            long length = this.inputLength = Files.size(file);
                            out.writeLong(length);
                            byte[] buffer = new byte[8192];
                            while (length > 0L) {
                                int n = input.read(buffer, 0, (int)Math.min(8192L, length));
                                if (n == -1) {
                                    throw new IOException("Unexcepted end of file content.");
                                }
                                length -= (long)n;
                                out.write(buffer, 0, n);
                            }
                        }
                    }
                    catch (InvalidPathException | RjException e) {
                        this.status = new RjsStatus(4, 0, e.getMessage());
                        throw new IOException("Failed to resolve file path.");
                    }
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return;
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("DataCmdItem ");
        switch (this.options & 0xF00000) {
            case 0x100000: {
                sb.append("UPLOAD");
                break;
            }
            case 0x200000: {
                sb.append("DOWNLOAD");
                break;
            }
            default: {
                sb.append(this.options & 0xF00000);
            }
        }
        sb.append("\n\t").append("direction= ");
        switch (this.options & 0xF0000) {
            case 65536: {
                sb.append("CLIENT-2-SERVER");
                break;
            }
            case 131072: {
                sb.append("SERVER-2-CLIENT");
                break;
            }
            default: {
                sb.append(this.options & 0xF0000);
            }
        }
        sb.append("\n\tlength= ");
        sb.append(this.inputLength);
        if (this.status != null) {
            sb.append("\n<STATUS>\n");
            this.status.getCode();
            sb.append("\n</STATUS>");
        }
        return sb.toString();
    }
}

