/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.collections.IdentityList;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.yaml.core.source.ast.Directive;
import org.eclipse.statet.yaml.core.source.ast.Dummy;
import org.eclipse.statet.yaml.core.source.ast.NContainer;
import org.eclipse.statet.yaml.core.source.ast.NodeType;
import org.eclipse.statet.yaml.core.source.ast.SourceComponent;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.source.ast.YamlAstVisitor;
import org.eclipse.statet.yaml.core.source.ast.YamlParser;

@NonNullByDefault
public class DocumentNode
extends NContainer {
    ImIdentityList<Directive> directiveChildren;
    @Nullable YamlAstNode directivesEndChild;
    @Nullable YamlAstNode documentEndChild;
    ImIdentityList<YamlAstNode> contentChildren;

    DocumentNode(SourceComponent parent, int offset) {
        this.yamlParent = parent;
        this.startOffset = offset;
        this.endOffset = offset;
    }

    @Override
    void finish(int endOffset, YamlParser.NContainerBuilder containerBuilder) {
        super.finish(endOffset, containerBuilder);
        int startIdx = 0;
        int endIdx = 0;
        while (endIdx < this.children.size() && ((YamlAstNode)((Object)this.children.get(endIdx))).getNodeType() == NodeType.DIRECTIVE) {
            ++endIdx;
        }
        this.directiveChildren = this.children.subList(startIdx, endIdx);
        if (this.directivesEndChild != null) {
            ++endIdx;
        }
        startIdx = endIdx;
        endIdx = this.children.size();
        if (this.documentEndChild != null) {
            --endIdx;
        }
        if (startIdx == endIdx && this.directivesEndChild == null) {
            Dummy dummy = new Dummy(4334368, this, this.documentEndChild != null ? this.documentEndChild.getStartOffset() : this.endOffset);
            this.children = ImCollections.addElement((IdentityList)this.children, (int)startIdx, (Object)((Object)dummy));
            ++endIdx;
        }
        this.contentChildren = this.children.subList(startIdx, endIdx);
        if (this.contentChildren.size() > 1) {
            YamlAstNode child = (YamlAstNode)((Object)this.contentChildren.get(1));
            child.status = 0x400200 | child.status & 0x4000000;
        }
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.DOCUMENT;
    }

    public ImIdentityList<Directive> getDirectives() {
        return this.directiveChildren;
    }

    public @Nullable YamlAstNode getDirectivesEndMarker() {
        return this.directivesEndChild;
    }

    public ImIdentityList<YamlAstNode> getContentNodes() {
        return this.contentChildren;
    }

    public @Nullable YamlAstNode getDocumentEndMarker() {
        return this.documentEndChild;
    }

    @Override
    public void acceptInYaml(YamlAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }
}

