/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.issues.core.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.TaskIssueConfig;
import org.eclipse.statet.ltk.issues.core.TaskPriority;
import org.eclipse.statet.ltk.issues.core.TaskTag;
import org.eclipse.statet.ltk.issues.core.impl.BasicTask;

@NonNullByDefault
public abstract class TaskTagReporter {
    private ImList<TaskTag> taskTags = ImCollections.emptyList();
    private @Nullable Pattern taskTagPattern;
    private final Map<String, TaskPriority> taskTagMap = new HashMap<String, TaskPriority>();
    private SourceContent sourceContent = (SourceContent)((Object)ObjectUtils.nonNullLateInit());
    private IssueRequestor requestor = (IssueRequestor)ObjectUtils.nonNullLateInit();
    private @Nullable Matcher taskTagMatcher;

    public void configure(TaskIssueConfig config) {
        this.initTaskPattern(config.getTaskTags());
    }

    protected void initTaskPattern(ImList<TaskTag> taskTags) {
        if (taskTags.equals(this.taskTags)) {
            return;
        }
        this.taskTags = taskTags;
        this.taskTagPattern = null;
        this.taskTagMap.clear();
        if (taskTags.isEmpty()) {
            return;
        }
        String separatorRegex = "[^\\p{L}\\p{N}]";
        StringBuilder regex = new StringBuilder("[^\\p{L}\\p{N}]");
        regex.append('(');
        for (TaskTag taskTag : taskTags) {
            regex.append(Pattern.quote(taskTag.getKeyword()));
            regex.append('|');
            this.taskTagMap.put(taskTag.getKeyword(), taskTag.getPriority());
        }
        regex.setCharAt(regex.length() - 1, ')');
        regex.append("(?:\\z|").append("[^\\p{L}\\p{N}]").append(")");
        this.taskTagPattern = Pattern.compile(regex.toString());
    }

    public void setup(SourceContent sourceContent, IssueRequestor requestor) {
        this.sourceContent = (SourceContent)((Object)ObjectUtils.nonNullAssert((Object)((Object)sourceContent)));
        this.requestor = (IssueRequestor)ObjectUtils.nonNullAssert((Object)requestor);
        Pattern taskTagPattern = this.taskTagPattern;
        this.taskTagMatcher = taskTagPattern != null && sourceContent.getStartOffset() == 0 ? taskTagPattern.matcher(sourceContent.getString()) : null;
    }

    public void addTask(String match, String message, int offset, int lineNumber) {
        TaskPriority priority = this.taskTagMap.get(match);
        if (priority == null) {
            return;
        }
        BasicTask task = new BasicTask(priority, message, lineNumber, offset, offset + message.length());
        this.requestor.acceptTask(task);
    }

    public void checkForTasks(int startOffset, int endOffset) {
        Matcher matcher = this.taskTagMatcher;
        if (matcher == null) {
            return;
        }
        if (matcher.region(startOffset, endOffset).find()) {
            int tagStartOffset = matcher.start(1);
            int tagEndOffset = matcher.end(1);
            while (endOffset > tagEndOffset) {
                if (this.sourceContent.getChar(endOffset - 1) > ' ') break;
                --endOffset;
            }
            String text = this.sourceContent.getString(tagStartOffset, endOffset);
            this.addTask((String)ObjectUtils.nonNullAssert((Object)matcher.group(1)), text, tagStartOffset, this.sourceContent.getStringLines().getLineOfOffset(tagStartOffset) + 1);
        }
    }
}

