/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core.observable;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.Nullable;

public class WritableEqualityValue<TValue>
extends AbstractObservableValue<TValue> {
    private final @Nullable Object valueType;
    private TValue value = null;

    public WritableEqualityValue(@NonNull Realm realm, @Nullable TValue initialValue, @Nullable Object valueType) {
        super(realm);
        this.valueType = valueType;
        this.value = initialValue;
    }

    public WritableEqualityValue(@Nullable TValue initialValue, @Nullable Object valueType) {
        this(Realm.getDefault(), initialValue, valueType);
    }

    public WritableEqualityValue() {
        this(null, null);
    }

    public WritableEqualityValue(@NonNull Realm realm) {
        this(realm, null, null);
    }

    public Object getValueType() {
        return this.valueType;
    }

    public TValue doGetValue() {
        return this.value;
    }

    public void doSetValue(TValue value) {
        TValue oldValue = this.doGetValue();
        if (!(value == oldValue || value != null && value.equals(oldValue))) {
            this.value = value;
            this.fireValueChange(Diffs.createValueDiff(this.value, this.value));
        }
    }
}

