/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.internal.nico.ui.console.NIConsolePartitioner;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStreamMonitor;
import org.eclipse.statet.nico.ui.NicoUIPreferences;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.console.NIConsoleColorAdapter;
import org.eclipse.statet.nico.ui.console.NIConsoleOutputStream;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;

@NonNullByDefault
public abstract class NIConsole
extends TextConsole
implements IAdaptable {
    public static final String NICONSOLE_TYPE = "org.eclipse.statet.nico.console";
    public static final String ADJUST_OUTPUT_WIDTH_COMMAND_ID = "org.eclipse.statet.nico.commands.AdjustOutputWidth";
    private static boolean gFontInitialized;
    private final NIConsolePartitioner partitioner;
    private final Map<String, NIConsoleOutputStream> streams = new HashMap<String, NIConsoleOutputStream>();
    private boolean streamsClosed;
    private final ToolProcess process;
    private @Nullable NIConsoleColorAdapter adapter;
    private IDebugEventSetListener debugListener;
    private final SettingsListener settingsListener = new SettingsListener();
    private int currentWatermark;

    public NIConsole(ToolProcess process, NIConsoleColorAdapter adapter) {
        super(process.getAttribute(IProcess.ATTR_PROCESS_LABEL), NICONSOLE_TYPE, NicoUITools.getImageDescriptor(process), true);
        this.process = process;
        this.adapter = adapter;
        this.partitioner = new NIConsolePartitioner(this, adapter.getStreamIds());
        this.partitioner.connect(this.getDocument());
        if (!gFontInitialized) {
            UIAccess.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    NIConsole.this.setFont(null);
                    gFontInitialized = true;
                }
            });
        } else {
            this.setFont(null);
        }
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener((SettingsChangeNotifier.ChangeListener)this.settingsListener);
        this.updateWatermarks();
        this.streamsClosed = this.process.isTerminated();
        adapter.connect(process, this);
        this.debugListener = new IDebugEventSetListener(){

            public void handleDebugEvents(@NonNull DebugEvent[] events) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent event = debugEventArray[n2];
                    if (event.getSource() == NIConsole.this.process) {
                        switch (event.getKind()) {
                            case 16: {
                                String newName;
                                String[] attrChange;
                                Object obj = event.getData();
                                if (!(obj instanceof String[]) || (attrChange = (String[])obj).length != 3 || !IProcess.ATTR_PROCESS_LABEL.equals(attrChange[0]) || (newName = attrChange[2]) == null) break;
                                this.runSetName(newName);
                                break;
                            }
                            case 8: {
                                NIConsole.this.disconnect();
                            }
                        }
                    }
                    ++n2;
                }
            }

            private void runSetName(final String name) {
                UIAccess.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        NIConsole.this.setName(name);
                        ConsolePlugin.getDefault().getConsoleManager().refresh((IConsole)NIConsole.this);
                    }
                });
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.debugListener);
    }

    public final String getType() {
        return NICONSOLE_TYPE;
    }

    protected void updateSettings() {
        this.updateWatermarks();
    }

    protected void updateWatermarks() {
        boolean limitBufferSize = true;
        int lowWater = (Integer)EPreferences.getInstancePrefs().getPreferenceValue(NicoUIPreferences.OUTPUT_CHARLIMIT_PREF);
        if (lowWater < 100000) {
            lowWater = 100000;
        }
        if (lowWater == this.currentWatermark) {
            return;
        }
        int highWater = lowWater + 10000;
        this.partitioner.setWaterMarks(lowWater, highWater);
    }

    protected String getSymbolicFontName() {
        return "org.eclipse.jface.textfont";
    }

    public void setFont(@Nullable Font newFont) {
        if (newFont == null) {
            newFont = JFaceResources.getFont((String)this.getSymbolicFontName());
        }
        super.setFont(newFont);
    }

    protected void init() {
        super.init();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this.settingsListener);
    }

    public void clearConsole() {
        this.partitioner.clearBuffer();
    }

    protected void dispose() {
        FontRegistry fontRegistry;
        super.dispose();
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null) {
            debugPlugin.removeDebugEventListener(this.debugListener);
        }
        this.debugListener = null;
        SettingsChangeNotifier changeNotifier = PreferencesUtil.getSettingsChangeNotifier();
        if (changeNotifier != null) {
            changeNotifier.removeChangeListener((SettingsChangeNotifier.ChangeListener)this.settingsListener);
        }
        if ((fontRegistry = JFaceResources.getFontRegistry()) != null) {
            fontRegistry.removeListener((IPropertyChangeListener)this.settingsListener);
        }
        this.disconnect();
    }

    public abstract IPageBookViewPage createPage(IConsoleView var1);

    protected NIConsolePartitioner getPartitioner() {
        return this.partitioner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ToolStreamMonitor streamMonitor, String streamId, EnumSet<SubmitType> filter) {
        Map<String, NIConsoleOutputStream> map = this.streams;
        synchronized (map) {
            if (this.streamsClosed) {
                return;
            }
            NIConsoleOutputStream stream = this.streams.get(streamId);
            if (stream == null) {
                stream = new NIConsoleOutputStream(this, streamId);
                this.streams.put(streamId, stream);
            }
            final NIConsoleOutputStream out = stream;
            streamMonitor.addListener(new IStreamListener(){

                public void streamAppended(String text, IStreamMonitor monitor) {
                    try {
                        out.write(text);
                    }
                    catch (IOException e) {
                        NicoUIPlugin.logError(100, "Error of unexpected type occured, when writing to console stream.", e);
                    }
                }
            }, filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable NIConsoleOutputStream getStream(String streamId) {
        Map<String, NIConsoleOutputStream> map = this.streams;
        synchronized (map) {
            return this.streams.get(streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        Map<String, NIConsoleOutputStream> map = this.streams;
        synchronized (map) {
            if (this.streamsClosed) {
                return;
            }
            for (NIConsoleOutputStream stream : this.streams.values()) {
                stream.close();
            }
            this.streamsClosed = true;
            this.partitioner.finish();
            NIConsoleColorAdapter adapter = this.adapter;
            if (adapter != null) {
                this.adapter = null;
                adapter.disconnect();
            }
        }
    }

    public ToolProcess getProcess() {
        return this.process;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == Tool.class) {
            return (T)this.process;
        }
        if (adapterType == ILaunchConfiguration.class) {
            ILaunch launch = this.process.getLaunch();
            if (launch != null) {
                return (T)launch.getLaunchConfiguration();
            }
            return null;
        }
        return null;
    }

    private class SettingsListener
    implements SettingsChangeNotifier.ChangeListener,
    IPropertyChangeListener {
        private SettingsListener() {
        }

        public void settingsChanged(Set<String> groupIds) {
            NIConsoleColorAdapter adapter;
            if (groupIds.contains("nico.console")) {
                NIConsole.this.updateSettings();
            }
            if (groupIds.contains("nico.console/output/textstyle") && (adapter = NIConsole.this.adapter) != null) {
                adapter.updateSettings();
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (NIConsole.this.getSymbolicFontName().equals(event.getProperty())) {
                NIConsole.this.setFont(null);
            }
        }
    }
}

