/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.internal.nico.core.Messages;
import org.eclipse.statet.internal.nico.core.preferences.HistoryPreferences;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.OkStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.nico.core.NicoCoreMessages;
import org.eclipse.statet.nico.core.runtime.IHistoryListener;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStreamMonitor;
import org.eclipse.statet.nico.core.runtime.ToolStreamProxy;

public class History {
    private int maxSize = 10000;
    private int currentSize = 0;
    private volatile Entry newest;
    private volatile Entry oldest;
    private final ListenerList listeners = new ListenerList(1);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ToolProcess process;
    private IEclipsePreferences.IPreferenceChangeListener preferenceListener;
    private HistoryPreferences currentPreferences;
    private final Map<SubmitType, IStreamListener> streamListeners = new EnumMap<SubmitType, IStreamListener>(SubmitType.class);
    private volatile Entry[] arrayCache;

    History(ToolProcess process) {
        this.process = process;
        this.preferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                History.this.checkSettings(false);
            }
        };
        EPreferences.getInstancePrefs().addPreferenceNodeListener("org.eclipse.statet.nico.core/history", this.preferenceListener);
        this.checkSettings(false);
    }

    void init() {
        ToolController controller = this.process.getController();
        if (controller != null) {
            ToolStreamProxy streams = controller.getStreams();
            EnumSet<SubmitType> set = SubmitType.getDefaultSet();
            for (final SubmitType submitType : set) {
                IStreamListener listener = new IStreamListener(){

                    public void streamAppended(String text, IStreamMonitor monitor) {
                        if ((((ToolStreamMonitor)monitor).getMeta() & 1) == 0) {
                            History.this.addCommand(text, submitType);
                        }
                    }
                };
                this.streamListeners.put(submitType, listener);
                streams.getInputStreamMonitor().addListener(listener, EnumSet.of(submitType));
            }
        }
    }

    void dispose() {
        if (this.preferenceListener != null) {
            EPreferences.getInstancePrefs().addPreferenceNodeListener("org.eclipse.statet.nico.core/history", this.preferenceListener);
            this.preferenceListener = null;
        }
    }

    public final Lock getReadLock() {
        return this.lock.readLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSettings(boolean force) {
        HistoryPreferences prefs = new HistoryPreferences(EPreferences.getInstancePrefs());
        History history = this;
        synchronized (history) {
            if (!force && prefs.equals(this.currentPreferences)) {
                return;
            }
            this.currentPreferences = prefs;
            this.lock.writeLock().lock();
        }
        try {
            this.maxSize = prefs.getLimitCount();
            if (this.currentSize > this.maxSize) {
                this.trimSize();
                this.fireCompleteChange();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void trimSize() {
        while (this.currentSize > this.maxSize) {
            this.oldest = this.oldest.dispose();
            --this.currentSize;
        }
    }

    public Status load(Object file, String charset, boolean forceCharset, ProgressMonitor m) {
        m.beginTask(NicoCoreMessages.LoadHistoryJob_label, 4);
        try {
            final FileUtil fileUtil = FileUtil.getFileUtil((Object)file);
            final HistoryData exch = new HistoryData();
            FileUtil.ReaderAction action = new FileUtil.ReaderAction(){

                public void run(BufferedReader reader, IProgressMonitor monitor) throws IOException, CoreException {
                    long timeStamp = fileUtil.getTimeStamp((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (timeStamp < 0L) {
                        timeStamp = System.currentTimeMillis();
                    }
                    if (reader.ready()) {
                        String line = reader.readLine();
                        timeStamp = History.this.checkTimeStamp(line, timeStamp);
                        exch.newest = exch.oldest = new Entry(null, line, timeStamp, null);
                        exch.size = 1;
                        int maxSize = History.this.maxSize;
                        while (reader.ready()) {
                            line = reader.readLine();
                            timeStamp = History.this.checkTimeStamp(line, timeStamp);
                            exch.newest = new Entry(exch.newest, line, timeStamp, null);
                            if (exch.size < maxSize) {
                                ++exch.size;
                                continue;
                            }
                            exch.oldest = exch.oldest.dispose();
                        }
                    }
                    monitor.done();
                }
            };
            FileUtil.ReadTextFileOperation op = fileUtil.createReadTextFileOp(action);
            op.setCharset(charset, forceCharset);
            op.doOperation(EStatusUtils.convert((ProgressMonitor)m.newSubMonitor(3)));
            m.beginSubTask(NLS.bind((String)Messages.LoadHistory_AllocatingTask_label, (Object)this.process.getLabel(0)));
            this.lock.writeLock().lock();
            try {
                this.oldest = exch.oldest;
                this.newest = exch.newest;
                this.currentSize = exch.size;
                if (this.currentSize > this.maxSize) {
                    this.trimSize();
                }
                this.fireCompleteChange();
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return new OkStatus("org.eclipse.statet.nico.core", NLS.bind((String)Messages.LoadHistory_ok_message, (Object)fileUtil.getLabel()));
        }
        catch (CoreException e) {
            return new ErrorStatus("org.eclipse.statet.nico.core", NLS.bind((String)Messages.LoadHistory_error_message, (Object)this.process.getLabel(1), (Object)file.toString()), (Throwable)e);
        }
    }

    protected long checkTimeStamp(String line, long current) {
        return current;
    }

    public Status save(Object file, int mode, String charset, boolean forceCharset, ProgressMonitor m) throws OperationCanceledException {
        return this.save(file, mode, charset, forceCharset, null, m);
    }

    public Status save(Object file, int mode, String charset, boolean forceCharset, Set<SubmitType> submitTypes, ProgressMonitor m) throws OperationCanceledException {
        m.beginTask(NicoCoreMessages.SaveHistoryJob_label, 4);
        try {
            FileUtil fileUtil = FileUtil.getFileUtil((Object)file);
            String newLine = this.process.getWorkspaceData().getLineSeparator();
            StringBuilder buffer = new StringBuilder(this.currentSize * 10);
            Entry e = this.oldest;
            while (e != null) {
                if (m.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (submitTypes == null || e.submitTypes == null || submitTypes.contains((Object)e.submitTypes)) {
                    buffer.append(e.command);
                    buffer.append(newLine);
                }
                e = e.newer;
            }
            String content = buffer.toString();
            buffer = null;
            if (m.isCanceled()) {
                throw new OperationCanceledException();
            }
            m.addWorked(1);
            FileUtil.WriteTextFileOperation op = fileUtil.createWriteTextFileOp(content);
            op.setCharset(charset, forceCharset);
            op.setFileOperationMode(mode);
            op.doOperation(EStatusUtils.convert((ProgressMonitor)m.newSubMonitor(2)));
            return new OkStatus("org.eclipse.statet.nico.core", NLS.bind((String)Messages.SaveHistory_ok_message, (Object)fileUtil.getLabel()));
        }
        catch (CoreException e) {
            return new ErrorStatus("org.eclipse.statet.nico.core", NLS.bind((String)Messages.SaveHistory_error_message, (Object)this.process.getLabel(), (Object)file.toString()), (Throwable)e);
        }
    }

    final void addCommand(String command, SubmitType submitType) {
        assert (command != null);
        long stamp = System.currentTimeMillis();
        Entry removedEntry = null;
        Entry newEntry = null;
        this.lock.writeLock().lock();
        try {
            Object[] listeners;
            newEntry = new Entry(this.newest, command, stamp, submitType);
            if (this.newest != null) {
                this.newest.newer = newEntry;
            } else {
                this.oldest = newEntry;
            }
            this.newest = newEntry;
            if (this.currentSize == this.maxSize) {
                removedEntry = this.oldest;
                this.oldest = this.oldest.dispose();
            } else {
                ++this.currentSize;
            }
            Object[] objectArray = listeners = this.listeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                IHistoryListener listener = (IHistoryListener)obj;
                if (removedEntry != null) {
                    listener.entryRemoved(this, removedEntry);
                }
                listener.entryAdded(this, newEntry);
                ++n2;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public final Entry getNewest() {
        return this.newest;
    }

    public final Entry[] toArray() {
        Entry[] array = this.arrayCache;
        if (array != null) {
            return array;
        }
        array = new Entry[this.currentSize];
        Entry e = this.oldest;
        int i = 0;
        while (i < array.length) {
            array[i] = e;
            e = e.newer;
            ++i;
        }
        return array;
    }

    public final void addListener(IHistoryListener listener) {
        this.listeners.add((Object)listener);
    }

    public final void removeListener(IHistoryListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void fireCompleteChange() {
        this.arrayCache = this.toArray();
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ((IHistoryListener)obj).completeChange(this, this.arrayCache);
            ++n2;
        }
        this.arrayCache = null;
    }

    protected int createCommandMarker(String command) {
        int length = command.length();
        int i = 0;
        while (i < length) {
            char c = command.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': {
                    break;
                }
                case '#': {
                    return -i - 1;
                }
                default: {
                    return i;
                }
            }
            ++i;
        }
        return -length - 1;
    }

    public final class Entry {
        private final String command;
        private final long timeStamp;
        private final SubmitType submitTypes;
        private final int isEmpty;
        private volatile Entry older;
        private volatile Entry newer;

        private Entry(Entry older, String command, long stamp, SubmitType submitType) {
            this.command = command;
            this.isEmpty = History.this.createCommandMarker(command);
            this.timeStamp = stamp;
            this.submitTypes = submitType;
            this.older = older;
            if (older != null) {
                older.newer = this;
            }
        }

        public String getCommand() {
            return this.command;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public SubmitType getSubmitType() {
            return this.submitTypes;
        }

        public int getCommandMarker() {
            return this.isEmpty;
        }

        public Entry getNewer() {
            return this.newer;
        }

        public Entry getOlder() {
            return this.older;
        }

        public History getHistory() {
            return History.this;
        }

        private Entry dispose() {
            if (this.newer != null) {
                this.newer.older = null;
            }
            return this.newer;
        }
    }

    private static class HistoryData {
        Entry oldest;
        Entry newest;
        int size;

        private HistoryData() {
        }
    }
}

