/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.emf.ui.forms;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.CommandActionDelegate;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;

public class EditCommandContributionItem
extends SimpleContributionItem {
    private final CommandParameter commandParameter;
    private final EditingDomain editingDomain;
    private final IObservableValue observable;
    private final Object owner;
    private final Command command;

    public EditCommandContributionItem(CommandParameter commandParameter, EditingDomain editingDomain, IObservableValue observable) {
        super("", null);
        this.commandParameter = commandParameter;
        this.editingDomain = editingDomain;
        this.observable = observable;
        this.owner = this.observable.getValue();
        this.command = this.createCommand();
        this.update((CommandActionDelegate)this.command);
    }

    protected Command createCommand() {
        return CreateChildCommand.create((EditingDomain)this.editingDomain, (Object)this.owner, (Object)this.commandParameter, Collections.singletonList(this.owner));
    }

    private void update(CommandActionDelegate delegate) {
        this.setIcon(ExtendedImageRegistry.getInstance().getImageDescriptor(delegate.getImage()));
        this.setText(delegate.getText());
        this.setTooltip(delegate.getToolTipText());
    }

    public boolean isEnabled() {
        return this.editingDomain != null && this.observable.getValue() == this.owner && this.command.canExecute();
    }

    protected void execute() throws ExecutionException {
        if (!this.isEnabled()) {
            return;
        }
        this.editingDomain.getCommandStack().execute(this.command);
        this.executed(this.command.getResult());
    }

    protected void executed(Collection<?> result) {
    }
}

