/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.objectbrowser;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.objectbrowser.ContentInput;
import org.eclipse.statet.internal.r.objectbrowser.ObjectBrowserView;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.rmodel.RLangElement;
import org.eclipse.statet.r.ui.util.RNameSearchPattern;
import org.eclipse.ui.dialogs.SearchPattern;

@NonNullByDefault
class ContentJob
extends Job
implements ToolWorkspace.Listener {
    private final ObjectBrowserView view;
    private volatile boolean isScheduled;
    private boolean forceOnWorkspaceChange;
    private @Nullable RProcess updateSource;
    private @Nullable RProcess lastSource;
    private boolean force;
    private final Set<RProcessREnvironment> updateSet = new HashSet<RProcessREnvironment>();
    private @Nullable List<? extends RProcessREnvironment> rawInput;
    private @Nullable List<? extends CombinedRElement> userspaceInput;

    public ContentJob(ObjectBrowserView view) {
        super("R Object Browser Update");
        this.view = view;
        this.setSystem(true);
        this.setUser(false);
    }

    public void propertyChanged(ToolWorkspace workspace, Map<String, Object> properties) {
        Object autorefresh;
        final RWorkspace rWorkspace = (RWorkspace)workspace;
        if (properties.containsKey("REnvironments")) {
            if (this.forceOnWorkspaceChange) {
                this.forceOnWorkspaceChange = false;
                RProcess process = rWorkspace.getProcess();
                this.forceUpdate(process);
                this.schedule();
            } else {
                List envirs = (List)properties.get("REnvironments");
                this.schedule(rWorkspace.getProcess(), envirs);
            }
        }
        if ((autorefresh = properties.get("AutoRefresh.enabled")) instanceof Boolean) {
            UIAccess.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (rWorkspace.getProcess() != ContentJob.this.view.getTool()) {
                        return;
                    }
                    ContentJob.this.view.updateAutoRefresh((Boolean)autorefresh);
                }
            });
        } else {
            final Object dirty = properties.get("RObjectDB.dirty");
            if (dirty instanceof Boolean) {
                UIAccess.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (rWorkspace.getProcess() != ContentJob.this.view.getTool()) {
                            return;
                        }
                        ContentJob.this.view.updateDirty((Boolean)dirty);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpdate(@Nullable RProcess process) {
        Object object = this.view.sourceLock;
        synchronized (object) {
            if (process != this.view.getTool()) {
                return;
            }
            this.updateSource = process;
            this.force = true;
            this.updateSet.clear();
        }
    }

    public void forceOnWorkspaceChange() {
        this.forceOnWorkspaceChange = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(RProcess process, List<RProcessREnvironment> envirs) {
        if (envirs != null && process != null) {
            Object object = this.view.sourceLock;
            synchronized (object) {
                if (process != this.view.getTool()) {
                    return;
                }
                this.updateSource = process;
                if (!this.force) {
                    this.updateSet.removeAll(envirs);
                    this.updateSet.addAll(envirs);
                }
            }
        }
        this.schedule();
    }

    public boolean shouldSchedule() {
        this.isScheduled = true;
        return true;
    }

    /*
     * Exception decompiling
     */
    protected IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ContentInput createInput(RProcess source) {
        ContentFilter otherFilter;
        ContentFilter envFilter;
        boolean filterInternal = !this.view.getFilterIncludeInternal();
        String filterText = this.view.getFilterSearchText();
        if (filterText != null && filterText.length() > 0) {
            RNameSearchPattern filterPattern = new RNameSearchPattern();
            filterPattern.setPattern(filterText);
            envFilter = new ContentFilter(filterInternal, filterPattern);
            otherFilter = filterInternal ? new ContentFilter(filterInternal, null) : null;
        } else if (filterInternal) {
            envFilter = new ContentFilter(filterInternal, null);
            otherFilter = new ContentFilter(filterInternal, null);
        } else {
            envFilter = null;
            otherFilter = null;
        }
        return new ContentInput(source, this.view.getShowCondensedUserspace(), envFilter, otherFilter);
    }

    private @Nullable List<RProcessREnvironment> updateFromSource(@Nullable ContentInput input, @Nullable List<RProcessREnvironment> updateList) {
        ArrayList<RProcessREnvironment> updateEntries;
        block7: {
            List<? extends RProcessREnvironment> oldInput = this.rawInput;
            this.rawInput = null;
            this.userspaceInput = null;
            if (input == null) {
                return null;
            }
            RProcess process = (RProcess)input.getSource();
            RWorkspace workspaceData = process.getWorkspaceData();
            List rawInput = workspaceData.getRSearchEnvironments();
            if (rawInput == null || rawInput.size() == 0) {
                return null;
            }
            this.rawInput = rawInput;
            input.searchEnvirs = rawInput;
            updateEntries = null;
            if (!input.isFilterUserspace() && oldInput != null && rawInput.size() == oldInput.size() && updateList != null && updateList.size() < rawInput.size()) {
                updateEntries = new ArrayList<RProcessREnvironment>(updateList.size());
                int i = 0;
                while (i < rawInput.size()) {
                    RProcessREnvironment envir = (RProcessREnvironment)rawInput.get(i);
                    if (!envir.equals(oldInput.get(i))) {
                        updateEntries = null;
                        break block7;
                    }
                    if (updateList.remove(envir)) {
                        updateEntries.add(envir);
                    }
                    ++i;
                }
                if (!updateList.isEmpty()) {
                    updateEntries = null;
                }
            }
        }
        return updateEntries;
    }

    private List<? extends CombinedRElement> getUserspaceInput() {
        if (this.userspaceInput == null) {
            List rawInput = (List)ObjectUtils.nonNullAssert(this.rawInput);
            ArrayList<RProcessREnvironment> userEntries = new ArrayList<RProcessREnvironment>(rawInput.size());
            int length = 0;
            for (RProcessREnvironment env : rawInput) {
                if (env.getSpecialType() > 0 && env.getSpecialType() <= 5) continue;
                userEntries.add(env);
                length = (int)((long)length + env.getLength());
            }
            ArrayList elements = new ArrayList(length);
            for (RProcessREnvironment entry : userEntries) {
                elements.addAll(entry.getModelChildren(null));
            }
            Object[] array = elements.toArray(new CombinedRElement[elements.size()]);
            this.userspaceInput = ImCollections.newList((Object[])array, (Comparator)ObjectBrowserView.ELEMENTNAME_COMPARATOR);
        }
        return this.userspaceInput;
    }

    private void prepare(@Nullable ContentInput input) {
        CombinedRElement[] array;
        List<? extends RProcessREnvironment> rawInput = this.rawInput;
        if (input == null || rawInput == null) {
            return;
        }
        if (input.isFilterUserspace()) {
            List<? extends CombinedRElement> list = this.getUserspaceInput();
            if (input.hasEnvFilter()) {
                list = input.filterEnvChildren(list);
            }
            array = list.toArray(new CombinedRElement[list.size()]);
        } else {
            array = rawInput.toArray(new CombinedRElement[rawInput.size()]);
            if (input.hasEnvFilter()) {
                int i = 0;
                while (i < array.length) {
                    input.getEnvChildren(array[i]);
                    ++i;
                }
            }
        }
        input.setRootElements(array);
    }

    private /* synthetic */ void lambda$0(RProcess rProcess, ContentInput contentInput, List list) {
        if (rProcess != this.view.getTool()) {
            return;
        }
        this.view.updateView(contentInput, list);
    }

    static class ContentFilter
    implements LtkModelElementFilter<RLangElement> {
        private final boolean filterInternal;
        private final @Nullable SearchPattern searchPattern;

        public ContentFilter(boolean filterInternal, @Nullable SearchPattern pattern) {
            this.filterInternal = filterInternal;
            this.searchPattern = pattern;
        }

        public boolean include(RLangElement element) {
            String name = element.getElementName().getSegmentName();
            if (name != null) {
                if (this.filterInternal && name.length() > 0 && name.charAt(0) == '.') {
                    return false;
                }
                return this.searchPattern == null || this.searchPattern.matches(name);
            }
            return true;
        }
    }
}

