/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.io;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.statet.jcommons.collections.ByteArrayList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class UriUtils {
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String FILE_SCHEME = "file";
    public static final String JAR_SCHEME = "jar";
    public static final String JAR_SEPARATOR = "!/";
    private static final boolean[] PATH_SEGMENT_IS_ALLOWED;
    private static final boolean[] FRAGMENT_IS_ALLOWED;
    private static final byte PERCENT_CODE = 37;
    private static final byte[] HEX_DIGIT_CODES;

    static {
        HEX_DIGIT_CODES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        char[] alpha = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        char[] digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        char[] subDelim = new char[]{'!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '='};
        char[] unreservedAdd = new char[]{'-', '.', '_', '~'};
        boolean[] pcharAllowed = new boolean[256];
        UriUtils.add(pcharAllowed, alpha);
        UriUtils.add(pcharAllowed, digit);
        UriUtils.add(pcharAllowed, unreservedAdd);
        UriUtils.add(pcharAllowed, subDelim);
        UriUtils.add(pcharAllowed, ':', '@');
        boolean[] isAllowed = (boolean[])pcharAllowed.clone();
        PATH_SEGMENT_IS_ALLOWED = isAllowed;
        isAllowed = (boolean[])pcharAllowed.clone();
        UriUtils.add(isAllowed, '/', '?');
        FRAGMENT_IS_ALLOWED = isAllowed;
    }

    public static final URI toUri(URL url) throws URISyntaxException {
        String s = url.toExternalForm();
        String scheme = url.getProtocol();
        String fragment = url.getRef();
        String spp = s.substring(scheme.length() + 1, fragment != null ? s.length() - fragment.length() - 1 : s.length());
        return new URI(scheme, spp, fragment);
    }

    private static boolean isScheme(@Nullable String scheme, String expectedScheme) {
        int n = expectedScheme.length();
        if (scheme == null || scheme.length() != n) {
            return false;
        }
        int index = 0;
        while (index < n) {
            char cExpected;
            char c = scheme.charAt(index);
            if (c != (cExpected = expectedScheme.charAt(index)) && Character.toLowerCase(c) != cExpected) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static boolean isSchemeUrl(String urlString, String expectedScheme) {
        int n = expectedScheme.length();
        if (urlString.length() <= n || urlString.charAt(n) != ':') {
            return false;
        }
        int index = 0;
        while (index < n) {
            char cExpected;
            char c = urlString.charAt(index);
            if (c != (cExpected = expectedScheme.charAt(index)) && Character.toLowerCase(c) != cExpected) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static final boolean isFileUrl(URI url) {
        return UriUtils.isScheme(url.getScheme(), FILE_SCHEME);
    }

    public static final boolean isFileUrl(String urlString) {
        return UriUtils.isSchemeUrl(urlString, FILE_SCHEME);
    }

    public static final boolean isJarUrl(URI url) {
        return UriUtils.isScheme(url.getScheme(), JAR_SCHEME);
    }

    private static URI assertJarUrlArgument(URI url) {
        if (!UriUtils.isJarUrl(url)) {
            throw new IllegalArgumentException("no JAR url");
        }
        return url;
    }

    public static final boolean isJarUrl(String urlString) {
        return UriUtils.isSchemeUrl(urlString, JAR_SCHEME);
    }

    public static final URI getJarFileUrl(URI url) throws URISyntaxException {
        UriUtils.assertJarUrlArgument(url);
        String ssp = url.getSchemeSpecificPart();
        int containerSchemeIdx = ssp.indexOf(58);
        if (containerSchemeIdx <= 0) {
            throw new URISyntaxException(url.toString(), "missing container scheme");
        }
        int jarSepIdx = ssp.lastIndexOf(JAR_SEPARATOR);
        if (jarSepIdx < containerSchemeIdx) {
            throw new URISyntaxException(url.toString(), "missing JAR separator");
        }
        return ssp.lastIndexOf(JAR_SEPARATOR, jarSepIdx - 1) == -1 ? new URI(ssp.substring(0, containerSchemeIdx), ssp.substring(containerSchemeIdx + 1, jarSepIdx), url.getFragment()) : new URI(url.getScheme(), ssp.substring(0, jarSepIdx), url.getFragment());
    }

    public static final String getJarEntryPath(URI url) throws URISyntaxException {
        UriUtils.assertJarUrlArgument(url);
        String ssp = url.getSchemeSpecificPart();
        int containerSchemeIdx = ssp.indexOf(58);
        if (containerSchemeIdx <= 0) {
            throw new URISyntaxException(url.toString(), "missing container scheme");
        }
        int jarSepIdx = ssp.lastIndexOf(JAR_SEPARATOR);
        if (jarSepIdx < containerSchemeIdx) {
            throw new URISyntaxException(url.toString(), "missing JAR separator");
        }
        return ssp.substring(jarSepIdx + 2);
    }

    public static final URI toJarUrl(String jarFileUrlString) throws URISyntaxException {
        return new URI(UriUtils.toJarUrlString(jarFileUrlString));
    }

    public static final String toJarUrlString(String jarFileUrlString) throws URISyntaxException {
        StringBuilder sb = new StringBuilder(jarFileUrlString.length() + 6);
        if (!UriUtils.isSchemeUrl(jarFileUrlString, JAR_SCHEME)) {
            sb.append("jar:");
        }
        sb.append(jarFileUrlString);
        sb.append(JAR_SEPARATOR);
        return sb.toString();
    }

    private static void add(boolean[] is, char ... chars) {
        int i = 0;
        while (i < chars.length) {
            is[chars[i]] = true;
            ++i;
        }
    }

    private static String encodePercent(String s, boolean[] isAllowed) {
        int idx = 0;
        int n = s.length();
        while (true) {
            if (idx == n) {
                return s;
            }
            char c = s.charAt(idx);
            if (c >= '\u007f' || !isAllowed[c]) break;
            ++idx;
        }
        byte[] rawBytes = s.getBytes(StandardCharsets.UTF_8);
        ByteArrayList latinBytes = new ByteArrayList(rawBytes.length + (3 + rawBytes.length / 10) * 2);
        if (idx > 0) {
            latinBytes.add(rawBytes, 0, idx);
        }
        do {
            byte raw;
            if (isAllowed[(raw = rawBytes[idx++]) & 0xFF]) {
                latinBytes.add(raw);
                continue;
            }
            latinBytes.add((byte)37);
            latinBytes.add(HEX_DIGIT_CODES[(raw & 0xF0) >>> 4]);
            latinBytes.add(HEX_DIGIT_CODES[raw & 0xF]);
        } while (idx < rawBytes.length);
        return latinBytes.getString(StandardCharsets.ISO_8859_1);
    }

    public static String encodePathSegment(String segment) {
        return UriUtils.encodePercent(segment, PATH_SEGMENT_IS_ALLOWED);
    }

    public static String encodeFragment(String fragment) {
        return UriUtils.encodePercent(fragment, FRAGMENT_IS_ALLOWED);
    }

    private UriUtils() {
    }
}

