/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.eclipse.statet.internal.jcommons.collections.AbstractImIntList;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ImIntEmptyList
extends AbstractImIntList {
    public static final ImIntEmptyList INSTANCE = new ImIntEmptyList();

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean contains(int element) {
        return false;
    }

    @Override
    public int getAt(int index) {
        throw new IndexOutOfBoundsException("index= " + index);
    }

    @Override
    public int indexOf(int element) {
        return -1;
    }

    @Override
    public int lastIndexOf(int element) {
        return -1;
    }

    @Override
    public IntStream stream() {
        return StreamSupport.intStream(Spliterators.emptyIntSpliterator(), false);
    }

    @Override
    public int[] toArray() {
        return ArrayUtils.EMPTY_INT;
    }

    @Override
    public String getString() {
        return "";
    }

    public int hashCode() {
        return 9;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntList) {
            IntList other = (IntList)obj;
            return other.isEmpty();
        }
        return false;
    }

    public String toString() {
        return "[]";
    }
}

