/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilterview;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageLine;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.datafilter.VariableFilter;
import org.eclipse.statet.internal.r.ui.datafilterview.VariableComposite;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public abstract class FilterClient<TFilter extends VariableFilter>
extends Composite {
    protected static final String SELECT_ALL_COMMAND_ID = "org.eclipse.ui.edit.selectAll";
    protected static final String REMOVE_COMMAND_ID = "org.eclipse.ui.edit.delete";
    protected static final String REMOVE_ALL_HANDLER_COMMAND_ID = "RemoveAll";
    protected static final String REMOVE_UNCHECKED_HANDLER_ID = "RemoveUnchecked";
    protected final TFilter filter;
    private DataBindingSupport dataBinding = (DataBindingSupport)ObjectUtils.nonNullLateInit();
    private @Nullable Listener resizeListener;
    private @Nullable MessageLine statusInfo;
    private boolean layoutChanged;

    public FilterClient(VariableComposite parent, TFilter filter) {
        super((Composite)parent, 0);
        this.filter = filter;
        ((VariableFilter)filter).setListener(this::onFilterDataChanged);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilterClient.this.onDispose();
            }
        });
    }

    protected void onDispose() {
        Listener listener = this.resizeListener;
        if (listener != null) {
            this.resizeListener = null;
            this.getParent().getContainer().getComposite().removeListener(11, listener);
        }
    }

    public VariableComposite getParent() {
        return (VariableComposite)super.getParent();
    }

    public abstract VariableFilter getFilter();

    protected void init(int numColumns) {
        this.getParent().setClient((Control)this);
        this.setLayout((Layout)LayoutUtils.newCompositeGrid((int)numColumns));
        this.addWidgets();
        LayoutUtils.addSmallFiller((Composite)this, (boolean)false);
        this.initActions(this.getParent().getContainer().getServiceLocator());
        this.initBindings();
        this.onFilterDataChanged();
    }

    protected int getNumColumns() {
        return ((GridLayout)this.getLayout()).numColumns;
    }

    protected void addStatusInfoLine() {
        MessageLine statusInfo = new MessageLine((Composite)this, 0);
        statusInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, this.getNumColumns(), 1));
        this.statusInfo = statusInfo;
        this.updateStatusInfo();
    }

    protected abstract void addWidgets();

    protected abstract void initActions(IServiceLocator var1);

    protected void onFilterDataChanged() {
        if (this.isDisposed()) {
            return;
        }
        this.updateStatusInfo();
        this.updateInput();
        this.dataBinding.getContext().updateTargets();
    }

    protected void updateStatusInfo() {
        MessageLine statusInfo = this.statusInfo;
        if (statusInfo != null) {
            boolean show;
            IStatus status = this.getFilter().getStatus();
            statusInfo.setErrorStatus(status);
            GridData layoutData = (GridData)ObjectUtils.nonNullAssert((Object)((GridData)statusInfo.getLayoutData()));
            boolean bl = show = status != null;
            if (show != statusInfo.isVisible()) {
                statusInfo.setVisible(show);
                layoutData.exclude = !show;
                this.layoutChanged = true;
            }
        }
    }

    protected abstract void updateInput();

    protected void initBindings() {
        this.dataBinding = new DataBindingSupport((Control)this);
        this.addBindings(this.dataBinding);
    }

    protected void addBindings(DataBindingSupport db) {
    }

    protected DataBindingSupport getDataBinding() {
        return this.dataBinding;
    }

    protected void installResizeListener() {
        Listener listener = this.resizeListener;
        if (listener == null) {
            listener = new Listener(){

                public void handleEvent(Event event) {
                    FilterClient.this.checkLayout();
                }
            };
            this.getParent().getContainer().getComposite().addListener(11, listener);
            this.resizeListener = listener;
        }
    }

    protected void checkLayout() {
        if (this.updateLayout() || this.layoutChanged) {
            this.getParent().layout(new Control[]{this});
        }
    }

    protected boolean updateLayout() {
        return false;
    }

    protected boolean updateLayout(TableViewer viewer, int count) {
        GridData data = new GridData(4, 0x1000000, true, false, this.getNumColumns(), 1);
        if (count == 0) {
            data.exclude = true;
        } else {
            data.heightHint = LayoutUtils.hintHeight((Table)viewer.getTable(), (int)count, (boolean)false);
            int max = Math.max(5 * viewer.getTable().getItemHeight(), this.getParent().getContainer().getComposite().getClientArea().height - this.getMinHeightPadding());
            if (data.heightHint > max) {
                data.heightHint = max;
            }
            this.installResizeListener();
        }
        Control control = viewer.getControl();
        GridData oldData = (GridData)control.getLayoutData();
        if (oldData == null || oldData.exclude != data.exclude || oldData.heightHint != data.heightHint) {
            control.setVisible(!data.exclude);
            control.setLayoutData((Object)data);
            return true;
        }
        return false;
    }

    protected int getMinHeightPadding() {
        return 20 + 8 * LayoutUtils.defaultVSpacing();
    }

    public void layout(boolean changed, boolean all) {
        super.layout(changed |= this.updateLayout(), all);
    }

    public void layout(@NonNull Control @Nullable [] changed, int flags) {
        if (this.updateLayout() || this.layoutChanged) {
            this.layoutChanged = false;
            flags |= 2;
        }
        super.layout(changed, flags);
    }
}

