/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.preferences;

import java.util.HashMap;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.ui.dialogs.groups.Layouter;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.debug.ui.launcher.RCodeLaunchRegistry;
import org.eclipse.statet.internal.r.debug.ui.preferences.Messages;
import org.eclipse.statet.ltk.ui.sourceediting.SnippetEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.launching.RRunDebugPreferenceConstants;
import org.eclipse.statet.r.ui.sourceediting.RTemplateSourceViewerConfigurator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.service.prefs.BackingStoreException;

class RInteractionConfigurationBlock
extends ManagedConfigurationBlock {
    private RCodeLaunchRegistry.ConnectorConfig[] connectors;
    private Combo connectorsSelector;
    private Link connectorsDescription;
    private RCodeLaunchRegistry.ContentHandler.FileCommand[] fileCommands;
    private SnippetEditor[] commandEditors;

    RInteractionConfigurationBlock() {
        super(null);
    }

    protected void createBlockArea(Composite pageComposite) {
        this.connectors = RCodeLaunchRegistry.getAvailableConnectors();
        HashMap<Preference.StringPref, Object> prefs = new HashMap<Preference.StringPref, Object>();
        prefs.put(RRunDebugPreferenceConstants.PREF_R_CONNECTOR, null);
        this.setupPreferenceManager(prefs);
        LayoutUtils.addSmallFiller((Composite)pageComposite, (boolean)false);
        Composite group = this.createConnectorComponent(pageComposite);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        LayoutUtils.addSmallFiller((Composite)pageComposite, (boolean)false);
        group = this.createHandlerComponent(pageComposite);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.updateControls();
    }

    private Composite createConnectorComponent(Composite parent) {
        String[] connectorLabels = new String[this.connectors.length];
        int i = 0;
        while (i < this.connectors.length) {
            connectorLabels[i] = this.connectors[i].fName;
            ++i;
        }
        Group group = new Group(parent, 0);
        group.setText(Messages.RInteraction_RConnector);
        Layouter layouter = new Layouter((Composite)group, 2);
        this.connectorsSelector = layouter.addComboControl(connectorLabels, 2);
        layouter.addLabel(Messages.RInteraction_RConnector_Description_label, 0, 1, true);
        ScrolledComposite scrolled = new ScrolledComposite(layouter.composite, 512);
        this.connectorsDescription = this.addLinkControl((Composite)scrolled, "");
        scrolled.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                RInteractionConfigurationBlock.this.updateDescriptionSize();
            }
        });
        GridData gd = new GridData(4, 4, true, false);
        PixelConverter pixelConverter = new PixelConverter((Control)this.connectorsDescription);
        gd.horizontalSpan = 1;
        gd.widthHint = pixelConverter.convertWidthInCharsToPixels(40);
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(5);
        scrolled.setLayoutData((Object)gd);
        scrolled.setContent((Control)this.connectorsDescription);
        this.connectorsSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int idx = RInteractionConfigurationBlock.this.connectorsSelector.getSelectionIndex();
                if (idx >= 0) {
                    RInteractionConfigurationBlock.this.setPrefValue((Preference)RRunDebugPreferenceConstants.PREF_R_CONNECTOR, RInteractionConfigurationBlock.this.connectors[idx].fId);
                    RInteractionConfigurationBlock.this.updateDescription(idx);
                }
            }
        });
        return group;
    }

    private void updateDescription(int idx) {
        String description = this.connectors[idx].fDescription;
        if (description == null) {
            description = "";
        }
        this.connectorsDescription.setText(description);
        this.updateDescriptionSize();
    }

    private void updateDescriptionSize() {
        Composite scroller = this.connectorsDescription.getParent();
        int widthHint = this.connectorsDescription.getParent().getClientArea().width;
        if (!scroller.getVerticalBar().isVisible()) {
            widthHint -= scroller.getVerticalBar().getSize().x;
        }
        this.connectorsDescription.setSize(this.connectorsDescription.computeSize(widthHint, -1));
    }

    private Composite createHandlerComponent(Composite parent) {
        this.fileCommands = RCodeLaunchRegistry.getAvailableFileCommands();
        Group group = new Group(parent, 0);
        group.setText(Messages.RInteraction_FileCommands_label);
        GridLayout layout = LayoutUtils.newGroupGrid((int)2);
        layout.verticalSpacing = 3;
        group.setLayout((Layout)layout);
        this.commandEditors = new SnippetEditor[this.fileCommands.length];
        TemplateVariableProcessor templateVariableProcessor = new TemplateVariableProcessor();
        int i = 0;
        while (i < this.fileCommands.length) {
            Label label = new Label((Composite)group, 0);
            label.setText(String.valueOf(this.fileCommands[i].getLabel()) + ":");
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            RTemplateSourceViewerConfigurator configurator = new RTemplateSourceViewerConfigurator(RCore.WORKBENCH_ACCESS, templateVariableProcessor);
            this.commandEditors[i] = new SnippetEditor((SourceEditorViewerConfigurator)configurator, this.fileCommands[i].getCurrentCommand(), (IServiceLocator)PlatformUI.getWorkbench());
            this.commandEditors[i].create((Composite)group, 33556484);
            GridData gd = new GridData(4, 0x1000000, true, false);
            gd.widthHint = LayoutUtils.hintWidth((StyledText)this.commandEditors[i].getTextControl(), null, (int)25);
            this.commandEditors[i].getControl().setLayoutData((Object)gd);
            ++i;
        }
        return group;
    }

    protected void updateControls() {
        this.loadValues();
        UIAccess.getDisplay((Shell)this.getShell()).asyncExec(new Runnable(){

            @Override
            public void run() {
                int idx = RInteractionConfigurationBlock.this.connectorsSelector.getSelectionIndex();
                if (idx >= 0) {
                    RInteractionConfigurationBlock.this.updateDescription(idx);
                }
            }
        });
    }

    private void loadValues() {
        String selectedConnector = (String)this.getPreferenceValue((Preference)RRunDebugPreferenceConstants.PREF_R_CONNECTOR);
        int i = 0;
        while (i < this.connectors.length) {
            if (selectedConnector.equals(this.connectors[i].fId)) {
                this.connectorsSelector.select(i);
            }
            ++i;
        }
    }

    private void saveHandlerConfig(boolean save) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.statet.r.ui/CodeLaunchContentHandler");
        int i = 0;
        while (i < this.fileCommands.length) {
            if (this.commandEditors[i] != null) {
                String key = String.valueOf(this.fileCommands[i].getId()) + ":command";
                String command = this.commandEditors[i].getDocument().get();
                if (command == null || command.isEmpty() || command.equals(this.fileCommands[i].getDefaultCommand())) {
                    node.remove(key);
                } else {
                    node.put(key, command);
                }
            }
            ++i;
        }
        if (save) {
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                this.logSaveError(e);
            }
        }
    }

    public void performDefaults() {
        int i = 0;
        while (i < this.fileCommands.length) {
            if (this.commandEditors[i] != null) {
                this.commandEditors[i].getDocument().set(this.fileCommands[i].getDefaultCommand());
                this.commandEditors[i].reset();
            }
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk(int flags) {
        this.saveHandlerConfig((flags & 0x10) != 0);
        return super.performOk(flags);
    }
}

