/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.servi.pool;

import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.servi.node.PropertiesBean;

@NonNullByDefault
public class PoolConfig
implements PropertiesBean {
    public static final String BEAN_ID = "poolconfig";
    public static final long MINUTES = 60000L;
    public static final long SECONDS = 1000L;
    public static final String MAX_TOTAL_COUNT_ID = "max_total.count";
    public static final String MIN_IDLE_COUNT_ID = "min_idle.count";
    public static final String MAX_IDLE_COUNT_ID = "max_idle.count";
    public static final String MIN_IDLE_MILLIS_ID = "min_idle.millis";
    @Deprecated
    public static final String MIN_IDLE_TIME_ID = "min_idle.time";
    public static final String MAX_WAIT_MILLIS_ID = "max_wait.millis";
    @Deprecated
    public static final String MAX_WAIT_TIME_ID = "max_wait.time";
    public static final String MAX_USAGE_COUNT_ID = "max_usage.count";
    public static final String EVICT_TIMEOUT_ID = "eviction_timeout.millis";
    private static final Duration EVICT_TIMEOUT_DEFAULT = Duration.ofMinutes(30L);
    private int maxTotalCount = 20;
    private int minIdleCount = 1;
    private int maxIdleCount = 10;
    private Duration autoEvictionMinIdleTime = Duration.ofMinutes(10L);
    private int maxUsageCount = 1000;
    private @Nullable Duration allocationTimeout = Duration.ofSeconds(3L);
    private Duration evictionTimeout = EVICT_TIMEOUT_DEFAULT;

    public static String getPoolName(String id) {
        return id + "-pool";
    }

    public PoolConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolConfig(PoolConfig config) {
        this();
        PoolConfig poolConfig = config;
        synchronized (poolConfig) {
            this.load(config);
        }
    }

    @Override
    public String getBeanId() {
        return BEAN_ID;
    }

    public synchronized void load(PoolConfig templ) {
        this.maxTotalCount = templ.maxTotalCount;
        this.minIdleCount = templ.minIdleCount;
        this.maxIdleCount = templ.maxIdleCount;
        this.autoEvictionMinIdleTime = templ.autoEvictionMinIdleTime;
        this.allocationTimeout = templ.allocationTimeout;
        this.maxUsageCount = templ.maxUsageCount;
        this.evictionTimeout = templ.evictionTimeout;
    }

    @Override
    public synchronized void load(Properties map) {
        this.maxTotalCount = Integer.parseInt(map.getProperty(MAX_TOTAL_COUNT_ID));
        this.minIdleCount = Integer.parseInt(map.getProperty(MIN_IDLE_COUNT_ID));
        this.maxIdleCount = Integer.parseInt(map.getProperty(MAX_IDLE_COUNT_ID));
        this.autoEvictionMinIdleTime = Utils.parseDuration(Utils.getProperty(map, MIN_IDLE_MILLIS_ID, MIN_IDLE_TIME_ID));
        this.allocationTimeout = Utils.parseNullableDuration(Utils.getProperty(map, MAX_WAIT_MILLIS_ID, MAX_WAIT_TIME_ID));
        this.maxUsageCount = Integer.parseInt(map.getProperty(MAX_USAGE_COUNT_ID));
        this.evictionTimeout = Utils.parseDuration(map.getProperty(EVICT_TIMEOUT_ID), EVICT_TIMEOUT_DEFAULT);
    }

    @Override
    public synchronized void save(Properties map) {
        map.setProperty(MAX_TOTAL_COUNT_ID, Integer.toString(this.maxTotalCount));
        map.setProperty(MIN_IDLE_COUNT_ID, Integer.toString(this.minIdleCount));
        map.setProperty(MAX_IDLE_COUNT_ID, Integer.toString(this.maxIdleCount));
        map.setProperty(MIN_IDLE_MILLIS_ID, Utils.serDuration(this.autoEvictionMinIdleTime));
        map.setProperty(MAX_WAIT_MILLIS_ID, Utils.serNullableDuration(this.allocationTimeout));
        map.setProperty(MAX_USAGE_COUNT_ID, Integer.toString(this.maxUsageCount));
        map.setProperty(EVICT_TIMEOUT_ID, Utils.serDuration(this.evictionTimeout));
    }

    public synchronized int getMaxTotalCount() {
        return this.maxTotalCount;
    }

    public synchronized void setMaxTotalCount(int count) {
        this.maxTotalCount = count;
    }

    public synchronized int getMinIdleCount() {
        return this.minIdleCount;
    }

    public synchronized void setMinIdleCount(int count) {
        this.minIdleCount = count;
    }

    public synchronized int getMaxIdleCount() {
        return this.maxIdleCount;
    }

    public synchronized void setMaxIdleCount(int count) {
        this.maxIdleCount = count;
    }

    public synchronized Duration getAutoEvictionMinIdleTime() {
        return this.autoEvictionMinIdleTime;
    }

    public synchronized void setAutoEvictionMinIdleTime(Duration duration) {
        this.autoEvictionMinIdleTime = (Duration)ObjectUtils.nonNullAssert((Object)duration);
    }

    public synchronized int getMaxUsageCount() {
        return this.maxUsageCount;
    }

    public synchronized void setMaxUsageCount(int count) {
        this.maxUsageCount = count;
    }

    public synchronized @Nullable Duration getAllocationTimeout() {
        return this.allocationTimeout;
    }

    public synchronized void setAllocationTimeout(@Nullable Duration timeout) {
        this.allocationTimeout = timeout;
    }

    public synchronized Duration getEvictionTimeout() {
        return this.evictionTimeout;
    }

    public synchronized void setEvictionTimeout(Duration duration) {
        this.evictionTimeout = (Duration)ObjectUtils.nonNullAssert((Object)duration);
    }

    @Override
    public synchronized boolean validate(@Nullable Collection<PropertiesBean.ValidationMessage> messages) {
        boolean valid = true;
        if (this.minIdleCount < 0) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MIN_IDLE_COUNT_ID, "Value must be >= 0"));
            }
            valid = false;
        }
        if (this.maxTotalCount < 1) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MAX_TOTAL_COUNT_ID, "Value must be > 0."));
            }
            valid = false;
        }
        if (this.maxIdleCount < 0) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MAX_IDLE_COUNT_ID, "Value must be >= 0."));
            }
            valid = false;
        }
        if (this.minIdleCount >= 0 && this.maxIdleCount >= 0 && this.maxIdleCount < this.minIdleCount) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MAX_IDLE_COUNT_ID, "Value must be >= {min_idle.count}."));
            }
            valid = false;
        }
        if (this.autoEvictionMinIdleTime.isNegative()) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MIN_IDLE_MILLIS_ID, "Value must be >= 0"));
            }
            valid = false;
        }
        if (this.maxUsageCount != -1 && Utils.isNegative(this.allocationTimeout)) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MAX_WAIT_MILLIS_ID, "Value must be >= 0 or unset/== -1 (infinite)"));
            }
            valid = false;
        }
        if (this.maxUsageCount < 1 && this.maxUsageCount != -1) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(MAX_USAGE_COUNT_ID, "Value must be > 0 or == -1 (disable)"));
            }
            valid = false;
        }
        if (this.evictionTimeout.isNegative()) {
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(EVICT_TIMEOUT_ID, "Value must be >= 0"));
            }
            valid = false;
        }
        return valid;
    }
}

