/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.launching;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.variables.core.DynamicVariable;
import org.eclipse.statet.ecommons.variables.core.StringVariable;
import org.eclipse.statet.ecommons.variables.core.VariableText;
import org.eclipse.statet.internal.r.debug.ui.RControllerCodeLaunchConnector;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.debug.ui.launcher.RCodeLaunchRegistry;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.util.StringUtils;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.core.rmodel.RLangSourceElement;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.rmodel.RWorkspaceSourceUnit;
import org.eclipse.statet.r.core.source.ast.GenericVisitor;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.launching.ICodeSubmitContentHandler;
import org.eclipse.statet.r.launching.IRCodeSubmitConnector;
import org.eclipse.statet.r.launching.SubmitEntireCommandRunnable;
import org.eclipse.statet.r.launching.SubmitFileViaCommandRunnable;
import org.eclipse.statet.r.nico.IRModelSrcref;
import org.eclipse.statet.r.nico.IRSrcref;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public final class RCodeLaunching {
    public static final String SUBMIT_SELECTION_COMMAND_ID = "org.eclipse.statet.r.commands.SubmitSelectionToR";
    public static final String SUBMIT_SELECTION_GOTOCONSOLE_COMMAND_ID = "org.eclipse.statet.r.commands.SubmitSelectionToR_GotoConsole";
    public static final String SUBMIT_SELECTION_PASTEOUTPUT_COMMAND_ID = "org.eclipse.statet.r.commands.SubmitSelectionToR_PasteOutput";
    public static final String SUBMIT_UPTO_SELECTION_COMMAND_ID = "org.eclipse.statet.r.commands.SubmitUptoSelectionToR";
    public static final String SUBMIT_FILEVIACOMMAND_COMMAND_ID = "org.eclipse.statet.r.commands.SubmitFileToRViaCommand";
    public static final String SUBMIT_FILEVIACOMMAND_GOTOCONSOLE_COMMAND_ID = "org.eclipse.statet.r.commands.SubmitFileToRViaCommand_GotoConsole";
    public static final String FILE_COMMAND_ID_PARAMTER_ID = "fileCommandId";
    private static final IStringVariable FILE_NAME_VARIABLE = new StringVariable("resource_loc", "The complete path of the source file");
    private static final IStringVariable FILE_ENCODING_VARIABLE = new StringVariable("resource_encoding", "The encoding of the source file");
    private static final IStringVariable ECHO_ENABLED_VARIABLE = new StringVariable("echo", "If echo is enabled");
    private static final IStatus STATUS_PROMPTER = new org.eclipse.core.runtime.Status(1, "org.eclipse.debug.ui", 200, "", null);
    private static final IStatus STATUS_SAVE = new org.eclipse.core.runtime.Status(1, DebugPlugin.getUniqueIdentifier(), 222, "", null);
    public static final Preference.BooleanPref ECHO_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.statet.r.ui/codelaunch", "echo.enabled");

    public static void gotoRConsole() throws CoreException {
        IRCodeSubmitConnector connector = RCodeLaunchRegistry.getDefault().getConnector();
        connector.gotoConsole();
    }

    public static String getFileCommand(String id) {
        RCodeLaunchRegistry.ContentHandler.FileCommand fileCommand = RCodeLaunchRegistry.getDefault().getFileCommand(id);
        if (fileCommand != null) {
            return fileCommand.getCurrentCommand();
        }
        return null;
    }

    public static String getPreferredFileCommand(String contentType) {
        RCodeLaunchRegistry.ContentHandler.FileCommand fileCommand = RCodeLaunchRegistry.getDefault().getContentFileCommand(contentType);
        return fileCommand.getCurrentCommand();
    }

    public static ICodeSubmitContentHandler getCodeSubmitContentHandler(String contentType) {
        return RCodeLaunchRegistry.getDefault().getContentHandler(contentType);
    }

    public static void runFileUsingCommand(final String command, URI fileURI, final SourceUnit su, final String encoding, boolean gotoConsole) throws CoreException {
        IFile file;
        IProject project;
        if (su instanceof WorkspaceSourceUnit && su.getResource() instanceof IFile && (project = (file = (IFile)((WorkspaceSourceUnit)su).getResource()).getProject()) != null) {
            IProject[] referencedProjects = project.getReferencedProjects();
            IProject[] allProjects = new IProject[referencedProjects.length + 1];
            allProjects[0] = project;
            System.arraycopy(referencedProjects, 0, allProjects, 1, referencedProjects.length);
            if (!RCodeLaunching.saveBeforeLaunch(allProjects)) {
                return;
            }
        }
        IRCodeSubmitConnector connector = RCodeLaunchRegistry.getDefault().getConnector();
        IFileStore fileStore = null;
        try {
            fileStore = EFS.getStore((URI)fileURI);
        }
        catch (CoreException e) {
            fileStore = null;
        }
        if (fileStore != null && connector instanceof RControllerCodeLaunchConnector) {
            final IFileStore store = fileStore;
            ((RControllerCodeLaunchConnector)connector).submit(new RControllerCodeLaunchConnector.CommandsCreator(){

                @Override
                public Status submitTo(ToolController controller) {
                    ToolWorkspace workspace = controller.getWorkspaceData();
                    try {
                        String path = workspace.toToolPath(store);
                        String code = RCodeLaunching.resolveVariables(command, path, encoding);
                        SubmitFileViaCommandRunnable runnable = new SubmitFileViaCommandRunnable(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"), "Run '" + store.toString() + "'", code, su);
                        Status status = controller.getTool().getQueue().add((ToolRunnable)runnable);
                        if (status.getSeverity() != 0) {
                            runnable.changed(290, null);
                        }
                        return status;
                    }
                    catch (StatusException e) {
                        return e.getStatus();
                    }
                    catch (CoreException e) {
                        return EStatusUtils.convert((IStatus)e.getStatus());
                    }
                }
            }, gotoConsole);
        } else {
            String path = null;
            try {
                if (EFS.getLocalFileSystem().equals(EFS.getFileSystem((String)fileURI.getScheme()))) {
                    path = EFS.getLocalFileSystem().getStore(fileURI).toString();
                }
            }
            catch (CoreException allProjects) {
                // empty catch block
            }
            if (path == null) {
                path = fileURI.toString();
            }
            String code = RCodeLaunching.resolveVariables(command, path, encoding);
            connector.submit(Collections.singletonList(code), gotoConsole);
        }
    }

    private static String resolveVariables(String command, final String path, final String encoding) throws CoreException {
        ArrayList<DynamicVariable> variables = new ArrayList<DynamicVariable>();
        variables.add(new DynamicVariable(FILE_NAME_VARIABLE){

            public String getValue(String argument) throws CoreException {
                return RUtil.escapeCompletely((String)path);
            }
        });
        variables.add(new DynamicVariable(FILE_ENCODING_VARIABLE){

            public String getValue(String argument) throws CoreException {
                return encoding != null ? RUtil.escapeCompletely((String)encoding) : "unknown";
            }
        });
        variables.add(new DynamicVariable(ECHO_ENABLED_VARIABLE){

            public String getValue(String argument) throws CoreException {
                Boolean echo = (Boolean)EPreferences.getInstancePrefs().getPreferenceValue((Preference)ECHO_ENABLED_PREF);
                return echo != null && echo != false ? "TRUE" : "FALSE";
            }
        });
        VariableText text = new VariableText(command, variables, true);
        text.performFinalStringSubstitution(new VariableText.LocationProcessor(){

            public String process(String path) throws CoreException {
                return RUtil.escapeCompletely((String)path);
            }
        });
        return text.getText();
    }

    private static boolean saveBeforeLaunch(IProject[] projects) throws CoreException {
        IStatusHandler prompter = null;
        prompter = DebugPlugin.getDefault().getStatusHandler(STATUS_PROMPTER);
        if (prompter != null) {
            Object[] objectArray = new Object[2];
            objectArray[1] = projects;
            return (Boolean)prompter.handleStatus(STATUS_SAVE, (Object)objectArray);
        }
        return true;
    }

    public static boolean runRCodeDirect(List<String> lines, boolean gotoConsole, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.subTask(RLaunchingMessages.RCodeLaunch_SubmitCode_task);
        }
        IRCodeSubmitConnector connector = RCodeLaunchRegistry.getDefault().getConnector();
        return connector.submit(lines, gotoConsole);
    }

    public static boolean runRCodeDirect(final List<SourceRegion> codeRegions, boolean gotoConsole) throws CoreException {
        IRCodeSubmitConnector connector = RCodeLaunchRegistry.getDefault().getConnector();
        if (connector instanceof RControllerCodeLaunchConnector) {
            return ((RControllerCodeLaunchConnector)connector).submit(new RControllerCodeLaunchConnector.CommandsCreator(){

                @Override
                public Status submitTo(ToolController controller) {
                    Object[] runnables = new ToolRunnable[codeRegions.size()];
                    ArrayList lines = new ArrayList();
                    int i = 0;
                    while (i < runnables.length) {
                        SourceRegion region = (SourceRegion)codeRegions.get(i);
                        lines.clear();
                        StringUtils.collectLines((String)region.fCode, lines);
                        runnables[i] = new SubmitEntireCommandRunnable(lines.toArray(new String[lines.size()]), (IRSrcref)region);
                        ++i;
                    }
                    Status status = controller.getTool().getQueue().add((List)ImCollections.newList((Object[])runnables));
                    if (status.getSeverity() != 0) {
                        int i2 = 0;
                        while (i2 < runnables.length) {
                            runnables[i2].changed(290, null);
                            ++i2;
                        }
                    }
                    return status;
                }
            }, gotoConsole);
        }
        ArrayList<String> lines = new ArrayList<String>(codeRegions.size() * 2);
        int i = 0;
        while (i < codeRegions.size()) {
            StringUtils.collectLines((String)codeRegions.get((int)i).fCode, lines);
            ++i;
        }
        return RCodeLaunching.runRCodeDirect(lines, gotoConsole, null);
    }

    public static class SourceRegion
    implements IRModelSrcref,
    IAdaptable {
        private static final String MARKER_TYPE = "org.eclipse.core.resources.marker";
        private final RSourceUnit fSourceUnit;
        private RAstNode fNode;
        private List<RLangSourceElement> fElements;
        private final AbstractDocument fDocument;
        private int fBeginOffset = -1;
        private int fBeginLine = -1;
        private int fBeginColumn = -1;
        private int fEndOffset = -1;
        private int fEndLine = -1;
        private int fEndColumn = -1;
        private String fCode;
        private IMarker fMarker;

        public SourceRegion(RSourceUnit file, AbstractDocument document) {
            this.fSourceUnit = file;
            this.fDocument = document;
        }

        public RSourceUnit getFile() {
            return this.fSourceUnit;
        }

        public void setNode(RAstNode node) {
            this.fNode = node;
        }

        public List<RLangSourceElement> getElements() {
            if (this.fElements == null) {
                if (this.fNode != null) {
                    ElementSearcher searcher = new ElementSearcher();
                    try {
                        searcher.visitNode(this.fNode);
                        this.fElements = searcher.fList;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
                if (this.fElements == null) {
                    this.fElements = Collections.emptyList();
                }
            }
            return this.fElements;
        }

        public void setCode(String code) {
            this.fCode = code;
        }

        public void setBegin(int offset) throws BadLocationException {
            this.fBeginOffset = offset;
            this.fBeginLine = this.fDocument.getLineOfOffset(this.fBeginOffset);
            this.fBeginColumn = TextUtil.getColumn((IDocument)this.fDocument, (int)this.fBeginOffset, (int)this.fBeginLine, (int)8);
        }

        public boolean hasBeginDetail() {
            return this.fBeginLine >= 0 && this.fBeginColumn >= 0;
        }

        public int getOffset() {
            return this.fBeginOffset;
        }

        public int getFirstLine() {
            return this.fBeginLine;
        }

        public int getFirstColumn() {
            return this.fBeginColumn;
        }

        public void setEnd(int offset) throws BadLocationException {
            this.fEndOffset = offset;
            this.fEndLine = this.fDocument.getLineOfOffset(this.fEndOffset);
            this.fEndColumn = TextUtil.getColumn((IDocument)this.fDocument, (int)(this.fEndOffset - 1), (int)this.fEndLine, (int)8);
        }

        public boolean hasEndDetail() {
            return this.fEndLine >= 0 && this.fEndColumn >= 0;
        }

        public int getLength() {
            return this.fEndOffset - this.fBeginOffset;
        }

        public int getLastLine() {
            return this.fEndLine;
        }

        public int getLastColumn() {
            return this.fEndColumn;
        }

        void installMarker() {
            if (this.fSourceUnit instanceof RWorkspaceSourceUnit) {
                IResource resource = ((RWorkspaceSourceUnit)this.fSourceUnit).getResource();
                try {
                    this.fMarker = resource.createMarker(MARKER_TYPE, Map.of("charStart", this.fBeginOffset, "charEnd", this.fEndOffset));
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.ui", 0, "An error occurred when creating code position marker.", (Throwable)e));
                }
            }
        }

        void disposeMarker() {
            if (this.fMarker != null) {
                try {
                    this.fMarker.delete();
                    this.fMarker = null;
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle((IStatus)new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.ui", 0, "An error occurred when removing code position marker.", (Throwable)e));
                }
            }
        }

        public <T> T getAdapter(Class<T> adapterType) {
            if (adapterType == IMarker.class) {
                return (T)this.fMarker;
            }
            return null;
        }

        private static class ElementSearcher
        extends GenericVisitor {
            private List<RLangSourceElement> fList;

            private ElementSearcher() {
            }

            public void visitNode(RAstNode node) throws InvocationTargetException {
                ImList attachments = node.getAttachments();
                for (Object attachment : attachments) {
                    if (!(attachment instanceof RLangSourceElement)) continue;
                    if (this.fList == null) {
                        this.fList = new ArrayList<RLangSourceElement>();
                    }
                    this.fList.add((RLangSourceElement)attachment);
                }
                if (this.fList == null) {
                    super.visitNode(node);
                }
            }
        }
    }
}

