/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pager;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.statet.ecommons.text.core.util.ImmutableDocument;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.pager.RPagerEditorInput;
import org.eclipse.statet.internal.r.ui.pager.TextFileEditorPage;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.core.input.BasicSourceFragment;
import org.eclipse.statet.ltk.core.input.SourceFragment;
import org.eclipse.statet.ltk.ui.input.BasicSourceFragmentEditorInput;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

@NonNullByDefault
public class RPagerEditor
extends MultiPageEditorPart {
    protected Image getDefaultImage() {
        return RUI.getImage("org.eclipse.statet.r.ui/image/view/pager");
    }

    protected void setInputWithNotify(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
        if (this.getContainer() != null) {
            this.updatePages();
        }
        this.firePropertyChange(258);
    }

    protected void setInput(IEditorInput input) {
        this.setInputWithNotify(input);
    }

    protected void updatePages() {
        int pageCount;
        while ((pageCount = this.getPageCount()) != 0) {
            this.removePage(pageCount - 1);
        }
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof RPagerEditorInput) {
            RPagerEditorInput pagerInput = (RPagerEditorInput)editorInput;
            ImList<RPagerEditorInput.TextFile> files = pagerInput.getFiles();
            int id = 0;
            for (RPagerEditorInput.TextFile textFile : files) {
                try {
                    BasicSourceFragment sourceFragment = new BasicSourceFragment("RPagerFile#" + id++, textFile.getName(), textFile.getName(), (AbstractDocument)new ImmutableDocument(textFile.getContent(), 0L));
                    TextFileEditorPage page = new TextFileEditorPage();
                    this.addPage((IEditorPart)page, (IEditorInput)new BasicSourceFragmentEditorInput((SourceFragment)sourceFragment));
                }
                catch (Exception e) {
                    RUIPlugin.logError(String.format("An error occurred when creating R Pager editor page for '%1$s'.", textFile.getName()), e);
                }
            }
        }
    }

    protected void createPages() {
        this.updatePages();
    }

    public void addPage(int index, IEditorPart editor, IEditorInput input) throws PartInitException {
        super.addPage(index, editor, input);
        this.setPageText(index, input.getName());
    }

    public boolean isSaveAsAllowed() {
        IEditorPart editor;
        int pageIndex = this.getActivePage();
        return pageIndex >= 0 && (editor = this.getEditor(pageIndex)) != null;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
        IEditorPart editor;
        int pageIndex = this.getActivePage();
        if (pageIndex >= 0 && (editor = this.getEditor(pageIndex)) != null) {
            editor.doSaveAs();
            return;
        }
    }
}

