/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.layer;

import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.statet.ecommons.waltable.layer.AbstractLayer;
import org.eclipse.statet.ecommons.waltable.layer.DataDim;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.LayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.painter.layer.CellLayerPainter;
import org.eclipse.statet.ecommons.waltable.painter.layer.ILayerPainter;

public class PlaceholderLayer
extends DimensionallyDependentLayer {
    public PlaceholderLayer(ILayer horizontalLayerDependency, ILayer verticalLayerDependency) {
        this(horizontalLayerDependency, verticalLayerDependency, true, new CellLayerPainter());
    }

    public PlaceholderLayer(ILayer horizontalLayerDependency, ILayer verticalLayerDependency, boolean useDefaultConfiguration, ILayerPainter layerPainter) {
        super(new DummyLayer());
        this.setHorizontalLayerDependency(horizontalLayerDependency != null ? horizontalLayerDependency : this.getBaseLayer());
        this.setVerticalLayerDependency(verticalLayerDependency != null ? verticalLayerDependency : this.getBaseLayer());
        this.layerPainter = layerPainter;
    }

    public void setSize(int size) {
        ((DummyLayer)this.getBaseLayer()).size = size;
    }

    @Override
    public ILayerCell getCellByPosition(long columnPosition, long rowPosition) {
        ILayerDim hDim = this.getDim(Orientation.HORIZONTAL);
        ILayerDim vDim = this.getDim(Orientation.VERTICAL);
        long columnId = hDim.getPositionId(columnPosition, columnPosition);
        long rowId = vDim.getPositionId(rowPosition, rowPosition);
        return new LayerCell(this, new LayerCellDim(Orientation.HORIZONTAL, columnId, columnPosition, 0L, hDim.getPositionCount()), new LayerCellDim(Orientation.VERTICAL, rowId, rowPosition, 0L, vDim.getPositionCount()));
    }

    private static class DummyLayer
    extends AbstractLayer
    implements ILayer {
        private static long idCounter;
        private int size = 20;

        @Override
        protected void initDims() {
            long id = 0x100000000000000L + idCounter++;
            Orientation[] orientationArray = Orientation.values();
            int n = orientationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Orientation orientation = orientationArray[n2];
                this.setDim(new Dim(this, orientation, id));
                ++n2;
            }
        }

        @Override
        public ILayer getUnderlyingLayerByPosition(long columnPosition, long rowPosition) {
            return null;
        }

        @Override
        public ILayerCell getCellByPosition(long columnPosition, long rowPosition) {
            throw new UnsupportedOperationException();
        }

        private static class Dim
        extends DataDim<DummyLayer> {
            public Dim(DummyLayer layer, Orientation orientation, long catId) {
                super(layer, orientation, catId);
            }

            @Override
            public long getPositionCount() {
                return 1L;
            }

            @Override
            public long getSize() {
                return ((DummyLayer)this.layer).size;
            }

            @Override
            public long getPositionByPixel(long pixel) {
                return 0L;
            }

            @Override
            public long getPositionStart(long position) {
                if (position != 0L) {
                    throw PositionOutOfBoundsException.position(position, this.getOrientation());
                }
                return 0L;
            }

            @Override
            public int getPositionSize(long position) {
                if (position != 0L) {
                    throw PositionOutOfBoundsException.position(position, this.getOrientation());
                }
                return ((DummyLayer)this.layer).size;
            }

            @Override
            public boolean isPositionResizable(long position) {
                return false;
            }
        }
    }
}

