/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ToStringHelper;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class TextSegment {
    private final ImList<Line> lines;
    private final String text;

    private static String computeText(List<Line> lines) {
        StringBuilder text = new StringBuilder(lines.size() * 32);
        Iterator<Line> iter = lines.iterator();
        if (iter.hasNext()) {
            Line line = iter.next();
            while (iter.hasNext()) {
                text.append(line.getTextContent(false));
                text.append('\n');
                line = iter.next();
            }
            text.append(line.getTextContent(true));
        }
        return text.toString();
    }

    public TextSegment(ImList<Line> lines) {
        this.lines = lines;
        this.text = TextSegment.computeText(this.lines);
    }

    public TextSegment(LineSequence lines) {
        Line line;
        ArrayList<Line> list = new ArrayList<Line>();
        while ((line = lines.getCurrentLine()) != null) {
            list.add(line);
            lines.advance();
        }
        this.lines = ImCollections.toList(list);
        this.text = TextSegment.computeText(this.lines);
    }

    public String getText() {
        return this.text;
    }

    public ImList<Line> getLines() {
        return this.lines;
    }

    public int toOffset(int textOffset) {
        if (textOffset < 0) {
            throw new IllegalArgumentException();
        }
        int contentOffsetOfLine = 0;
        int remainder = textOffset;
        for (Line line : this.lines) {
            contentOffsetOfLine = line.getTextContentOffset();
            int lineContentPlusSeparatorLength = line.getTextContentLength() + 1;
            if (lineContentPlusSeparatorLength > remainder) break;
            remainder -= lineContentPlusSeparatorLength;
        }
        return contentOffsetOfLine + remainder;
    }

    public int toTextOffset(int documentOffset) {
        int textOffset = 0;
        for (Line line : this.lines) {
            int lineRelativeOffset = documentOffset - line.getTextContentOffset();
            int lineContentPlusSeparatorLength = line.getTextContentLength() + 1;
            if (lineRelativeOffset >= 0 && lineRelativeOffset < lineContentPlusSeparatorLength) {
                return textOffset + lineRelativeOffset;
            }
            textOffset += lineContentPlusSeparatorLength;
        }
        throw new IllegalArgumentException();
    }

    public Line getLineAtOffset(int textOffset) {
        int documentOffset = this.toOffset(textOffset);
        Line previous = null;
        for (Line line : this.lines) {
            if (line.getStartOffset() > documentOffset) break;
            previous = line;
        }
        return (Line)ObjectUtils.nonNullAssert(previous);
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(TextSegment.class, this.getClass());
        sb.addProp("text", ToStringHelper.toStringValue(this.text));
        return sb.build();
    }
}

