/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.core.model;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstInfo;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSourceUnitModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceUnit;
import org.eclipse.statet.docmlet.wikitext.core.model.build.EmbeddingReconcileTask;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitModelContainer;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitModelContainerEmbeddedExtension;
import org.eclipse.statet.internal.redocs.wikitext.r.RedocsWikitextRPlugin;
import org.eclipse.statet.internal.redocs.wikitext.r.core.model.WikidocRChunkReconciler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.build.SourceUnitModelContainer;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.redocs.wikitext.r.core.model.WikidocRweaveSourceUnit;
import org.eclipse.statet.redocs.wikitext.r.core.source.RweaveMarkupLanguage;

@NonNullByDefault
public class WikidocRweaveSuModelContainer
extends WikidocSourceUnitModelContainer<WikidocRweaveSourceUnit>
implements WikidocSourceUnitModelContainerEmbeddedExtension {
    public WikidocRweaveSuModelContainer(WikidocRweaveSourceUnit su) {
        super((WikitextSourceUnit)su);
    }

    public boolean isContainerFor(String modelTypeId) {
        return modelTypeId == "Wikidoc" || modelTypeId == "WikidocRweave";
    }

    public String getNowebType() {
        return "R";
    }

    public void reconcileEmbeddedAst(SourceContent content, List<Embedded> list, WikitextMarkupLanguage markupLanguage, int level, IProgressMonitor monitor) {
        if (markupLanguage instanceof RweaveMarkupLanguage) {
            WikidocRChunkReconciler.getInstance((RweaveMarkupLanguage)markupLanguage).reconcileAst((SourceUnitModelContainer)this, content, list, monitor);
        }
    }

    public void reconcileEmbeddedModel(SourceContent content, WikidocSourceUnitModelInfo wikitextModel, List<EmbeddingReconcileTask> list, int level, IProgressMonitor monitor) {
        WikitextAstInfo astInfo = wikitextModel.getAst();
        WikitextMarkupLanguage markupLanguage = astInfo.getMarkupLanguage();
        if (markupLanguage instanceof RweaveMarkupLanguage) {
            WikidocRChunkReconciler.getInstance((RweaveMarkupLanguage)markupLanguage).reconcileModel((SourceUnitModelContainer)this, content, (SourceUnitModelInfo)wikitextModel, list, level, monitor);
        }
    }

    public void reportEmbeddedProblems(SourceContent content, WikidocSourceUnitModelInfo wikitextModel, ProblemRequestor problemRequestor, int level, IProgressMonitor monitor) {
        WikitextAstInfo astInfo = wikitextModel.getAst();
        WikitextMarkupLanguage markupLanguage = astInfo.getMarkupLanguage();
        if (markupLanguage instanceof RweaveMarkupLanguage) {
            WikidocRChunkReconciler.getInstance((RweaveMarkupLanguage)markupLanguage).reportEmbeddedProblems((SourceUnitModelContainer)this, content, (SourceUnitModelInfo)wikitextModel, problemRequestor, level, monitor);
        }
    }

    public @Nullable ProblemRequestor createProblemRequestor() {
        if (this.getMode() == Ltk.EDITOR_CONTEXT) {
            return RedocsWikitextRPlugin.getInstance().getDocRDocumentProvider().createProblemRequestor(this.getSourceUnit());
        }
        return null;
    }
}

