/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.refactoring.Messages;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringDescriptor;
import org.eclipse.statet.ltk.refactoring.core.RefactoringChange;
import org.eclipse.statet.ltk.refactoring.core.RefactoringMessages;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;
import org.eclipse.statet.ltk.refactoring.core.TextChangeCompatibility;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RFrame;
import org.eclipse.statet.r.core.model.RSourceFrame;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.rsource.ast.Assignment;
import org.eclipse.statet.r.core.rsource.ast.Block;
import org.eclipse.statet.r.core.rsource.ast.FDef;
import org.eclipse.statet.r.core.rsource.ast.GenericVisitor;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAsts;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ExtractFunctionRefactoring
extends Refactoring {
    private final RRefactoringAdapter adapter = new RRefactoringAdapter();
    private final ElementSet elementSet;
    private TextRegion selectionRegion;
    private TextRegion operationRegion;
    private final RSourceUnit sourceUnit;
    private RAstNode[] expressions;
    private Map<String, Variable> variablesMap;
    private List<Variable> variablesList;
    private String functionName;

    public ExtractFunctionRefactoring(RSourceUnit su, TextRegion selection) {
        this.sourceUnit = su;
        this.elementSet = new ElementSet(new Object[]{su});
        if (selection != null && selection.getStartOffset() >= 0 && selection.getLength() >= 0) {
            this.selectionRegion = selection;
        }
    }

    public String getName() {
        return Messages.ExtractFunction_label;
    }

    public String getIdentifier() {
        return "org.eclipse.statet.r.refactoring.ExtractFunctionOperation";
    }

    public void setFunctionName(String newName) {
        this.functionName = newName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<Variable> getVariables() {
        return this.variablesList;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        try {
            if (this.selectionRegion != null) {
                this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
                try {
                    TextRegion region;
                    AbstractDocument document = this.sourceUnit.getDocument(monitor);
                    RHeuristicTokenScanner scanner = this.adapter.getScanner(this.sourceUnit);
                    RSourceUnitModelInfo modelInfo = (RSourceUnitModelInfo)this.sourceUnit.getModelInfo("R", 2, (IProgressMonitor)m.newChild(1));
                    if (modelInfo != null) {
                        AstSelection astSelection;
                        AstNode covering;
                        region = this.adapter.trimToAstRegion(document, this.selectionRegion, scanner);
                        AstInfo ast = modelInfo.getAst();
                        if (ast != null && (covering = (astSelection = AstSelection.search((AstNode)ast.getRoot(), (int)region.getStartOffset(), (int)region.getEndOffset(), (int)3)).getCovering()) instanceof RAstNode) {
                            RAstNode rCovering = (RAstNode)covering;
                            if (rCovering.getStartOffset() == region.getStartOffset() && rCovering.getLength() == region.getLength() || rCovering.getNodeType() != NodeType.SOURCELINES && rCovering.getNodeType() != NodeType.BLOCK) {
                                this.expressions = new RAstNode[]{rCovering};
                            } else {
                                RAstNode child;
                                int count = rCovering.getChildCount();
                                ArrayList<RAstNode> childList = new ArrayList<RAstNode>(count);
                                int i = 0;
                                while (i < count) {
                                    child = rCovering.getChild(i);
                                    if (child == astSelection.getChildFirstTouching()) break;
                                    ++i;
                                }
                                while (i < count) {
                                    child = rCovering.getChild(i);
                                    childList.add(child);
                                    if (child == astSelection.getChildLastTouching()) break;
                                    ++i;
                                }
                                if (!childList.isEmpty()) {
                                    this.expressions = childList.toArray(new RAstNode[childList.size()]);
                                }
                            }
                        }
                    }
                    if (this.expressions != null) {
                        region = new BasicTextRegion(this.expressions[0].getStartOffset(), this.expressions[this.expressions.length - 1].getEndOffset());
                        this.operationRegion = this.adapter.expandSelectionRegion(document, region, this.selectionRegion, scanner);
                    }
                }
                finally {
                    this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
                }
            }
            if (this.expressions == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractFunction_error_InvalidSelection_message);
                return refactoringStatus;
            }
            RefactoringStatus result = new RefactoringStatus();
            this.adapter.checkInitialToModify(result, this.elementSet);
            m.worked(1);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.checkExpressions(result);
            m.worked(2);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    private void checkExpressions(RefactoringStatus result) {
        RAstNode[] rAstNodeArray = this.expressions;
        int n = this.expressions.length;
        int n2 = 0;
        while (n2 < n) {
            RAstNode node = rAstNodeArray[n2];
            if (RAsts.hasErrors(node)) {
                result.merge(RefactoringStatus.createWarningStatus((String)Messages.ExtractFunction_warning_SelectionSyntaxError_message));
                break;
            }
            ++n2;
        }
        if (this.selectionRegion != null && (this.selectionRegion.getStartOffset() != this.operationRegion.getStartOffset() || this.selectionRegion.getLength() != this.operationRegion.getLength())) {
            result.merge(RefactoringStatus.createWarningStatus((String)Messages.ExtractFunction_warning_ChangedRange_message));
        }
        this.variablesMap = new HashMap<String, Variable>();
        VariableSearcher searcher = new VariableSearcher();
        try {
            RAstNode[] rAstNodeArray2 = this.expressions;
            int n3 = this.expressions.length;
            n = 0;
            while (n < n3) {
                RAstNode node = rAstNodeArray2[n];
                node.acceptInR(searcher);
                ++n;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        this.variablesList = new ArrayList<Variable>(this.variablesMap.values());
        Collections.sort(this.variablesList, new Comparator<Variable>(){

            @Override
            public int compare(Variable o1, Variable o2) {
                return RElementAccess.NAME_POSITION_COMPARATOR.compare(o1.firstAccess, o2.firstAccess);
            }
        });
        this.functionName = "";
    }

    public RefactoringStatus checkFunctionName(String name) {
        String message = this.adapter.validateIdentifier(name, "The function name");
        if (message != null) {
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_FinalCheck_label, (int)3);
        try {
            RefactoringStatus status = this.checkFunctionName(this.functionName);
            this.adapter.checkFinalToModify(status, this.elementSet, (IProgressMonitor)m.newChild(2));
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_CreateChanges_label, (int)3);
        try {
            SourceUnitChange textFileChange = new SourceUnitChange((SourceUnit)this.sourceUnit);
            if (this.sourceUnit.getWorkingContext() == Ltk.EDITOR_CONTEXT) {
                textFileChange.setSaveMode(4);
            }
            this.createChanges((TextFileChange)textFileChange, m.newChild(2));
            HashMap arguments = new HashMap();
            String varName = RRefactoringAdapter.getUnquotedIdentifier(this.functionName);
            String description = NLS.bind((String)Messages.ExtractFunction_Descriptor_description, (Object)RUtil.formatVarName(varName));
            IProject resource = this.elementSet.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? NLS.bind((String)RefactoringMessages.Common_Source_Project_label, (Object)project) : RefactoringMessages.Common_Source_Workspace_label;
            boolean flags = false;
            String comment = "";
            CommonRefactoringDescriptor descriptor = new CommonRefactoringDescriptor(this.getIdentifier(), project, description, "", arguments, 0);
            m.worked(1);
            RefactoringChange refactoringChange = new RefactoringChange((RefactoringDescriptor)descriptor, Messages.ExtractFunction_label, new Change[]{textFileChange});
            return refactoringChange;
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", "Unexpected error (concurrent change?)", (Throwable)e));
        }
        finally {
            m.done();
        }
    }

    private void createChanges(TextFileChange change, SubMonitor m) throws BadLocationException, CoreException {
        m.setWorkRemaining(11);
        this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
        try {
            RAstNode lastNode;
            int endOffset;
            int startOffset;
            RAstNode parent;
            AbstractDocument document = this.sourceUnit.getDocument((IProgressMonitor)m.newChild(1));
            RHeuristicTokenScanner scanner = this.adapter.getScanner(this.sourceUnit);
            RCodeStyleSettings codeStyle = RRefactoringAdapter.getCodeStyle(this.sourceUnit);
            StringBuilder sb = new StringBuilder();
            String nl = document.getDefaultLineDelimiter();
            String defAssign = " <- ";
            String argAssign = codeStyle.getArgAssignString();
            RAstNode firstParentChild = this.expressions[0];
            while ((parent = firstParentChild.getRParent()) != null && parent.getNodeType() != NodeType.SOURCELINES && parent.getNodeType() != NodeType.BLOCK) {
                firstParentChild = parent;
            }
            if (this.expressions.length == 1 && this.expressions[0].getNodeType() == NodeType.BLOCK) {
                Block block = (Block)this.expressions[0];
                startOffset = block.getStartOffset() + 1;
                endOffset = block.getBlockCloseOffset();
                if (endOffset == Integer.MIN_VALUE) {
                    endOffset = block.getEndOffset();
                }
                lastNode = block.getChildCount() > 0 ? block.getChild(block.getChildCount() - 1) : block.getChild(123);
            } else {
                startOffset = this.expressions[0].getStartOffset();
                lastNode = this.expressions[this.expressions.length - 1];
                endOffset = lastNode.getEndOffset();
            }
            sb.setLength(0);
            sb.append(this.functionName);
            sb.append(" <- ");
            sb.append("function(");
            boolean hasArguments = false;
            for (Variable variable : this.variablesList) {
                if (!variable.getUseAsArgument()) continue;
                sb.append(variable.getName());
                sb.append(", ");
                hasArguments = true;
            }
            if (hasArguments) {
                sb.delete(sb.length() - 2, sb.length());
            }
            sb.append(')');
            if (codeStyle.getNewlineFDefBodyBlockBefore()) {
                sb.append(nl);
            } else {
                sb.append(' ');
            }
            sb.append('{');
            sb.append(nl);
            if (startOffset < endOffset) {
                IRegion lastLine = document.getLineInformationOfOffset(endOffset - 1);
                endOffset = Math.min(endOffset, lastLine.getOffset() + lastLine.getLength());
            }
            sb.append(document.get(startOffset, endOffset - startOffset));
            sb.append(nl);
            sb.append("}");
            sb.append(nl);
            String fdef = RRefactoringAdapter.indent(sb, document, firstParentChild.getStartOffset(), this.sourceUnit, scanner);
            TextRegion region = this.adapter.expandWhitespaceBlock(document, this.operationRegion, scanner);
            int insertOffset = this.adapter.expandWhitespaceBlock(document, this.adapter.expandSelectionRegion(document, (TextRegion)new BasicTextRegion(firstParentChild.getStartOffset()), this.operationRegion, scanner), scanner).getStartOffset();
            if (insertOffset == region.getStartOffset()) {
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.ExtractFunction_Changes_ReplaceOldWithFunctionDef_name, (TextEdit)new ReplaceEdit(insertOffset, region.getLength(), fdef));
            } else {
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.ExtractFunction_Changes_DeleteOld_name, (TextEdit)new DeleteEdit(region.getStartOffset(), region.getLength()));
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.ExtractFunction_Changes_AddFunctionDef_name, (TextEdit)new InsertEdit(insertOffset, fdef));
            }
            m.worked(4);
            sb.setLength(0);
            if (firstParentChild == this.expressions[0] && lastNode.getNodeType() == NodeType.A_LEFT) {
                Assignment assignment = (Assignment)lastNode;
                sb.append(document.get(assignment.getTargetChild().getStartOffset(), assignment.getTargetChild().getLength()));
                sb.append(" ");
                sb.append(assignment.getOperator((int)0).text);
                sb.append(" ");
            }
            sb.append(this.functionName);
            sb.append("(");
            for (Variable variable : this.variablesList) {
                if (!variable.getUseAsArgument()) continue;
                sb.append(variable.getName());
                sb.append(argAssign);
                sb.append(variable.getName());
                sb.append(", ");
            }
            if (hasArguments) {
                sb.delete(sb.length() - 2, sb.length());
            }
            sb.append(")");
            if (firstParentChild == this.expressions[0]) {
                sb.append(nl);
            }
            TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.ExtractFunction_Changes_AddFunctionCall_name, (TextEdit)new InsertEdit(region.getEndOffset(), sb.toString()));
            m.worked(4);
        }
        finally {
            this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    public class Variable {
        private final String name;
        private boolean asArgument;
        private boolean asArgumentDefault;
        private RElementAccess firstAccess;
        private RElementAccess lastAccess;

        public Variable(String name) {
            this.name = name;
        }

        void checkAccess(RElementAccess access) {
            if (this.firstAccess == null || access.getNode().getStartOffset() < this.firstAccess.getNode().getStartOffset()) {
                this.firstAccess = access;
                this.asArgument = !access.isWriteAccess() && !access.isFunctionAccess();
                this.asArgumentDefault = this.asArgument;
            }
            if (this.lastAccess == null || access.getNode().getStartOffset() > this.lastAccess.getNode().getStartOffset()) {
                this.lastAccess = access;
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean getUseAsArgumentDefault() {
            return this.asArgumentDefault;
        }

        public boolean getUseAsArgument() {
            return this.asArgument;
        }

        public void setUseAsArgument(boolean enable) {
            this.asArgument = enable;
        }
    }

    private class VariableSearcher
    extends GenericVisitor {
        private final int start;
        private final int stop;

        private VariableSearcher() {
            this.start = ExtractFunctionRefactoring.this.operationRegion.getStartOffset();
            this.stop = ExtractFunctionRefactoring.this.operationRegion.getEndOffset();
        }

        @Override
        public void visitNode(RAstNode node) throws InvocationTargetException {
            if (node.getStartOffset() >= this.stop || node.getEndOffset() < this.start) {
                return;
            }
            ImList attachments = node.getAttachments();
            for (Object attachment : attachments) {
                RAstNode nameNode;
                RElementAccess access;
                if (!(attachment instanceof RElementAccess) || (access = (RElementAccess)attachment).getType() != 17 || access.getSegmentName() == null || (nameNode = access.getNameNode()).getStartOffset() < this.start || nameNode.getEndOffset() > this.stop) continue;
                this.add(access);
            }
            node.acceptInRChildren(this);
        }

        @Override
        public void visit(FDef node) throws InvocationTargetException {
        }

        private void add(RElementAccess access) {
            RFrame frame = access.getFrame();
            if (!(frame instanceof RSourceFrame) || frame.getFrameType() == 2) {
                return;
            }
            String name = access.getSegmentName();
            Variable variable = (Variable)ExtractFunctionRefactoring.this.variablesMap.get(name);
            if (variable == null) {
                variable = new Variable(name);
                ExtractFunctionRefactoring.this.variablesMap.put(name, variable);
            }
            variable.checkAccess(access);
        }
    }
}

