/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ide.ui.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.base.ext.templates.ICodeGenerationTemplateCategory;
import org.eclipse.statet.ecommons.preferences.ui.ConfigurationBlock;
import org.eclipse.statet.ecommons.preferences.ui.SettingsUpdater;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.text.ui.TextViewerEditorColorUpdater;
import org.eclipse.statet.ecommons.text.ui.TextViewerJFaceUpdater;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.ecommons.ui.dialogs.groups.CategorizedOptionButtonsGroup;
import org.eclipse.statet.ecommons.ui.dialogs.groups.CategorizedOptionsGroup;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ide.ui.StatetUIPlugin;
import org.eclipse.statet.internal.ide.ui.preferences.CodeGenerationTemplatesStore;
import org.eclipse.statet.internal.ide.ui.preferences.Messages;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.ViewerSourceEditorAdapter;
import org.eclipse.statet.ltk.ui.templates.config.EditTemplateDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.templates.ContextTypeRegistry;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class CodeGenerationTemplatesConfigurationBlock
extends ConfigurationBlock {
    public static final String EXTENSION_POINT = "codeGenerationTemplatesCategory";
    public static final String ATT_ID = "id";
    public static final String ATT_NAME = "name";
    public static final String ATT_CLASS = "providerClass";
    private static final int IDX_EDIT = 0;
    private static final int IDX_IMPORT = 2;
    private static final int IDX_EXPORT = 3;
    private static final int IDX_EXPORTALL = 4;
    protected IProject fProject;
    private String[] fCategoryIds;
    private ICodeGenerationTemplateCategory[] fCategoryProvider;
    protected CodeGenerationTemplatesStore fTemplatesStore;
    protected Group fGroup;
    private SourceViewer fPatternViewer;
    private int fPatternViewerConfiguredCategory = -1;
    private TextViewerJFaceUpdater fPatternViewerUpdater = null;
    private SourceEditorViewerConfigurator fPatternConfigurator;
    private ISourceEditor fPatternEditor;
    private final TemplateVariableProcessor fPatternTemplateProcessor;
    private final TemplateVariableProcessor fEditTemplateProcessor;

    public CodeGenerationTemplatesConfigurationBlock(IProject project) throws CoreException {
        this.fProject = project;
        this.fGroup = new Group();
        this.loadRegisteredTemplates();
        this.fGroup.generateListModel();
        this.fPatternTemplateProcessor = new TemplateVariableProcessor();
        this.fEditTemplateProcessor = new TemplateVariableProcessor();
    }

    private void loadRegisteredTemplates() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.statet.base.ui", EXTENSION_POINT);
        this.fCategoryIds = new String[elements.length];
        this.fCategoryProvider = new ICodeGenerationTemplateCategory[elements.length];
        this.fGroup.fCategorys = new String[elements.length];
        this.fGroup.fCategoryChilds = new TemplateItem[elements.length][];
        TemplateStore[] templates = new TemplateStore[elements.length];
        int i = 0;
        while (i < elements.length) {
            this.fCategoryIds[i] = elements[i].getAttribute(ATT_ID);
            Assert.isLegal((this.fCategoryIds[i] != null ? 1 : 0) != 0);
            this.fGroup.fCategorys[i] = elements[i].getAttribute(ATT_NAME);
            if (this.fGroup.fCategorys[i] == null) {
                this.fGroup.fCategorys[i] = this.fCategoryIds[i];
            }
            try {
                this.fCategoryProvider[i] = (ICodeGenerationTemplateCategory)elements[i].createExecutableExtension(ATT_CLASS);
            }
            catch (CoreException e) {
                throw new IllegalArgumentException("Error occured when loading templateprovider of category with id " + this.fCategoryIds[i], e);
            }
            templates[i] = this.fCategoryProvider[i].getTemplateStore();
            ++i;
        }
        this.fTemplatesStore = new CodeGenerationTemplatesStore(this.fProject, templates);
        try {
            this.fTemplatesStore.load();
        }
        catch (IOException e) {
            StatetUIPlugin.logUnexpectedError(e);
        }
        i = 0;
        while (i < this.fCategoryIds.length) {
            TemplatePersistenceData[] datas = this.fTemplatesStore.getTemplateData(i);
            ((TemplateItem[][])this.fGroup.fCategoryChilds)[i] = new TemplateItem[datas.length];
            int j = 0;
            while (j < ((TemplateItem[][])this.fGroup.fCategoryChilds)[i].length) {
                ((TemplateItem[][])this.fGroup.fCategoryChilds)[i][j] = new TemplateItem(datas[j]);
                ++j;
            }
            ++i;
        }
    }

    private void reloadTemplateData() {
        int i = 0;
        while (i < this.fCategoryIds.length) {
            int j = 0;
            while (j < ((TemplateItem[][])this.fGroup.fCategoryChilds)[i].length) {
                ((TemplateItem[][])this.fGroup.fCategoryChilds)[i][j].fData = this.fTemplatesStore.getTemplateData(i, ((TemplateItem[][])this.fGroup.fCategoryChilds)[i][j].fData.getId());
                ++j;
            }
            ++i;
        }
    }

    private void updateTemplate(TemplatePersistenceData data) {
        TemplatePersistenceData[] datas = this.fTemplatesStore.getAllTemplateData();
        int i = 0;
        while (i < datas.length) {
            String id = datas[i].getId();
            if (id != null && id.equals(data.getId())) {
                datas[i].setTemplate(data.getTemplate());
                break;
            }
            ++i;
        }
    }

    public void setUseProjectSpecificSettings(boolean enable) {
        super.setUseProjectSpecificSettings(enable);
        if (enable) {
            UIAccess.getDisplay((Shell)this.getShell()).asyncExec(new Runnable(){

                @Override
                public void run() {
                    CodeGenerationTemplatesConfigurationBlock.this.fGroup.reselect();
                }
            });
        }
    }

    protected void createBlockArea(Composite pageComposite) {
        Label label = new Label(pageComposite, 16384);
        label.setText(Messages.CodeTemplates_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fGroup.createGroup(pageComposite, 1);
        this.fGroup.initFields();
        this.fPatternViewer = this.createViewer(pageComposite);
    }

    private SourceViewer createViewer(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(Messages.CodeTemplates_Preview_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        SourceViewer viewer = new SourceViewer(parent, null, 2816);
        viewer.setEditable(false);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        new TextViewerEditorColorUpdater(viewer, EditorsUI.getPreferenceStore());
        Document document = new Document();
        viewer.setDocument((IDocument)document);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = new PixelConverter(viewer.getControl()).convertHeightInCharsToPixels(5);
        viewer.getControl().setLayoutData((Object)data);
        this.fPatternEditor = new ViewerSourceEditorAdapter(viewer, null);
        new SettingsUpdater(new ISettingsChangedHandler(){

            public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
                if (CodeGenerationTemplatesConfigurationBlock.this.fPatternConfigurator != null) {
                    CodeGenerationTemplatesConfigurationBlock.this.fPatternConfigurator.handleSettingsChanged(groupIds, options);
                }
            }
        }, viewer.getControl());
        return viewer;
    }

    protected void updateSourceViewerInput(TemplateItem item) {
        if (this.fPatternViewer == null || !UIAccess.isOkToUse((Control)this.fPatternViewer.getControl())) {
            return;
        }
        if (item != null) {
            TemplatePersistenceData data = item.fData;
            ICodeGenerationTemplateCategory category = this.fCategoryProvider[item.getCategoryIndex()];
            Template template = data.getTemplate();
            TemplateContextType type = category.getContextTypeRegistry().getContextType(template.getContextTypeId());
            this.fPatternTemplateProcessor.setContextType(type);
            if (item.getCategoryIndex() != this.fPatternViewerConfiguredCategory) {
                this.fPatternViewerConfiguredCategory = item.getCategoryIndex();
                if (this.fPatternViewerUpdater != null) {
                    this.fPatternViewerUpdater.dispose();
                    this.fPatternViewerUpdater = null;
                }
                if (this.fPatternConfigurator != null) {
                    this.fPatternConfigurator.unconfigureTarget();
                    this.fPatternConfigurator = null;
                }
                this.fPatternConfigurator = category.getEditTemplateDialogConfiguator(this.fPatternTemplateProcessor, this.fProject);
                this.fPatternConfigurator.setTarget(this.fPatternEditor);
                this.fPatternViewerUpdater = new TextViewerJFaceUpdater((ISourceViewer)this.fPatternViewer, this.fPatternConfigurator.getSourceViewerConfiguration().getPreferences());
                Document document = new Document(template.getPattern());
                this.fPatternConfigurator.getDocumentSetupParticipant().setup((IDocument)document);
                this.fPatternViewer.setDocument((IDocument)document);
            } else {
                this.fPatternViewer.getDocument().set(template.getPattern());
            }
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    public void doEdit(TemplateItem item) {
        EditTemplateDialog dialog = new EditTemplateDialog(this.getShell(), item.fData.getTemplate(), true, 3, this.fCategoryProvider[item.getCategoryIndex()].getEditTemplateDialogConfiguator(this.fEditTemplateProcessor, this.fProject), this.fEditTemplateProcessor, (ContextTypeRegistry)this.fCategoryProvider[item.getCategoryIndex()].getContextTypeRegistry(), "org.eclipse.statet.ltk.ui/templates/config");
        if (dialog.open() == 0) {
            item.fData.setTemplate(dialog.getTemplate());
            ((TreeViewer)this.fGroup.getStructuredViewer()).refresh((Object)item);
            ((TreeViewer)this.fGroup.getStructuredViewer()).setSelection((ISelection)new StructuredSelection((Object)item));
        }
    }

    public void doImport() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(Messages.CodeTemplates_Import_title);
        dialog.setFilterExtensions(new String[]{Messages.CodeTemplates_Import_extension});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            TemplateReaderWriter reader = new TemplateReaderWriter();
            File file = new File(path);
            if (file.exists()) {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                try {
                    TemplatePersistenceData[] datas = reader.read((InputStream)input, null);
                    int i = 0;
                    while (i < datas.length) {
                        this.updateTemplate(datas[i]);
                        ++i;
                    }
                }
                finally {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ((TreeViewer)this.fGroup.getStructuredViewer()).refresh();
            this.updateSourceViewerInput((TemplateItem)this.fGroup.getSingleItem(this.fGroup.getSelectedItems()));
        }
        catch (FileNotFoundException e) {
            this.openReadErrorDialog(e);
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    public void doExport(TemplatePersistenceData[] templates) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(NLS.bind((String)Messages.CodeTemplates_Export_title, (Object)String.valueOf(templates.length)));
        dialog.setFilterExtensions(new String[]{Messages.CodeTemplates_Export_extension});
        dialog.setFileName(Messages.CodeTemplates_Export_filename);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.isHidden()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.CodeTemplates_Export_Error_title, (String)NLS.bind((String)Messages.CodeTemplates_Export_Error_Hidden_message, (Object)file.getAbsolutePath()));
            return;
        }
        if (file.exists() && !file.canWrite()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.CodeTemplates_Export_Error_title, (String)NLS.bind((String)Messages.CodeTemplates_Export_Error_CanNotWrite_message, (Object)file.getAbsolutePath()));
            return;
        }
        if (!file.exists() || this.confirmOverwrite(file)) {
            OutputStream output = null;
            try {
                output = new BufferedOutputStream(new FileOutputStream(file));
                TemplateReaderWriter writer = new TemplateReaderWriter();
                writer.save(templates, output);
                output.close();
            }
            catch (IOException e) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.openWriteErrorDialog(e);
            }
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.CodeTemplates_Export_Exists_title, (String)NLS.bind((String)Messages.CodeTemplates_Export_Exists_message, (Object)file.getAbsolutePath()));
    }

    public void performDefaults() {
        this.fTemplatesStore.restoreDefaults();
        this.reloadTemplateData();
        ((TreeViewer)this.fGroup.getStructuredViewer()).refresh();
        this.updateSourceViewerInput((TemplateItem)this.fGroup.getSingleItem(this.fGroup.getSelectedItems()));
    }

    public boolean performOk(int flags) {
        if (this.fProject != null) {
            TemplatePersistenceData[] templateData = this.fTemplatesStore.getAllTemplateData();
            this.fTemplatesStore.setProjectSpecific(this.isUseProjectSpecificSettings());
            int i = 0;
            while (i < templateData.length) {
                this.fTemplatesStore.setProjectSpecific(templateData[i].getId(), this.isUseProjectSpecificSettings());
                ++i;
            }
        }
        try {
            this.fTemplatesStore.save();
        }
        catch (IOException e) {
            StatetUIPlugin.logUnexpectedError(e);
            this.openWriteErrorDialog(e);
        }
        return true;
    }

    public void performCancel() {
        try {
            this.fTemplatesStore.revertChanges();
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void openReadErrorDialog(Exception e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ide.ui", 0, Messages.CodeTemplates_error_Read_message, (Throwable)e));
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.CodeTemplates_error_title, (String)Messages.CodeTemplates_error_Read_message);
    }

    private void openWriteErrorDialog(Exception e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ide.ui", 0, Messages.CodeTemplates_error_Write_message, (Throwable)e));
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.CodeTemplates_error_title, (String)Messages.CodeTemplates_error_Write_message);
    }

    private class Group
    extends CategorizedOptionButtonsGroup<TemplateItem> {
        public Group() {
            String[] stringArray = new String[5];
            stringArray[0] = Messages.CodeTemplates_EditButton_label;
            stringArray[2] = Messages.CodeTemplates_ImportButton_label;
            stringArray[3] = Messages.CodeTemplates_ExportButton_label;
            stringArray[4] = Messages.CodeTemplates_ExportAllButton_label;
            super(stringArray);
        }

        @Override
        protected void handleDoubleClick(TemplateItem item, IStructuredSelection rawSelection) {
            CodeGenerationTemplatesConfigurationBlock.this.doEdit(item);
        }

        @Override
        public void handleSelection(TemplateItem item, IStructuredSelection rawSelection) {
            this.fButtonGroup.enableButton(0, item != null);
            this.fButtonGroup.enableButton(3, rawSelection.size() > 0);
            CodeGenerationTemplatesConfigurationBlock.this.updateSourceViewerInput(item);
        }

        @Override
        public void handleButtonPressed(int buttonIdx, TemplateItem item, IStructuredSelection rawSelection) {
            switch (buttonIdx) {
                case 0: {
                    if (item == null) break;
                    CodeGenerationTemplatesConfigurationBlock.this.doEdit(item);
                    break;
                }
                case 3: {
                    ArrayList<TemplatePersistenceData> datas = new ArrayList<TemplatePersistenceData>();
                    for (Object curr : rawSelection) {
                        if (curr instanceof TemplateItem) {
                            datas.add(((TemplateItem)curr).fData);
                            continue;
                        }
                        int catIndex = this.getIndexOfCategory(curr);
                        int j = 0;
                        while (j < ((TemplateItem[][])this.fCategoryChilds)[catIndex].length) {
                            datas.add(((TemplateItem[][])this.fCategoryChilds)[catIndex][j].fData);
                            ++j;
                        }
                    }
                    CodeGenerationTemplatesConfigurationBlock.this.doExport(datas.toArray(new TemplatePersistenceData[datas.size()]));
                    break;
                }
                case 4: {
                    CodeGenerationTemplatesConfigurationBlock.this.doExport(CodeGenerationTemplatesConfigurationBlock.this.fTemplatesStore.getAllTemplateData());
                    break;
                }
                case 2: {
                    CodeGenerationTemplatesConfigurationBlock.this.doImport();
                }
            }
        }
    }

    public class TemplateItem
    extends CategorizedOptionsGroup.CategorizedItem {
        protected TemplatePersistenceData fData;

        public TemplateItem(TemplatePersistenceData data) {
            super(data.getTemplate().getDescription());
            this.fData = data;
        }
    }
}

