/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import org.eclipse.statet.internal.rj.servi.MXUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.servi.jmx.PoolConfigMXBean;
import org.eclipse.statet.rj.servi.pool.PoolConfig;
import org.eclipse.statet.rj.servi.pool.PoolServer;

@NonNullByDefault
public class MXPoolConfig
extends PoolConfig
implements PoolConfigMXBean {
    private final PoolServer server;
    private @Nullable ObjectName jmName;

    public MXPoolConfig(PoolServer server) throws JMException {
        if (server == null) {
            throw new NullPointerException("server");
        }
        this.server = server;
    }

    public void initJM() throws JMException {
        ObjectName jmName;
        this.jmName = jmName = new ObjectName(String.valueOf(this.server.getJMBaseName()) + "type=Server.PoolConfig");
        ManagementFactory.getPlatformMBeanServer().registerMBean(this, jmName);
    }

    public void disposeJM() throws JMException {
        ObjectName jmName = this.jmName;
        if (jmName != null) {
            this.jmName = null;
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(jmName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply() throws OperationsException {
        MXPoolConfig mXPoolConfig = this;
        synchronized (mXPoolConfig) {
            MXUtils.validate(this);
            this.server.setPoolConfig(this);
        }
    }

    @Override
    public void loadActual() throws OperationsException {
        this.server.getPoolConfig(this);
    }

    @Override
    public void loadDefault() throws OperationsException {
        this.load(new PoolConfig());
    }

    @Override
    public void loadSaved() throws OperationsException {
        MXUtils.load(this, this.server.getRJContext());
    }

    @Override
    public void save() throws OperationsException {
        MXUtils.save(this, this.server.getRJContext());
    }
}

