/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.docmlet.tex.core.ast.NodeType;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.internal.docmlet.tex.ui.editors.TexLinkedNamesAssistProposal;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.QuickAssistComputer;

@NonNullByDefault
public class TexQuickRenameComputer
implements QuickAssistComputer {
    public void computeAssistProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (!(context.getAstSelection().getCovering() instanceof TexAstNode)) {
            return;
        }
        TexAstNode node = (TexAstNode)context.getAstSelection().getCovering();
        if (node.getNodeType() == NodeType.LABEL) {
            TexAstNode candidate = node;
            block0: while (candidate != null) {
                ImList attachments = candidate.getAttachments();
                block1: for (Object attachment : attachments) {
                    if (!(attachment instanceof TexNameAccess)) continue;
                    TexNameAccess access = (TexNameAccess)attachment;
                    while (access != null) {
                        if (access.getSegmentName() == null) continue block1;
                        if (access.getNameNode() == node) {
                            this.addAccessAssistProposals(context, access, proposals);
                            break block0;
                        }
                        access = null;
                    }
                }
                candidate = candidate.getTexParent();
            }
        }
    }

    protected void addAccessAssistProposals(AssistInvocationContext context, TexNameAccess access, AssistProposalCollector proposals) {
        ImList accessList = access.getAllInUnit();
        proposals.add((AssistProposal)new TexLinkedNamesAssistProposal(1, context, access));
    }
}

