/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.dbg;

import java.io.IOException;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.server.dbg.TracepointInstallationRequest;

public class FlagTracepointInstallationRequest
extends TracepointInstallationRequest {
    private final byte[] types;
    private final int[] flags;

    public FlagTracepointInstallationRequest(byte[] types, int[] flags) {
        if (types.length != flags.length) {
            throw new IllegalArgumentException("types.length != flags.length");
        }
        this.types = types;
        this.flags = flags;
    }

    public FlagTracepointInstallationRequest(RJIO in) throws IOException {
        int l = in.readInt();
        this.types = in.readByteData(new byte[l], l);
        this.flags = in.readIntData(new int[l], l);
    }

    public void writeExternal(RJIO out) throws IOException {
        int l = this.types.length;
        out.writeInt(l);
        out.writeByteData(this.types, l);
        out.writeIntData(this.flags, l);
    }

    public byte[] getTypes() {
        return this.types;
    }

    public int[] getFlags() {
        return this.flags;
    }
}

