/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.impl.AbstractCharacterStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;
import org.eclipse.statet.rj.data.impl.RDataResizeExtension;

public class RCharacter32Store
extends AbstractCharacterStore
implements RDataResizeExtension<String>,
ExternalizableRStore,
Externalizable {
    private int length;
    protected String[] charValues;

    public RCharacter32Store() {
        this.length = 0;
        this.charValues = EMPTY_STRING_ARRAY;
    }

    public RCharacter32Store(int length) {
        this.length = length;
        this.charValues = new String[length];
        Arrays.fill(this.charValues, "");
    }

    public RCharacter32Store(String[] values) {
        this.length = values.length;
        this.charValues = values;
    }

    public RCharacter32Store(String[] values, int length) {
        this.length = length;
        this.charValues = values;
    }

    RCharacter32Store(RCharacter32Store source, boolean reuse) {
        String[] values;
        if (reuse) {
            values = source.charValues;
        } else {
            values = RCharacter32Store.ensureCapacity(this.charValues, source.length);
            System.arraycopy(source, 0, values, 0, source.length);
        }
        this.charValues = values;
        this.length = source.length;
    }

    public RCharacter32Store(RJIO io, int length) throws IOException {
        this.length = length;
        this.charValues = new String[length];
        io.readStringData(this.charValues, length);
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        io.writeStringData(this.charValues, this.length);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.length = in.readInt();
        this.charValues = new String[this.length];
        int i = 0;
        while (i < this.length) {
            int l = in.readInt();
            if (l >= 0) {
                char[] c = new char[l];
                int j = 0;
                while (j < l) {
                    c[j] = in.readChar();
                    ++j;
                }
                this.charValues[i] = new String(c);
            }
            ++i;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.length);
        int i = 0;
        while (i < this.length) {
            if (this.charValues[i] != null) {
                out.writeInt(this.charValues[i].length());
                out.writeChars(this.charValues[i]);
            } else {
                out.writeInt(-1);
            }
            ++i;
        }
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    public final int length() {
        return this.length;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        return this.charValues[idx] == null;
    }

    @Override
    public boolean isNA(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.charValues[(int)idx] == null;
    }

    @Override
    public void setNA(int idx) {
        this.charValues[idx] = null;
    }

    @Override
    public void setNA(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.charValues[(int)idx] = null;
    }

    @Override
    public boolean isMissing(int idx) {
        return this.charValues[idx] == null;
    }

    @Override
    public boolean isMissing(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.charValues[(int)idx] == null;
    }

    @Override
    public String getChar(int idx) {
        return this.charValues[idx];
    }

    @Override
    public String getChar(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.charValues[(int)idx];
    }

    @Override
    public void setChar(int idx, String value) {
        this.charValues[idx] = value;
    }

    @Override
    public void setChar(long idx, String value) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.charValues[(int)idx] = value;
    }

    private void prepareInsert(int[] idxs) {
        this.charValues = RCharacter32Store.prepareInsert(this.charValues, this.length, idxs);
        this.length += idxs.length;
    }

    public void insertChar(int idx, String value) {
        this.prepareInsert(new int[]{idx});
        this.charValues[idx] = value;
    }

    @Override
    public void insertNA(int idx) {
        this.prepareInsert(new int[]{idx});
        this.charValues[idx] = null;
    }

    @Override
    public void insertNA(int[] idxs) {
        if (idxs.length == 0) {
            return;
        }
        this.prepareInsert(idxs);
        int i = 0;
        while (i < idxs.length) {
            this.charValues[idxs[i]] = null;
            ++i;
        }
    }

    @Override
    public void remove(int idx) {
        this.charValues = RCharacter32Store.remove(this.charValues, this.length, new int[]{idx});
        --this.length;
    }

    @Override
    public void remove(int[] idxs) {
        this.charValues = RCharacter32Store.remove(this.charValues, this.length, idxs);
        this.length -= idxs.length;
    }

    @Override
    public String get(int idx) {
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.charValues[idx];
    }

    @Override
    public String get(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.charValues[(int)idx];
    }

    @Override
    public String[] toArray() {
        String[] array = new String[this.length()];
        System.arraycopy(this.charValues, 0, array, 0, array.length);
        return array;
    }

    @Override
    public long indexOfNA(long fromIdx) {
        if (fromIdx >= Integer.MAX_VALUE) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int l = this.length();
        String[] chars = this.charValues;
        int i = (int)fromIdx;
        while (i < l) {
            if (chars[i] == null) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    public int indexOfNA(int fromIdx) {
        if (fromIdx < 0) {
            fromIdx = 0;
        }
        int l = this.length();
        String[] chars = this.charValues;
        int i = fromIdx;
        while (i < l) {
            if (chars[i] == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public long indexOf(String character, long fromIdx) {
        if (character == null || fromIdx >= Integer.MAX_VALUE) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int l = this.length();
        String[] chars = this.charValues;
        int i = (int)fromIdx;
        while (i < l) {
            if (chars[i] != null && chars[i].equals(character)) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    public int indexOf(String character, int fromIdx) {
        if (character == null) {
            throw new NullPointerException();
        }
        if (fromIdx < 0) {
            fromIdx = 0;
        }
        int l = this.length();
        String[] chars = this.charValues;
        while (fromIdx < l) {
            if (chars[fromIdx] != null && chars[fromIdx].equals(character)) {
                return fromIdx;
            }
            ++fromIdx;
        }
        return -1;
    }
}

