/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.sourceediting;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.ast.ControlNode;
import org.eclipse.statet.docmlet.tex.core.ast.LtxParser;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAsts;
import org.eclipse.statet.docmlet.tex.core.commands.Argument;
import org.eclipse.statet.docmlet.tex.core.model.LtxSourceUnitModelInfo;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.docmlet.tex.core.parser.LtxLexer;
import org.eclipse.statet.docmlet.tex.core.parser.NowebLtxLexer;
import org.eclipse.statet.docmlet.tex.core.source.LtxPartitionNodeScanner;
import org.eclipse.statet.ecommons.text.core.FragmentDocument;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionUtils;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxArgumentListContextInformation;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.input.OffsetStringParserInput;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistCompletionInformationProposalWrapper;
import org.eclipse.swt.custom.StyleRange;

@NonNullByDefault
public class LtxContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private final ISourceEditor sourceEditor;
    private @Nullable LtxArgumentListContextInformation info;
    private long scannedArgsStamp;
    private @Nullable ControlNode scannedArgs;
    private int lastPresentation = -2;

    public LtxContextInformationValidator(ISourceEditor editor) {
        this.sourceEditor = editor;
    }

    public void install(IContextInformation info, ITextViewer viewer, int offset) {
        if (info instanceof AssistCompletionInformationProposalWrapper) {
            info = ((AssistCompletionInformationProposalWrapper)info).getContextInformation();
        }
        this.scannedArgs = null;
        this.lastPresentation = -2;
        if (!(info instanceof LtxArgumentListContextInformation) || viewer != this.sourceEditor.getViewer()) {
            this.info = null;
            return;
        }
        this.info = (LtxArgumentListContextInformation)info;
    }

    public boolean isContextInformationValid(int offset) {
        LtxArgumentListContextInformation info = this.info;
        if (info == null) {
            return false;
        }
        if (offset < info.getContextInformationPosition() || offset > this.sourceEditor.getViewer().getDocument().getLength()) {
            return false;
        }
        ControlNode args = this.getScannedArgs();
        if (args != null) {
            return offset <= args.getEndOffset();
        }
        return offset == info.getContextInformationPosition();
    }

    public boolean updatePresentation(int offset, TextPresentation presentation) {
        LtxArgumentListContextInformation info = this.info;
        if (info == null) {
            return false;
        }
        if (info.getCommand().getArguments().size() > 0) {
            int argIdx = this.getCurrentArgInDef(offset);
            int[] idxs = info.getInformationDisplayStringArgumentIdxs();
            if (argIdx >= 0 && argIdx < idxs.length) {
                if (argIdx == this.lastPresentation) {
                    return false;
                }
                int start = idxs[argIdx];
                int stop = argIdx + 1 < idxs.length ? idxs[argIdx + 1] : info.getInformationDisplayString().length();
                presentation.clear();
                presentation.addStyleRange(new StyleRange(start, stop - start, null, null, 1));
                this.lastPresentation = argIdx;
                return true;
            }
        }
        if (this.lastPresentation >= 0) {
            presentation.clear();
            this.lastPresentation = -1;
            return true;
        }
        return false;
    }

    private LtxParser.TaskConfig getParserTaskConfig() {
        SourceUnit sourceUnit = this.sourceEditor.getSourceUnit();
        if (sourceUnit instanceof TexSourceUnit) {
            TexSourceUnit texSourceUnit = (TexSourceUnit)sourceUnit;
            LtxParser.TaskConfig config = new LtxParser.TaskConfig(texSourceUnit.getTexCoreAccess().getTexCommandSet());
            SourceUnitModelInfo modelInfo = texSourceUnit.getModelInfo(null, 0, null);
            if (modelInfo instanceof LtxSourceUnitModelInfo) {
                config.additionalCommands = ((LtxSourceUnitModelInfo)modelInfo).getCustomCommandMap();
                config.additionalEnvs = ((LtxSourceUnitModelInfo)modelInfo).getCustomEnvMap();
            }
            return config;
        }
        return new LtxParser.TaskConfig(TexCore.getWorkbenchAccess().getTexCommandSet());
    }

    private @Nullable ControlNode getScannedArgs() {
        LtxArgumentListContextInformation info = (LtxArgumentListContextInformation)ObjectUtils.nonNullAssert((Object)this.info);
        int startOffset = info.getCallArgsOffset();
        AbstractDocument document = (AbstractDocument)this.sourceEditor.getViewer().getDocument();
        int docStartOffset = startOffset;
        if (document instanceof FragmentDocument) {
            FragmentDocument fragmentDoc = (FragmentDocument)document;
            document = fragmentDoc.getMasterDocument();
            docStartOffset += fragmentDoc.getOffsetInMasterDocument();
        }
        if (docStartOffset < 0) {
            docStartOffset = 0;
        }
        long stamp = document.getModificationStamp();
        if (this.scannedArgs == null || this.scannedArgsStamp != stamp) {
            try {
                ControlNode args = null;
                TreePartitionNode rRootNode = LtxPartitionNodeScanner.findLtxRootNode((TreePartitionNode)TreePartitionUtils.getNode((IDocument)document, (String)this.sourceEditor.getDocumentContentInfo().getPartitioning(), (int)docStartOffset, (boolean)true));
                if (rRootNode != null) {
                    int docEndOffset = Math.min(2048, rRootNode.getEndOffset() - docStartOffset);
                    String text = document.get(docStartOffset, docEndOffset);
                    LtxParser parser = new LtxParser((LtxLexer)new NowebLtxLexer(), null);
                    args = parser.scanControlWordArgs(new OffsetStringParserInput(text, startOffset).init(startOffset, startOffset + text.length()), info.getCommand(), true, this.getParserTaskConfig());
                }
                this.scannedArgs = args;
                this.scannedArgsStamp = stamp;
            }
            catch (Exception e) {
                this.scannedArgs = null;
            }
        }
        return this.scannedArgs;
    }

    private int getCurrentArgInDef(int offset) {
        ControlNode args = this.getScannedArgs();
        if (args != null) {
            @Nullable TexAstNode[] argNodes = TexAsts.resolveArguments((ControlNode)args);
            int idx = TexAsts.getIndexAt((TexAstNode[])argNodes, (int)offset);
            if (idx < 0) {
                idx = -idx - 1;
            } else if (idx >= 0 && idx + 1 < argNodes.length && argNodes[idx].getEndOffset() == offset) {
                if ((argNodes[idx].getStatusCode() & 0xFFFF) != 8468) {
                    ++idx;
                }
            } else if (idx > 0 && argNodes[idx].getStartOffset() == offset) {
                while (idx > 0 && argNodes[idx - 1] == null && ((Argument)this.info.getCommand().getArguments().get(idx - 1)).isOptional()) {
                    --idx;
                }
            }
            return idx;
        }
        return -1;
    }
}

