/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;

@NonNullByDefault
public class RReferenceImpl
implements RReference,
ExternalizableRObject {
    private long handle;
    private byte type;
    private String baseClassName;

    public RReferenceImpl(long handler, byte type, String baseClass) {
        this.handle = handler;
        this.type = type;
        this.baseClassName = baseClass;
    }

    public RReferenceImpl(RJIO io, RObjectFactory factory) throws IOException {
        this.readExternal(io, factory);
    }

    public void readExternal(RJIO io, RObjectFactory factory) throws IOException {
        this.handle = io.readLong();
        this.type = io.readByte();
        this.baseClassName = io.readString();
    }

    @Override
    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        io.writeLong(this.handle);
        io.writeByte(this.type);
        io.writeString(this.baseClassName);
    }

    @Override
    public byte getRObjectType() {
        return 14;
    }

    @Override
    public byte getReferencedRObjectType() {
        return this.type;
    }

    @Override
    public String getRClassName() {
        return this.baseClassName;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public long getHandle() {
        return this.handle;
    }

    @Override
    public @Nullable RObject getResolvedRObject() {
        return null;
    }

    @Override
    public @Nullable RStore<?> getData() {
        return null;
    }

    @Override
    public @Nullable RList getAttributes() {
        return null;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RReference && this.handle == ((RReference)obj).getHandle();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RObjectReference type= ").append(RDataUtils.getObjectTypeName(this.type));
        sb.append(", class= ").append(this.getRClassName());
        return sb.toString();
    }
}

