/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import org.eclipse.statet.rj.data.RIntegerStore;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractRStore;

public abstract class AbstractIntegerStore
extends AbstractRStore<Integer>
implements RIntegerStore {
    protected static final byte toRaw(int integer) {
        if ((integer & 0xFFFFFF00) == 0) {
            return (byte)(integer & 0xFF);
        }
        throw new NumberFormatException(Integer.toString(integer));
    }

    @Override
    public final byte getStoreType() {
        return 2;
    }

    @Override
    public final String getBaseVectorRClassName() {
        return "integer";
    }

    @Override
    public final boolean getLogi(int idx) {
        return this.getInt(idx) != 0;
    }

    @Override
    public final boolean getLogi(long idx) {
        return this.getInt(idx) != 0;
    }

    @Override
    public final void setLogi(int idx, boolean logi) {
        this.setInt(idx, logi ? 1 : 0);
    }

    @Override
    public final void setLogi(long idx, boolean logi) {
        this.setInt(idx, logi ? 1 : 0);
    }

    @Override
    public final double getNum(int idx) {
        return this.getInt(idx);
    }

    @Override
    public final double getNum(long idx) {
        return this.getInt(idx);
    }

    @Override
    public final void setNum(int idx, double real) {
        this.setInt(idx, (int)real);
    }

    @Override
    public final void setNum(long idx, double real) {
        this.setInt(idx, (int)real);
    }

    @Override
    public final String getChar(int idx) {
        return Integer.toString(this.getInt(idx));
    }

    @Override
    public final String getChar(long idx) {
        return Integer.toString(this.getInt(idx));
    }

    @Override
    public byte getRaw(int idx) {
        return AbstractIntegerStore.toRaw(this.getInt(idx));
    }

    @Override
    public byte getRaw(long idx) {
        return AbstractIntegerStore.toRaw(this.getInt(idx));
    }

    @Override
    public abstract Integer[] toArray();

    @Override
    public long indexOf(String character, long fromIdx) {
        try {
            return this.indexOf(Integer.parseInt(character), fromIdx);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @Override
    public boolean allEqual(RStore<?> other) {
        long length = this.getLength();
        if (2 != other.getStoreType() || length != other.getLength()) {
            return false;
        }
        if (length < 0L) {
            return true;
        }
        if (length <= Integer.MAX_VALUE) {
            int ilength = (int)length;
            int idx = 0;
            while (idx < ilength) {
                if (this.isNA(idx) ? !other.isNA(idx) : this.getInt(idx) != other.getInt(idx)) {
                    return false;
                }
                ++idx;
            }
        } else {
            long idx = 0L;
            while (idx < length) {
                if (this.isNA(idx) ? !other.isNA(idx) : this.getInt(idx) != other.getInt(idx)) {
                    return false;
                }
                ++idx;
            }
        }
        return true;
    }
}

