/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ide.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.dialogs.groups.Layouter;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.PixelConverter;
import org.eclipse.statet.internal.ide.ui.StatetMessages;
import org.eclipse.statet.internal.ide.ui.StatetUIPlugin;
import org.eclipse.statet.internal.ide.ui.preferences.Messages;
import org.eclipse.statet.ltk.issues.core.TaskPriority;
import org.eclipse.statet.ltk.issues.core.TaskTag;
import org.eclipse.statet.ltk.issues.core.impl.BasicTaskTag;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

class TaskTagsInputDialog
extends ExtStatusDialog {
    private Text keywordControl;
    private Combo priorityControl;
    private String keyword;
    private TaskPriority priority;
    private final List<String> existingKeywords;

    public TaskTagsInputDialog(Shell parent, TaskTag task, boolean newTask, List<BasicTaskTag> existingTags) {
        super(parent);
        if (task != null) {
            this.keyword = task.getKeyword();
            this.priority = task.getPriority();
        }
        this.existingKeywords = new ArrayList<String>(existingTags.size());
        int i = 0;
        while (i < existingTags.size()) {
            TaskTag curr = (TaskTag)existingTags.get(i);
            if (newTask || !curr.equals(task)) {
                this.existingKeywords.add(curr.getKeyword());
            }
            ++i;
        }
        this.setTitle(task == null ? Messages.TaskTags_InputDialog_NewTag_title : Messages.TaskTags_InputDialog_EditTag_title);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return DialogUtils.getDialogSettings((AbstractUIPlugin)StatetUIPlugin.getInstance(), (String)"TaskTagEditDialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        Layouter layouter = new Layouter(area, LayoutUtils.newDialogGrid((int)2));
        area.setLayoutData((Object)new GridData(1808));
        this.keywordControl = layouter.addLabeledTextControl(Messages.TaskTags_InputDialog_Name_label);
        ((GridData)this.keywordControl.getLayoutData()).widthHint = new PixelConverter((Control)this.keywordControl).convertWidthInCharsToPixels(45);
        this.keywordControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskTagsInputDialog.this.keyword = TaskTagsInputDialog.this.keywordControl.getText();
                TaskTagsInputDialog.this.doValidation();
            }
        });
        String[] items = new String[]{StatetMessages.TaskPriority_High, StatetMessages.TaskPriority_Normal, StatetMessages.TaskPriority_Low};
        this.priorityControl = layouter.addLabeledComboControl(Messages.TaskTags_InputDialog_Priority_label, items);
        this.priorityControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                switch (TaskTagsInputDialog.this.priorityControl.getSelectionIndex()) {
                    case 0: {
                        TaskTagsInputDialog.this.priority = TaskPriority.HIGH;
                        break;
                    }
                    case 2: {
                        TaskTagsInputDialog.this.priority = TaskPriority.LOW;
                        break;
                    }
                    default: {
                        TaskTagsInputDialog.this.priority = TaskPriority.NORMAL;
                    }
                }
            }
        });
        if (this.keyword != null) {
            this.keywordControl.setText(this.keyword);
            switch (this.priority) {
                case HIGH: {
                    this.priorityControl.select(0);
                    break;
                }
                case LOW: {
                    this.priorityControl.select(2);
                    break;
                }
                default: {
                    this.priorityControl.select(1);
                    break;
                }
            }
        } else {
            this.priorityControl.select(1);
        }
        Display display = parent.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TaskTagsInputDialog.this.keywordControl.setFocus();
                }
            });
        }
        LayoutUtils.addSmallFiller((Composite)area, (boolean)true);
        TaskTagsInputDialog.applyDialogFont((Control)area);
        return area;
    }

    public TaskTag getResult() {
        return new BasicTaskTag(this.keyword, this.priority);
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.keywordControl.getText();
        if (newText.isEmpty()) {
            status.setError(Messages.TaskTags_InputDialog_error_EnterName_message);
        } else if (newText.indexOf(44) != -1) {
            status.setError(Messages.TaskTags_InputDialog_error_Comma_message);
        } else if (this.existingKeywords.contains(newText)) {
            status.setError(Messages.TaskTags_InputDialog_error_EntryExists_message);
        } else if (!Character.isLetterOrDigit(newText.charAt(0))) {
            status.setError(Messages.TaskTags_InputDialog_error_ShouldStartWithLetterOrDigit_message);
        }
        this.updateStatus((IStatus)status);
    }
}

