/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.Collection;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceTextBlockAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockNode;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockType;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.TextSegment;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineParser;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ParagraphBlock<TNode extends ParagraphBlockNode<?>>
extends SourceBlockType<TNode> {
    public static final ImIdentityList<Class<? extends SourceBlockType<?>>> DEFAULT_INTERRUPT_EXCLUSIONS = ImCollections.newIdentityList();
    private final Collection<Class<? extends SourceBlockType<?>>> interruptExclusions;

    public ParagraphBlock() {
        this((ImCollection<Class<SourceBlockType<?>>>)DEFAULT_INTERRUPT_EXCLUSIONS);
    }

    public ParagraphBlock(ImCollection<Class<? extends SourceBlockType<?>>> interruptExclusions) {
        this.interruptExclusions = interruptExclusions;
    }

    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockNode<?> currentNode) {
        Line line = lineSequence.getCurrentLine();
        return line != null && !line.isBlank();
    }

    @Override
    public void createNodes(SourceBlocks.SourceBlockBuilder builder) {
        Line line;
        ParagraphBlockNode<ParagraphBlock> node = new ParagraphBlockNode<ParagraphBlock>(this, builder);
        LineSequence lineSequence = builder.getLineSequence();
        lineSequence.advance();
        while ((line = lineSequence.getCurrentLine()) != null && !line.isBlank() && !this.isAnotherBlockStart(lineSequence, builder.getSourceBlocks(), node)) {
            lineSequence.advance();
        }
    }

    @Override
    public void initializeContext(ProcessingContext context, TNode node) {
    }

    @Override
    public void emit(ProcessingContext context, TNode node, CommonmarkLocator locator, DocumentBuilder builder) {
        this.emitParagraph(context, (ParagraphBlockNode<?>)node, true, locator, builder);
    }

    void emitParagraph(ProcessingContext context, ParagraphBlockNode<?> node, boolean asBlock, CommonmarkLocator locator, DocumentBuilder builder) {
        ImList<Line> lines = node.getLines();
        TextSegment textSegment = new TextSegment(lines);
        List<Inline> inlines = context.getInlineParser().parse(context, textSegment, true);
        if (!inlines.isEmpty()) {
            locator.setBlockBegin(node);
            if (asBlock) {
                SourceTextBlockAttributes attributes = new SourceTextBlockAttributes(lines, 256);
                builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, (Attributes)attributes);
            }
            InlineParser.emit(context, inlines, locator, builder);
            locator.setBlockEnd(node);
            if (asBlock) {
                builder.endBlock();
            }
        }
    }

    boolean isAnotherBlockStart(LineSequence lineSequence, SourceBlocks sourceBlocks, SourceBlockNode<?> currentNode) {
        SourceBlockType<?> block = sourceBlocks.selectBlock(lineSequence, currentNode);
        return block != null && !(block instanceof ParagraphBlock) && !this.interruptExclusions.contains(block.getClass());
    }

    static class ParagraphBlockNode<TType extends ParagraphBlock<?>>
    extends SourceBlockNode<TType> {
        protected ParagraphBlockNode(TType type, SourceBlocks.SourceBlockBuilder builder) {
            super(type, builder);
        }

        @Override
        public boolean isParagraph() {
            return true;
        }
    }
}

