/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.intable;

import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.data.ControlData;
import org.eclipse.statet.ecommons.waltable.data.convert.IDisplayConverter;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.AbstractTextPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.statet.ecommons.waltable.style.HorizontalAlignment;
import org.eclipse.statet.ecommons.waltable.style.IStyle;
import org.eclipse.statet.ecommons.waltable.style.VerticalAlignment;
import org.eclipse.statet.ecommons.waltable.swt.SWTUtil;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class RTextPainter
extends AbstractTextPainter {
    private final StringBuilder tempText = new StringBuilder();
    private String currentText;
    private int currentTextWidth;

    private static Object getData(ILayerCell cell, IConfigRegistry configRegistry) {
        IDisplayConverter displayConverter = (IDisplayConverter)configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        return displayConverter != null ? displayConverter.canonicalToDisplayValue(cell, configRegistry, cell.getDataValue(0, null)) : "";
    }

    public RTextPainter(int space) {
        super(false, true, space, false, false, 1);
    }

    public long getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Object data = RTextPainter.getData(cell, configRegistry);
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry), data);
        return this.getWidthFromCache(gc, data.toString()) + this.spacing * 2;
    }

    public long getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Object data = RTextPainter.getData(cell, configRegistry);
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry), data);
        return gc.getFontMetrics().getHeight();
    }

    protected void setupGCFromConfig(GC gc, IStyle cellStyle, Object data) {
        Font font;
        Color fg = (Color)cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        if (fg == null) {
            fg = GUIHelper.COLOR_LIST_FOREGROUND;
        }
        if (!(data instanceof ControlData) || (font = (Font)cellStyle.getAttributeValue(CellStyleAttributes.CONTROL_FONT)) == null) {
            font = (Font)cellStyle.getAttributeValue(CellStyleAttributes.FONT);
        }
        gc.setTextAntialias(-1);
        gc.setFont(font);
        gc.setForeground(fg);
    }

    public void paintCell(ILayerCell cell, GC gc, LRectangle lRectangle, IConfigRegistry configRegistry) {
        if (this.paintBg) {
            super.paintCell(cell, gc, lRectangle, configRegistry);
        }
        Rectangle originalClipping = gc.getClipping();
        gc.setClipping(SWTUtil.toSWT((LRectangle)lRectangle).intersection(originalClipping));
        Object data = RTextPainter.getData(cell, configRegistry);
        IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
        this.setupGCFromConfig(gc, cellStyle, data);
        String text = data.toString();
        long width = lRectangle.width - (long)(this.spacing * 2);
        if (gc.getFont() == null) {
            gc.setFont(null);
        }
        int contentHeight = gc.getFontMetrics().getHeight();
        text = this.getTextToDisplay(cell, gc, width, text);
        int contentWidth = this.getWidthFromCache(gc, text);
        gc.drawText(text, GraphicsUtils.safe((long)(lRectangle.x + (long)this.spacing + CellStyleUtil.getHorizontalAlignmentPadding((HorizontalAlignment)(data instanceof ControlData ? HorizontalAlignment.LEFT : (HorizontalAlignment)cellStyle.getAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT)), (long)width, (long)contentWidth))), GraphicsUtils.safe((long)(lRectangle.y + CellStyleUtil.getVerticalAlignmentPadding((VerticalAlignment)VerticalAlignment.MIDDLE, (long)lRectangle.height, (long)contentHeight))), this.swtDrawStyle);
        gc.setClipping(originalClipping);
    }
}

