/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.statet.ecommons.text.core.FragmentDocument;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionUtils;
import org.eclipse.statet.internal.r.ui.editors.RArgumentListContextInformation;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.input.OffsetStringParserInput;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistCompletionInformationProposalWrapper;
import org.eclipse.statet.r.core.model.ArgsDefinition;
import org.eclipse.statet.r.core.rsource.ast.FCall;
import org.eclipse.statet.r.core.rsource.ast.RAsts;
import org.eclipse.statet.r.core.rsource.ast.RParser;
import org.eclipse.statet.r.core.source.RPartitionNodeScanner;
import org.eclipse.statet.r.ui.editors.IRSourceEditor;
import org.eclipse.swt.custom.StyleRange;

@NonNullByDefault
public class RContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private final IRSourceEditor sourceEditor;
    private @Nullable RArgumentListContextInformation info;
    private long scannedArgsStamp;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable FCall.Args scannedArgs;
    private int lastPresentation = -2;

    public RContextInformationValidator(IRSourceEditor sourceEditor) {
        this.sourceEditor = sourceEditor;
    }

    public void install(IContextInformation info, ITextViewer viewer, int offset) {
        if (info instanceof AssistCompletionInformationProposalWrapper) {
            info = ((AssistCompletionInformationProposalWrapper)info).getContextInformation();
        }
        this.scannedArgs = null;
        this.lastPresentation = -2;
        if (!(info instanceof RArgumentListContextInformation) || viewer != this.sourceEditor.getViewer()) {
            this.info = null;
            return;
        }
        this.info = (RArgumentListContextInformation)info;
    }

    public boolean isContextInformationValid(int offset) {
        RArgumentListContextInformation info = this.info;
        if (info == null) {
            return false;
        }
        if (offset < info.getContextInformationPosition() || offset > this.sourceEditor.getViewer().getDocument().getLength()) {
            return false;
        }
        FCall.Args args = this.getScannedArgs();
        if (args != null) {
            return offset <= args.getEndOffset();
        }
        return offset == info.getContextInformationPosition();
    }

    public boolean updatePresentation(int offset, TextPresentation presentation) {
        RArgumentListContextInformation info = this.info;
        if (info == null) {
            return false;
        }
        ArgsDefinition args = info.getArgsDefinition();
        if (args != null && args.size() > 0) {
            int argIdx = this.getCurrentArgInFDef(offset);
            int[] idxs = info.getInformationDisplayStringArgumentIdxs();
            if (argIdx >= 0 && argIdx < idxs.length) {
                if (argIdx == this.lastPresentation) {
                    return false;
                }
                int start = idxs[argIdx];
                int stop = argIdx + 1 < idxs.length ? idxs[argIdx + 1] : info.getInformationDisplayString().length();
                presentation.clear();
                presentation.addStyleRange(new StyleRange(start, stop - start, null, null, 1));
                this.lastPresentation = argIdx;
                return true;
            }
        }
        if (this.lastPresentation >= 0) {
            presentation.clear();
            this.lastPresentation = -1;
            return true;
        }
        return false;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable FCall.Args getScannedArgs() {
        RArgumentListContextInformation info = (RArgumentListContextInformation)ObjectUtils.nonNullAssert((Object)this.info);
        int startOffset = info.getCallArgsOffset();
        AbstractDocument document = (AbstractDocument)this.sourceEditor.getViewer().getDocument();
        int docStartOffset = startOffset;
        if (document instanceof FragmentDocument) {
            FragmentDocument fragmentDoc = (FragmentDocument)document;
            document = fragmentDoc.getMasterDocument();
            docStartOffset += fragmentDoc.getOffsetInMasterDocument();
        }
        if (docStartOffset < 0) {
            docStartOffset = 0;
        }
        long stamp = document.getModificationStamp();
        if (this.scannedArgs == null || this.scannedArgsStamp != stamp) {
            try {
                FCall.Args args = null;
                TreePartitionNode rRootNode = RPartitionNodeScanner.findRRootNode((TreePartitionNode)TreePartitionUtils.getNode((IDocument)document, (String)this.sourceEditor.getDocumentContentInfo().getPartitioning(), (int)docStartOffset, (boolean)true));
                if (rRootNode != null) {
                    int docEndOffset = Math.min(2048, rRootNode.getEndOffset() - docStartOffset);
                    String text = document.get(docStartOffset, docEndOffset);
                    RParser rParser = new RParser(4);
                    args = rParser.scanFCallArgs(new OffsetStringParserInput(text, startOffset).init(startOffset, startOffset + text.length()), true);
                }
                this.scannedArgs = args;
                this.scannedArgsStamp = stamp;
            }
            catch (Exception e) {
                this.scannedArgs = null;
            }
        }
        return this.scannedArgs;
    }

    private int getCurrentArgInFDef(int offset) {
        RAsts.FCallArgMatch match;
        ArgsDefinition.Arg argDef;
        int callArgIdx;
        FCall.Args args = this.getScannedArgs();
        if (args != null && (callArgIdx = RContextInformationValidator.getCurrentArgInFCall(args, offset)) >= 0 && (argDef = (match = RAsts.matchArgs((FCall.Args)args, (ArgsDefinition)this.info.getArgsDefinition())).getArgDef(callArgIdx)) != null) {
            return argDef.index;
        }
        return -1;
    }

    private static int getCurrentArgInFCall(FCall.Args args, int offset) {
        int last = args.getChildCount() - 1;
        if (last == -1) {
            return 0;
        }
        int i = 0;
        while (i < last) {
            if (offset <= args.getSeparatorOffset(i)) {
                return i;
            }
            ++i;
        }
        return last;
    }
}

